
-- BalverineCloseCombo --
CombatSequences.BalverineCloseCombo = {}
CombatSequences.BalverineCloseCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineCloseCombo.IsCombo = true
CombatSequences.BalverineCloseCombo.Zones = {}
CombatSequences.BalverineCloseCombo.Zones[CombatZones.Near] = true
CombatSequences.BalverineCloseCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineCloseCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineCloseCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineCloseCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick1",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick2",
		IsComboBreak = true
	}
}

-- BalverineCombo --
CombatSequences.BalverineCombo = {}
CombatSequences.BalverineCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineCombo.IsCombo = true
CombatSequences.BalverineCombo.Zones = {}
CombatSequences.BalverineCombo.Zones[CombatZones.Near] = true
CombatSequences.BalverineCombo.Zones[CombatZones.Middle] = true
CombatSequences.BalverineCombo.Zones[CombatZones.Far] = true
CombatSequences.BalverineCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BalverineCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick1",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick2",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		IsComboBreak = true
	}
}

-- BalverineFrenzy --
CombatSequences.BalverineFrenzy = {}
CombatSequences.BalverineFrenzy.CounterAttack = true
CombatSequences.BalverineFrenzy.Priority = SequencePriorities.Attack
CombatSequences.BalverineFrenzy.Zones = {}
CombatSequences.BalverineFrenzy.Zones[CombatZones.Near] = true
CombatSequences.BalverineFrenzy.Zones[CombatZones.Middle] = true
CombatSequences.BalverineFrenzy.ZonesWhilePlaying = {}
CombatSequences.BalverineFrenzy.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineFrenzy.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineFrenzy.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackFrenzyNormalSpeed",
		SpeedMultiplier = 1.1,
		PushBackStrike = 0.2,
		DamageMultiplier = 0.25
	}
}

-- BalverineFrenzyLowHealth --
CombatSequences.BalverineFrenzyLowHealth = {}
CombatSequences.BalverineFrenzyLowHealth.CounterAttack = true
CombatSequences.BalverineFrenzyLowHealth.Priority = SequencePriorities.Attack
CombatSequences.BalverineFrenzyLowHealth.Zones = {}
CombatSequences.BalverineFrenzyLowHealth.Zones[CombatZones.Near] = true
CombatSequences.BalverineFrenzyLowHealth.Zones[CombatZones.Middle] = true
CombatSequences.BalverineFrenzyLowHealth.ZonesWhilePlaying = {}
CombatSequences.BalverineFrenzyLowHealth.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineFrenzyLowHealth.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineFrenzyLowHealth.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackFrenzyNormalSpeed",
		SpeedMultiplier = 1.1,
		PushBackStrike = 0.2,
		DamageMultiplier = 0.25
	}
}
CombatSequences.BalverineFrenzyLowHealth.IsValid = Predicate.CreatureHasHealthBelow(40)

-- BalverinePostJumpCombo --
CombatSequences.BalverinePostJumpCombo = {}
CombatSequences.BalverinePostJumpCombo.CounterAttack = true
CombatSequences.BalverinePostJumpCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverinePostJumpCombo.IsCombo = true
CombatSequences.BalverinePostJumpCombo.IsValid = Predicate.HasBalverineJustJumped
CombatSequences.BalverinePostJumpCombo.Zones = {}
CombatSequences.BalverinePostJumpCombo.Zones[CombatZones.Near] = true
CombatSequences.BalverinePostJumpCombo.Zones[CombatZones.Middle] = true
CombatSequences.BalverinePostJumpCombo.ZonesWhilePlaying = {}
CombatSequences.BalverinePostJumpCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverinePostJumpCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverinePostJumpCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		IsComboBreak = true
	}
}

-- BalverinePostJumpFarCombo --
CombatSequences.BalverinePostJumpFarCombo = {}
CombatSequences.BalverinePostJumpFarCombo.CounterAttack = true
CombatSequences.BalverinePostJumpFarCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverinePostJumpFarCombo.IsCombo = true
CombatSequences.BalverinePostJumpFarCombo.IsValid = Predicate.HasBalverineJustJumped
CombatSequences.BalverinePostJumpFarCombo.Zones = {}
CombatSequences.BalverinePostJumpFarCombo.Zones[CombatZones.Far] = true
CombatSequences.BalverinePostJumpFarCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		HitOutsideAttackArc = true
	}
}

-- BalverineAttackAfterDodge --
CombatSequences.BalverineAttackAfterDodge = {}
CombatSequences.BalverineAttackAfterDodge.CounterAttack = true
CombatSequences.BalverineAttackAfterDodge.IsCombo = true
CombatSequences.BalverineAttackAfterDodge.Priority = SequencePriorities.Attack
CombatSequences.BalverineAttackAfterDodge.Zones = {}
CombatSequences.BalverineAttackAfterDodge.Zones[CombatZones.Near] = true
CombatSequences.BalverineAttackAfterDodge.Zones[CombatZones.Middle] = true
CombatSequences.BalverineAttackAfterDodge.Zones[CombatZones.Far] = true
CombatSequences.BalverineAttackAfterDodge.ZonesWhilePlaying = {}
CombatSequences.BalverineAttackAfterDodge.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineAttackAfterDodge.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineAttackAfterDodge.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BalverineAttackAfterDodge.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		HitOutsideAttackArc = true
	}
}

-- BalverineShotCausedClaw --
CombatSequences.BalverineShotCausedClaw = {}
CombatSequences.BalverineShotCausedClaw.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(40, EAttackType.ATTACK_RANGED, 5)
CombatSequences.BalverineShotCausedClaw.CounterAttack = true
CombatSequences.BalverineShotCausedClaw.IsCombo = true
CombatSequences.BalverineShotCausedClaw.Priority = SequencePriorities.Attack
CombatSequences.BalverineShotCausedClaw.Zones = {}
CombatSequences.BalverineShotCausedClaw.Zones[CombatZones.Middle] = true
CombatSequences.BalverineShotCausedClaw.Zones[CombatZones.Far] = true
CombatSequences.BalverineShotCausedClaw.Zones[CombatZones.OuterRing] = true
CombatSequences.BalverineShotCausedClaw.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		FaceTarget = false,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick1",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick2",
		IsComboBreak = true
	}
}

-- BalverineMagicedCausedClaw --
CombatSequences.BalverineMagicedCausedClaw = {}
CombatSequences.BalverineMagicedCausedClaw.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(40, EAttackType.ATTACK_SPELL, 5)
CombatSequences.BalverineMagicedCausedClaw.CounterAttack = true
CombatSequences.BalverineMagicedCausedClaw.IsCombo = true
CombatSequences.BalverineMagicedCausedClaw.Priority = SequencePriorities.Attack
CombatSequences.BalverineMagicedCausedClaw.Zones = {}
CombatSequences.BalverineMagicedCausedClaw.Zones[CombatZones.Middle] = true
CombatSequences.BalverineMagicedCausedClaw.Zones[CombatZones.Far] = true
CombatSequences.BalverineMagicedCausedClaw.Zones[CombatZones.OuterRing] = true
CombatSequences.BalverineMagicedCausedClaw.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick1",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick2",
		IsComboBreak = true
	}
}

-- BalverineOrbSuckingResponse --
CombatSequences.BalverineOrbSuckingResponse = {}
CombatSequences.BalverineOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BalverineOrbSuckingResponse.CounterAttack = true
CombatSequences.BalverineOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BalverineOrbSuckingResponse.Zones = {}
CombatSequences.BalverineOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BalverineOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BalverineOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.BalverineOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		HitOutsideAttackArc = true
	}
}

-- BalverineBloodedCloseCombo --
CombatSequences.BalverineBloodedCloseCombo = {}
CombatSequences.BalverineBloodedCloseCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedCloseCombo.IsCombo = true
CombatSequences.BalverineBloodedCloseCombo.Zones = {}
CombatSequences.BalverineBloodedCloseCombo.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedCloseCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineBloodedCloseCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineBloodedCloseCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineBloodedCloseCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		IsComboBreak = true,
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		IsComboBreak = true,
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		IsComboBreak = true,
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		IsComboBreak = true,
		SpeedMultiplier = 1.1
	}
}

-- BalverineBloodedCombo --
CombatSequences.BalverineBloodedCombo = {}
CombatSequences.BalverineBloodedCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedCombo.IsCombo = true
CombatSequences.BalverineBloodedCombo.Zones = {}
CombatSequences.BalverineBloodedCombo.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedCombo.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedCombo.Zones[CombatZones.Far] = true
CombatSequences.BalverineBloodedCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineBloodedCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineBloodedCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineBloodedCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BalverineBloodedCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- BalverineBloodedFrenzy --
CombatSequences.BalverineBloodedFrenzy = {}
CombatSequences.BalverineBloodedFrenzy.CounterAttack = true
CombatSequences.BalverineBloodedFrenzy.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedFrenzy.Zones = {}
CombatSequences.BalverineBloodedFrenzy.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedFrenzy.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedFrenzy.ZonesWhilePlaying = {}
CombatSequences.BalverineBloodedFrenzy.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineBloodedFrenzy.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineBloodedFrenzy.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackFrenzyNormalSpeed",
		SpeedMultiplier = 1.2,
		PushBackStrike = 0.2,
		DamageMultiplier = 0.25
	}
}

-- BalverineBloodedFrenzyLowHealth --
CombatSequences.BalverineBloodedFrenzyLowHealth = {}
CombatSequences.BalverineBloodedFrenzyLowHealth.CounterAttack = true
CombatSequences.BalverineBloodedFrenzyLowHealth.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedFrenzyLowHealth.Zones = {}
CombatSequences.BalverineBloodedFrenzyLowHealth.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedFrenzyLowHealth.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedFrenzyLowHealth.ZonesWhilePlaying = {}
CombatSequences.BalverineBloodedFrenzyLowHealth.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineBloodedFrenzyLowHealth.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineBloodedFrenzyLowHealth.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackFrenzyNormalSpeed",
		SpeedMultiplier = 1.2,
		PushBackStrike = 0.2,
		DamageMultiplier = 0.25
	}
}
CombatSequences.BalverineBloodedFrenzyLowHealth.IsValid = Predicate.CreatureHasHealthBelow(40)

-- BalverineBloodedAttackAfterDodge --
CombatSequences.BalverineBloodedAttackAfterDodge = {}
CombatSequences.BalverineBloodedAttackAfterDodge.CounterAttack = true
CombatSequences.BalverineBloodedAttackAfterDodge.IsCombo = true
CombatSequences.BalverineBloodedAttackAfterDodge.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedAttackAfterDodge.Zones = {}
CombatSequences.BalverineBloodedAttackAfterDodge.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedAttackAfterDodge.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedAttackAfterDodge.Zones[CombatZones.Far] = true
CombatSequences.BalverineBloodedAttackAfterDodge.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- BalverineBloodedPostJumpCombo --
CombatSequences.BalverineBloodedPostJumpCombo = {}
CombatSequences.BalverineBloodedPostJumpCombo.CounterAttack = true
CombatSequences.BalverineBloodedPostJumpCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedPostJumpCombo.IsCombo = true
CombatSequences.BalverineBloodedPostJumpCombo.IsValid = Predicate.HasBalverineJustJumped
CombatSequences.BalverineBloodedPostJumpCombo.Zones = {}
CombatSequences.BalverineBloodedPostJumpCombo.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedPostJumpCombo.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedPostJumpCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineBloodedPostJumpCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineBloodedPostJumpCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineBloodedPostJumpCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- BalverineBloodedAttackAfterDodge --
CombatSequences.BalverineBloodedAttackAfterDodge = {}
CombatSequences.BalverineBloodedAttackAfterDodge.CounterAttack = true
CombatSequences.BalverineBloodedAttackAfterDodge.IsCombo = true
CombatSequences.BalverineBloodedAttackAfterDodge.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedAttackAfterDodge.IsValid = Predicate.HasBalverineJustJumped
CombatSequences.BalverineBloodedAttackAfterDodge.Zones = {}
CombatSequences.BalverineBloodedAttackAfterDodge.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedAttackAfterDodge.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedAttackAfterDodge.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- BalverineBloodedShotCausedClaw --
CombatSequences.BalverineBloodedShotCausedClaw = {}
CombatSequences.BalverineBloodedShotCausedClaw.CounterAttack = true
CombatSequences.BalverineBloodedShotCausedClaw.IsCombo = true
CombatSequences.BalverineBloodedShotCausedClaw.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedShotCausedClaw.IsValid = Predicate.HasBalverineJustJumped
CombatSequences.BalverineBloodedShotCausedClaw.Zones = {}
CombatSequences.BalverineBloodedShotCausedClaw.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedShotCausedClaw.Zones[CombatZones.Far] = true
CombatSequences.BalverineBloodedShotCausedClaw.Zones[CombatZones.OuterRing] = true
CombatSequences.BalverineBloodedShotCausedClaw.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		FaceTarget = false,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick1",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick2",
		IsComboBreak = true
	}
}

-- BalverineBloodedMagicedCausedClaw --
CombatSequences.BalverineBloodedMagicedCausedClaw = {}
CombatSequences.BalverineBloodedMagicedCausedClaw.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(40, EAttackType.ATTACK_SPELL, 5)
CombatSequences.BalverineBloodedMagicedCausedClaw.CounterAttack = true
CombatSequences.BalverineBloodedMagicedCausedClaw.IsCombo = true
CombatSequences.BalverineBloodedMagicedCausedClaw.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedMagicedCausedClaw.Zones = {}
CombatSequences.BalverineBloodedMagicedCausedClaw.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedMagicedCausedClaw.Zones[CombatZones.Far] = true
CombatSequences.BalverineBloodedMagicedCausedClaw.Zones[CombatZones.OuterRing] = true
CombatSequences.BalverineBloodedMagicedCausedClaw.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		FaceTarget = false,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick1",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick2",
		IsComboBreak = true
	}
}

-- BalverineBloodedHeroFlourishResponse --
CombatSequences.BalverineBloodedHeroFlourishResponse = {}
CombatSequences.BalverineBloodedHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.BalverineBloodedHeroFlourishResponse.CounterAttack = true
CombatSequences.BalverineBloodedHeroFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedHeroFlourishResponse.Zones = {}
CombatSequences.BalverineBloodedHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedHeroFlourishResponse.Zones[CombatZones.Far] = true
CombatSequences.BalverineBloodedHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.2
	}
}

-- BalverineLeftAttack --
CombatSequences.BalverineLeftAttack = {}
CombatSequences.BalverineLeftAttack.Priority = SequencePriorities.Attack
CombatSequences.BalverineLeftAttack.IsCombo = true
CombatSequences.BalverineLeftAttack.Zones = {}
CombatSequences.BalverineLeftAttack.Zones[CombatZones.Left] = true
CombatSequences.BalverineLeftAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true,
		FaceTarget = false,
		AdditionalTurning = true
	}
}

-- BalverineRightAttack --
CombatSequences.BalverineRightAttack = {}
CombatSequences.BalverineRightAttack.Priority = SequencePriorities.Attack
CombatSequences.BalverineRightAttack.IsCombo = true
CombatSequences.BalverineRightAttack.Zones = {}
CombatSequences.BalverineRightAttack.Zones[CombatZones.Right] = true
CombatSequences.BalverineRightAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		HitOutsideAttackArc = true,
		FaceTarget = false,
		AdditionalTurning = true
	}
}

-- BalverineRearAttack --
CombatSequences.BalverineRearAttack = {}
CombatSequences.BalverineRearAttack.Priority = SequencePriorities.Attack
CombatSequences.BalverineRearAttack.IsCombo = true
CombatSequences.BalverineRearAttack.Zones = {}
CombatSequences.BalverineRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.BalverineRearAttack.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards",
		TurnPerMetre = 90
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight"
	}
}

-- BalverineBloodedOrbSuckingResponse --
CombatSequences.BalverineBloodedOrbSuckingResponse = {}
CombatSequences.BalverineBloodedOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BalverineBloodedOrbSuckingResponse.CounterAttack = true
CombatSequences.BalverineBloodedOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BalverineBloodedOrbSuckingResponse.Zones = {}
CombatSequences.BalverineBloodedOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BalverineBloodedOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BalverineBloodedOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.BalverineBloodedOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true
	}
}

-- BalverineSireCloseCombo --
CombatSequences.BalverineSireCloseCombo = {}
CombatSequences.BalverineSireCloseCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireCloseCombo.IsCombo = true
CombatSequences.BalverineSireCloseCombo.Zones = {}
CombatSequences.BalverineSireCloseCombo.Zones[CombatZones.Near] = true
CombatSequences.BalverineSireCloseCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineSireCloseCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineSireCloseCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineSireCloseCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- BalverineSireCombo --
CombatSequences.BalverineSireCombo = {}
CombatSequences.BalverineSireCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireCombo.IsCombo = true
CombatSequences.BalverineSireCombo.Zones = {}
CombatSequences.BalverineSireCombo.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineSireCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineSireCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineSireCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- BalverineSireFarCombo --
CombatSequences.BalverineSireFarCombo = {}
CombatSequences.BalverineSireFarCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireFarCombo.IsCombo = true
CombatSequences.BalverineSireFarCombo.Zones = {}
CombatSequences.BalverineSireFarCombo.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireFarCombo.Zones[CombatZones.Far] = true
CombatSequences.BalverineSireFarCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineSireFarCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineSireFarCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineSireFarCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BalverineSireFarCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- BalverineSireFrenzy --
CombatSequences.BalverineSireFrenzy = {}
CombatSequences.BalverineSireFrenzy.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireFrenzy.IsCombo = true
CombatSequences.BalverineSireFrenzy.Zones = {}
CombatSequences.BalverineSireFrenzy.Zones[CombatZones.Near] = true
CombatSequences.BalverineSireFrenzy.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireFrenzy.ZonesWhilePlaying = {}
CombatSequences.BalverineSireFrenzy.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineSireFrenzy.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineSireFrenzy.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackFrenzyNormalSpeed",
		SpeedMultiplier = 1.3,
		PushBackStrike = 0.2,
		DamageMultiplier = 0.25
	}
}

-- BalverineSireFrenzyLowHealth --
CombatSequences.BalverineSireFrenzyLowHealth = {}
CombatSequences.BalverineSireFrenzyLowHealth.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireFrenzyLowHealth.IsCombo = true
CombatSequences.BalverineSireFrenzyLowHealth.Zones = {}
CombatSequences.BalverineSireFrenzyLowHealth.Zones[CombatZones.Near] = true
CombatSequences.BalverineSireFrenzyLowHealth.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireFrenzyLowHealth.ZonesWhilePlaying = {}
CombatSequences.BalverineSireFrenzyLowHealth.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineSireFrenzyLowHealth.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineSireFrenzyLowHealth.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackFrenzyNormalSpeed",
		SpeedMultiplier = 1.3,
		PushBackStrike = 0.2,
		DamageMultiplier = 0.25
	}
}
CombatSequences.BalverineSireFrenzyLowHealth.IsValid = Predicate.CreatureHasHealthBelow(30)

-- BalverineSireAttackAfterDodge --
CombatSequences.BalverineSireAttackAfterDodge = {}
CombatSequences.BalverineSireAttackAfterDodge.CounterAttack = true
CombatSequences.BalverineSireAttackAfterDodge.IsCombo = true
CombatSequences.BalverineSireAttackAfterDodge.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireAttackAfterDodge.Zones = {}
CombatSequences.BalverineSireAttackAfterDodge.Zones[CombatZones.Near] = true
CombatSequences.BalverineSireAttackAfterDodge.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireAttackAfterDodge.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	}
}

-- BalverineSirePostJumpCombo --
CombatSequences.BalverineSirePostJumpCombo = {}
CombatSequences.BalverineSirePostJumpCombo.CounterAttack = true
CombatSequences.BalverineSirePostJumpCombo.Priority = SequencePriorities.Attack
CombatSequences.BalverineSirePostJumpCombo.IsCombo = true
CombatSequences.BalverineSirePostJumpCombo.IsValid = Predicate.HasBalverineJustJumped
CombatSequences.BalverineSirePostJumpCombo.Zones = {}
CombatSequences.BalverineSirePostJumpCombo.Zones[CombatZones.Near] = true
CombatSequences.BalverineSirePostJumpCombo.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSirePostJumpCombo.ZonesWhilePlaying = {}
CombatSequences.BalverineSirePostJumpCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BalverineSirePostJumpCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BalverineSirePostJumpCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	}
}

-- BalverineSireAttackAfterDodge --
CombatSequences.BalverineSireAttackAfterDodge = {}
CombatSequences.BalverineSireAttackAfterDodge.CounterAttack = true
CombatSequences.BalverineSireAttackAfterDodge.IsCombo = true
CombatSequences.BalverineSireAttackAfterDodge.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireAttackAfterDodge.IsValid = Predicate.HasBalverineJustJumped
CombatSequences.BalverineSireAttackAfterDodge.Zones = {}
CombatSequences.BalverineSireAttackAfterDodge.Zones[CombatZones.Near] = true
CombatSequences.BalverineSireAttackAfterDodge.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireAttackAfterDodge.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	}
}

-- BalverineSireShotCausedClaw --
CombatSequences.BalverineSireShotCausedClaw = {}
CombatSequences.BalverineSireShotCausedClaw.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(40, EAttackType.ATTACK_RANGED, 5)
CombatSequences.BalverineSireShotCausedClaw.CounterAttack = true
CombatSequences.BalverineSireShotCausedClaw.IsCombo = true
CombatSequences.BalverineSireShotCausedClaw.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireShotCausedClaw.Zones = {}
CombatSequences.BalverineSireShotCausedClaw.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireShotCausedClaw.Zones[CombatZones.Far] = true
CombatSequences.BalverineSireShotCausedClaw.Zones[CombatZones.OuterRing] = true
CombatSequences.BalverineSireShotCausedClaw.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		FaceTarget = false,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick1",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick2",
		IsComboBreak = true
	}
}

-- BalverineSireMagicedCausedClaw --
CombatSequences.BalverineSireMagicedCausedClaw = {}
CombatSequences.BalverineSireMagicedCausedClaw.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(40, EAttackType.ATTACK_SPELL, 5)
CombatSequences.BalverineSireMagicedCausedClaw.CounterAttack = true
CombatSequences.BalverineSireMagicedCausedClaw.IsCombo = true
CombatSequences.BalverineSireMagicedCausedClaw.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireMagicedCausedClaw.Zones = {}
CombatSequences.BalverineSireMagicedCausedClaw.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireMagicedCausedClaw.Zones[CombatZones.Far] = true
CombatSequences.BalverineSireMagicedCausedClaw.Zones[CombatZones.OuterRing] = true
CombatSequences.BalverineSireMagicedCausedClaw.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackPounce",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		FaceTarget = false,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick1",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeQuick2",
		IsComboBreak = true
	}
}

-- BalverineSireHeroFlourishResponse --
CombatSequences.BalverineSireHeroFlourishResponse = {}
CombatSequences.BalverineSireHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.BalverineSireHeroFlourishResponse.CounterAttack = true
CombatSequences.BalverineSireHeroFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireHeroFlourishResponse.Zones = {}
CombatSequences.BalverineSireHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.BalverineSireHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	}
}

-- BalverineSireOrbSuckingResponse --
CombatSequences.BalverineSireOrbSuckingResponse = {}
CombatSequences.BalverineSireOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BalverineSireOrbSuckingResponse.CounterAttack = true
CombatSequences.BalverineSireOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BalverineSireOrbSuckingResponse.Zones = {}
CombatSequences.BalverineSireOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BalverineSireOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BalverineSireOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.BalverineSireOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	}
}


-- uncomment for debug
-- GUI.DisplayMessageBox("balverinesequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end
