
-- BanditGoad --
CombatSequences.BanditGoad = {}
CombatSequences.BanditGoad.Priority = SequencePriorities.Idle
CombatSequences.BanditGoad.Zones = {}
CombatSequences.BanditGoad.Zones[CombatZones.Middle] = true
CombatSequences.BanditGoad.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1
	}
}

-- BanditOuterGoad --
CombatSequences.BanditOuterGoad = {}
CombatSequences.BanditOuterGoad.Priority = SequencePriorities.Idle
CombatSequences.BanditOuterGoad.Zones = {}
CombatSequences.BanditOuterGoad.Zones[CombatZones.OuterRing] = true
CombatSequences.BanditOuterGoad.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "OuterGoad",
		SpeedMultiplier = 1
	}
}

-- BanditGoadAfterAttack --
CombatSequences.BanditGoadAfterAttack = {}
CombatSequences.BanditGoadAfterAttack.Priority = SequencePriorities.PreferredIdle
CombatSequences.BanditGoadAfterAttack.Zones = {}
CombatSequences.BanditGoadAfterAttack.Zones[CombatZones.Middle] = true
CombatSequences.BanditGoadAfterAttack.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1
	}
}
CombatSequences.BanditGoadAfterAttack.IsValid = Predicate.CreateHasTargetBeenAttackedRecentlyPredicate(5)

-- BanditFastBackOff --
CombatSequences.BanditFastBackOff = {}
CombatSequences.BanditFastBackOff.Priority = SequencePriorities.Movement
CombatSequences.BanditFastBackOff.Zones = {}
CombatSequences.BanditFastBackOff.Zones[CombatZones.Near] = true
CombatSequences.BanditFastBackOff.Zones[CombatZones.Middle] = true
CombatSequences.BanditFastBackOff.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "FastBackOff",
		SpeedMultiplier = 1
	}
}

-- BanditEasyCloseAttackCombo --
CombatSequences.BanditEasyCloseAttackCombo = {}
CombatSequences.BanditEasyCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditEasyCloseAttackCombo.IsCombo = true
CombatSequences.BanditEasyCloseAttackCombo.Zones = {}
CombatSequences.BanditEasyCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.BanditEasyCloseAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditEasyCloseAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditEasyCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 0.9
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 0.9
	}
}

-- BanditEasyAttackCombo --
CombatSequences.BanditEasyAttackCombo = {}
CombatSequences.BanditEasyAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditEasyAttackCombo.IsCombo = true
CombatSequences.BanditEasyAttackCombo.Zones = {}
CombatSequences.BanditEasyAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.BanditEasyAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditEasyAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditEasyAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditEasyAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 0.9
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 0.9,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 0.9
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance",
		SpeedMultiplier = 1
	}
}

-- BanditEasyFarAttackCombo --
CombatSequences.BanditEasyFarAttackCombo = {}
CombatSequences.BanditEasyFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditEasyFarAttackCombo.IsCombo = true
CombatSequences.BanditEasyFarAttackCombo.Zones = {}
CombatSequences.BanditEasyFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.BanditEasyFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditEasyFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditEasyFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditEasyFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditEasyFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 0.9
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 0.9,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 0.9
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- BanditEasyOrbSuckingResponse --
CombatSequences.BanditEasyOrbSuckingResponse = {}
CombatSequences.BanditEasyOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BanditEasyOrbSuckingResponse.CounterAttack = true
CombatSequences.BanditEasyOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditEasyOrbSuckingResponse.Zones = {}
CombatSequences.BanditEasyOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditEasyOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditEasyOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.BanditEasyOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1
	}
}

-- BanditCloseAttackCombo --
CombatSequences.BanditCloseAttackCombo = {}
CombatSequences.BanditCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditCloseAttackCombo.IsCombo = true
CombatSequences.BanditCloseAttackCombo.Zones = {}
CombatSequences.BanditCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.BanditCloseAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditCloseAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- BanditAttackCombo --
CombatSequences.BanditAttackCombo = {}
CombatSequences.BanditAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditAttackCombo.IsCombo = true
CombatSequences.BanditAttackCombo.Zones = {}
CombatSequences.BanditAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.BanditAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance",
		SpeedMultiplier = 1
	}
}

-- BanditFarAttackCombo --
CombatSequences.BanditFarAttackCombo = {}
CombatSequences.BanditFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditFarAttackCombo.IsCombo = true
CombatSequences.BanditFarAttackCombo.Zones = {}
CombatSequences.BanditFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.BanditFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- BanditHeroFlourishResponse --
CombatSequences.BanditHeroFlourishResponse = {}
CombatSequences.BanditHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.BanditHeroFlourishResponse.CounterAttack = true
CombatSequences.BanditHeroFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditHeroFlourishResponse.Zones = {}
CombatSequences.BanditHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditHeroFlourishResponse.Zones[CombatZones.Far] = true
CombatSequences.BanditHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1
	}
}

-- BanditOrbSuckingResponse --
CombatSequences.BanditOrbSuckingResponse = {}
CombatSequences.BanditOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BanditOrbSuckingResponse.CounterAttack = true
CombatSequences.BanditOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditOrbSuckingResponse.Zones = {}
CombatSequences.BanditOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.BanditOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		SpeedMultiplier = 1
	}
}

-- BanditEliteFastBackOff --
CombatSequences.BanditEliteFastBackOff = {}
CombatSequences.BanditEliteFastBackOff.Priority = SequencePriorities.Movement
CombatSequences.BanditEliteFastBackOff.Zones = {}
CombatSequences.BanditEliteFastBackOff.Zones[CombatZones.Near] = true
CombatSequences.BanditEliteFastBackOff.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "FastBackOff",
		SpeedMultiplier = 2
	}
}

-- BanditEliteCloseAttackCombo --
CombatSequences.BanditEliteCloseAttackCombo = {}
CombatSequences.BanditEliteCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditEliteCloseAttackCombo.IsCombo = true
CombatSequences.BanditEliteCloseAttackCombo.Zones = {}
CombatSequences.BanditEliteCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.BanditEliteCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- BanditEliteAttackCombo --
CombatSequences.BanditEliteAttackCombo = {}
CombatSequences.BanditEliteAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditEliteAttackCombo.IsCombo = true
CombatSequences.BanditEliteAttackCombo.Zones = {}
CombatSequences.BanditEliteAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.BanditEliteAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditEliteAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditEliteAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditEliteAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance",
		SpeedMultiplier = 1
	}
}

-- BanditEliteFarAttackCombo --
CombatSequences.BanditEliteFarAttackCombo = {}
CombatSequences.BanditEliteFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditEliteFarAttackCombo.IsCombo = true
CombatSequences.BanditEliteFarAttackCombo.Zones = {}
CombatSequences.BanditEliteFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.BanditEliteFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditEliteFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- BanditInteruptSpellMelee --
CombatSequences.BanditInteruptSpellMelee = {}
CombatSequences.BanditInteruptSpellMelee.IsValid = Predicate.CreateIsTargetChargingSpellOfAtLeastLevelPredicate(2)
CombatSequences.BanditInteruptSpellMelee.Priority = SequencePriorities.Attack
CombatSequences.BanditInteruptSpellMelee.Zones = {}
CombatSequences.BanditInteruptSpellMelee.Zones[CombatZones.Near] = true
CombatSequences.BanditInteruptSpellMelee.Zones[CombatZones.Middle] = true
CombatSequences.BanditInteruptSpellMelee.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	}
}

-- BanditEliteOrbSuckingResponse --
CombatSequences.BanditEliteOrbSuckingResponse = {}
CombatSequences.BanditEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BanditEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.BanditEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditEliteOrbSuckingResponse.Zones = {}
CombatSequences.BanditEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditEliteOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.BanditEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.1
	}
}

-- BanditLeaderCloseAttackCombo --
CombatSequences.BanditLeaderCloseAttackCombo = {}
CombatSequences.BanditLeaderCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderCloseAttackCombo.IsCombo = true
CombatSequences.BanditLeaderCloseAttackCombo.Zones = {}
CombatSequences.BanditLeaderCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2
	}
}

-- BanditLeaderAttackCombo --
CombatSequences.BanditLeaderAttackCombo = {}
CombatSequences.BanditLeaderAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderAttackCombo.IsCombo = true
CombatSequences.BanditLeaderAttackCombo.Zones = {}
CombatSequences.BanditLeaderAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderAttackCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.2
	}
}

-- BanditLeaderFlourishLeft --
CombatSequences.BanditLeaderFlourishLeft = {}
CombatSequences.BanditLeaderFlourishLeft.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFlourishLeft.Zones = {}
CombatSequences.BanditLeaderFlourishLeft.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderFlourishLeft.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderFlourishLeft.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderFlourishLeft.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderFlourishLeft.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2.4,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.1
	}
}

-- BanditLeaderAttackOutOfBlockShort --
CombatSequences.BanditLeaderAttackOutOfBlockShort = {}
CombatSequences.BanditLeaderAttackOutOfBlockShort.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.BanditLeaderAttackOutOfBlockShort.CounterAttack = true
CombatSequences.BanditLeaderAttackOutOfBlockShort.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderAttackOutOfBlockShort.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BanditLeaderAttackOutOfBlockShort.Zones = {}
CombatSequences.BanditLeaderAttackOutOfBlockShort.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderAttackOutOfBlockShort.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderAttackOutOfBlockShort.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderAttackOutOfBlockShort.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	}
}

-- BanditLeaderAttackOutOfBlock --
CombatSequences.BanditLeaderAttackOutOfBlock = {}
CombatSequences.BanditLeaderAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.BanditLeaderAttackOutOfBlock.CounterAttack = true
CombatSequences.BanditLeaderAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BanditLeaderAttackOutOfBlock.Zones = {}
CombatSequences.BanditLeaderAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	}
}

-- BanditLeaderCounterAttackBlockBreaker --
CombatSequences.BanditLeaderCounterAttackBlockBreaker = {}
CombatSequences.BanditLeaderCounterAttackBlockBreaker.IsValid = Predicate.AND(
	{
		Predicate.IsActiveAttacker,
		Predicate.HasTargetBlockedThisManyStrikesRecently(2)
	}
)
CombatSequences.BanditLeaderCounterAttackBlockBreaker.CounterAttack = true
CombatSequences.BanditLeaderCounterAttackBlockBreaker.Priority = SequencePriorities.Idle
CombatSequences.BanditLeaderCounterAttackBlockBreaker.Zones = {}
CombatSequences.BanditLeaderCounterAttackBlockBreaker.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderCounterAttackBlockBreaker.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderCounterAttackBlockBreaker.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		SpeedMultiplier = 1.1
	}
}

-- BanditAntiSpamCounterAttack --
CombatSequences.BanditAntiSpamCounterAttack = {}
CombatSequences.BanditAntiSpamCounterAttack.IsValid = Predicate.CreateHaveIBeenStruckALotPredicate(4)
CombatSequences.BanditAntiSpamCounterAttack.CounterAttack = true
CombatSequences.BanditAntiSpamCounterAttack.Priority = SequencePriorities.Idle
CombatSequences.BanditAntiSpamCounterAttack.Zones = {}
CombatSequences.BanditAntiSpamCounterAttack.Zones[CombatZones.Near] = true
CombatSequences.BanditAntiSpamCounterAttack.Zones[CombatZones.Middle] = true
CombatSequences.BanditAntiSpamCounterAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.1
	}
}

-- BanditLeaderOrbSuckingResponse --
CombatSequences.BanditLeaderOrbSuckingResponse = {}
CombatSequences.BanditLeaderOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BanditLeaderOrbSuckingResponse.CounterAttack = true
CombatSequences.BanditLeaderOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderOrbSuckingResponse.Zones = {}
CombatSequences.BanditLeaderOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	}
}

-- BanditLeaderEliteCloseAttackCombo --
CombatSequences.BanditLeaderEliteCloseAttackCombo = {}
CombatSequences.BanditLeaderEliteCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderEliteCloseAttackCombo.IsCombo = true
CombatSequences.BanditLeaderEliteCloseAttackCombo.Zones = {}
CombatSequences.BanditLeaderEliteCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderEliteCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3
	}
}

-- BanditLeaderEliteAttackCombo --
CombatSequences.BanditLeaderEliteAttackCombo = {}
CombatSequences.BanditLeaderEliteAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderEliteAttackCombo.IsCombo = true
CombatSequences.BanditLeaderEliteAttackCombo.Zones = {}
CombatSequences.BanditLeaderEliteAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderEliteAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderEliteAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.3
	}
}

-- BanditLeaderEliteFlourishLeft --
CombatSequences.BanditLeaderEliteFlourishLeft = {}
CombatSequences.BanditLeaderEliteFlourishLeft.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderEliteFlourishLeft.Zones = {}
CombatSequences.BanditLeaderEliteFlourishLeft.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteFlourishLeft.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderEliteFlourishLeft.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderEliteFlourishLeft.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteFlourishLeft.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderEliteFlourishLeft.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- BanditLeaderEliteAttackOutOfBlockShort --
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort = {}
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.CounterAttack = true
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.Zones = {}
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlockShort.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		FaceTarget = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- BanditLeaderEliteAttackOutOfBlock --
CombatSequences.BanditLeaderEliteAttackOutOfBlock = {}
CombatSequences.BanditLeaderEliteAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.BanditLeaderEliteAttackOutOfBlock.CounterAttack = true
CombatSequences.BanditLeaderEliteAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderEliteAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BanditLeaderEliteAttackOutOfBlock.Zones = {}
CombatSequences.BanditLeaderEliteAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderEliteAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderEliteAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- BanditGroupRifleShooting --
CombatSequences.BanditGroupRifleShooting = {}
CombatSequences.BanditGroupRifleShooting.IsValid = Predicate.AND(
	{
		Predicate.GroupOrderIsShoot,
		Predicate.IsCarryingWeaponOfType(WeaponTypes.Ranged)
	}
)
CombatSequences.BanditGroupRifleShooting.CounterAttack = true
CombatSequences.BanditGroupRifleShooting.Priority = SequencePriorities.PreferredAttack
CombatSequences.BanditGroupRifleShooting.Zones = {}
CombatSequences.BanditGroupRifleShooting.Zones[CombatZones.OuterRing] = true
CombatSequences.BanditGroupRifleShooting.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "IntoAim"
	},
	{
		Type = EScriptableAction.SHOOT,
		Knockdown = false
	}
}

-- BanditGroupMeleeAttack --
CombatSequences.BanditGroupMeleeAttack = {}
CombatSequences.BanditGroupMeleeAttack.IsValid = Predicate.AND(
	{
		Predicate.GroupOrderIsStrike,
		Predicate.IsCarryingWeaponOfType(WeaponTypes.Melee)
	}
)
CombatSequences.BanditGroupMeleeAttack.CounterAttack = true
CombatSequences.BanditGroupMeleeAttack.Priority = SequencePriorities.PreferredAttack
CombatSequences.BanditGroupMeleeAttack.Zones = {}
CombatSequences.BanditGroupMeleeAttack.Zones[CombatZones.Near] = true
CombatSequences.BanditGroupMeleeAttack.Zones[CombatZones.Middle] = true
CombatSequences.BanditGroupMeleeAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- BanditLeaderInteruptSpellRanged --
CombatSequences.BanditLeaderInteruptSpellRanged = {}
CombatSequences.BanditLeaderInteruptSpellRanged.IsValid = Predicate.CreateIsTargetChargingSpellOfAtLeastLevelPredicate(1)
CombatSequences.BanditLeaderInteruptSpellRanged.Priority = SequencePriorities.PreferredAttack
CombatSequences.BanditLeaderInteruptSpellRanged.Zones = {}
CombatSequences.BanditLeaderInteruptSpellRanged.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderInteruptSpellRanged.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderInteruptSpellRanged.Zones[CombatZones.OuterRing] = true
CombatSequences.BanditLeaderInteruptSpellRanged.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "IntoAim"
	},
	{
		Type = EScriptableAction.SHOOT,
		Knockdown = false
	}
}

-- BanditLeaderInteruptSpellMelee --
CombatSequences.BanditLeaderInteruptSpellMelee = {}
CombatSequences.BanditLeaderInteruptSpellMelee.IsValid = Predicate.CreateIsTargetChargingSpellOfAtLeastLevelPredicate(3)
CombatSequences.BanditLeaderInteruptSpellMelee.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderInteruptSpellMelee.Zones = {}
CombatSequences.BanditLeaderInteruptSpellMelee.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderInteruptSpellMelee.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderInteruptSpellMelee.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- BanditLeaderShotCausedFlourish --
CombatSequences.BanditLeaderShotCausedFlourish = {}
CombatSequences.BanditLeaderShotCausedFlourish.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(6, EAttackType.ATTACK_RANGED, 5)
CombatSequences.BanditLeaderShotCausedFlourish.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderShotCausedFlourish.Zones = {}
CombatSequences.BanditLeaderShotCausedFlourish.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderShotCausedFlourish.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderShotCausedFlourish.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.1
	}
}

-- BanditLeaderHeroFlourishResponse --
CombatSequences.BanditLeaderHeroFlourishResponse = {}
CombatSequences.BanditLeaderHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.BanditLeaderHeroFlourishResponse.CounterAttack = true
CombatSequences.BanditLeaderHeroFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderHeroFlourishResponse.Zones = {}
CombatSequences.BanditLeaderHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.1
	}
}

-- BanditLeaderGettingShotResponse --
CombatSequences.BanditLeaderGettingShotResponse = {}
CombatSequences.BanditLeaderGettingShotResponse.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.BanditLeaderGettingShotResponse.CounterAttack = true
CombatSequences.BanditLeaderGettingShotResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderGettingShotResponse.Zones = {}
CombatSequences.BanditLeaderGettingShotResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderGettingShotResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderGettingShotResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	}
}

-- BanditLeaderEliteOrbSuckingResponse --
CombatSequences.BanditLeaderEliteOrbSuckingResponse = {}
CombatSequences.BanditLeaderEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BanditLeaderEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.BanditLeaderEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderEliteOrbSuckingResponse.Zones = {}
CombatSequences.BanditLeaderEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- BanditLeftAttack --
CombatSequences.BanditLeftAttack = {}
CombatSequences.BanditLeftAttack.Priority = SequencePriorities.Attack
CombatSequences.BanditLeftAttack.Zones = {}
CombatSequences.BanditLeftAttack.Zones[CombatZones.Left] = true
CombatSequences.BanditLeftAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendOutTime = 0.3
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance",
		SpeedMultiplier = 1
	}
}

-- BanditRightAttack --
CombatSequences.BanditRightAttack = {}
CombatSequences.BanditRightAttack.Priority = SequencePriorities.Attack
CombatSequences.BanditRightAttack.Zones = {}
CombatSequences.BanditRightAttack.Zones[CombatZones.Right] = true
CombatSequences.BanditRightAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendOutTime = 0.3
	}
}

-- BanditRearAttack --
CombatSequences.BanditRearAttack = {}
CombatSequences.BanditRearAttack.Priority = SequencePriorities.Attack
CombatSequences.BanditRearAttack.IsCombo = true
CombatSequences.BanditRearAttack.Zones = {}
CombatSequences.BanditRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.BanditRearAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		IsComboBreak = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- BanditLeaderEliteAssassinCharge --
CombatSequences.BanditLeaderEliteAssassinCharge = {}
CombatSequences.BanditLeaderEliteAssassinCharge.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderEliteAssassinCharge.IsCombo = true
CombatSequences.BanditLeaderEliteAssassinCharge.Zones = {}
CombatSequences.BanditLeaderEliteAssassinCharge.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderEliteAssassinCharge.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderEliteAssassinCharge.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderEliteAssassinCharge.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "OrderForwards",
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	}
}

-- CaptainDreadCloseAttackCombo --
CombatSequences.CaptainDreadCloseAttackCombo = {}
CombatSequences.CaptainDreadCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.CaptainDreadCloseAttackCombo.IsCombo = true
CombatSequences.CaptainDreadCloseAttackCombo.Zones = {}
CombatSequences.CaptainDreadCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.CaptainDreadCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5
	}
}

-- CaptainDreadAttackCombo --
CombatSequences.CaptainDreadAttackCombo = {}
CombatSequences.CaptainDreadAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.CaptainDreadAttackCombo.IsCombo = true
CombatSequences.CaptainDreadAttackCombo.Zones = {}
CombatSequences.CaptainDreadAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.CaptainDreadAttackCombo.ZonesWhilePlaying = {}
CombatSequences.CaptainDreadAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.CaptainDreadAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.CaptainDreadAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5
	}
}

-- CaptainDreadFlourishLeft --
CombatSequences.CaptainDreadFlourishLeft = {}
CombatSequences.CaptainDreadFlourishLeft.Priority = SequencePriorities.Attack
CombatSequences.CaptainDreadFlourishLeft.Zones = {}
CombatSequences.CaptainDreadFlourishLeft.Zones[CombatZones.Middle] = true
CombatSequences.CaptainDreadFlourishLeft.ZonesWhilePlaying = {}
CombatSequences.CaptainDreadFlourishLeft.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.CaptainDreadFlourishLeft.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.CaptainDreadFlourishLeft.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.CaptainDreadFlourishLeft.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 2
	}
}

-- CaptainDreadAttackOutOfBlockShort --
CombatSequences.CaptainDreadAttackOutOfBlockShort = {}
CombatSequences.CaptainDreadAttackOutOfBlockShort.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.CaptainDreadAttackOutOfBlockShort.CounterAttack = true
CombatSequences.CaptainDreadAttackOutOfBlockShort.Priority = SequencePriorities.Attack
CombatSequences.CaptainDreadAttackOutOfBlockShort.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.CaptainDreadAttackOutOfBlockShort.Zones = {}
CombatSequences.CaptainDreadAttackOutOfBlockShort.Zones[CombatZones.Near] = true
CombatSequences.CaptainDreadAttackOutOfBlockShort.Zones[CombatZones.Middle] = true
CombatSequences.CaptainDreadAttackOutOfBlockShort.ZonesWhilePlaying = {}
CombatSequences.CaptainDreadAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.CaptainDreadAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.CaptainDreadAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.CaptainDreadAttackOutOfBlockShort.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		FaceTarget = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 2
	}
}

-- CaptainDreadAttackOutOfBlock --
CombatSequences.CaptainDreadAttackOutOfBlock = {}
CombatSequences.CaptainDreadAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.CaptainDreadAttackOutOfBlock.CounterAttack = true
CombatSequences.CaptainDreadAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.CaptainDreadAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.CaptainDreadAttackOutOfBlock.Zones = {}
CombatSequences.CaptainDreadAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.CaptainDreadAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.CaptainDreadAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.CaptainDreadAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.CaptainDreadAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.CaptainDreadAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- CaptainDreadVortex --
CombatSequences.CaptainDreadVortex = {}
CombatSequences.CaptainDreadVortex.Priority = SequencePriorities.PreferredAttack
CombatSequences.CaptainDreadVortex.CounterAttack = true
CombatSequences.CaptainDreadVortex.Zones = {}
CombatSequences.CaptainDreadVortex.Zones[CombatZones.Near] = true
CombatSequences.CaptainDreadVortex.Zones[CombatZones.Middle] = true
CombatSequences.CaptainDreadVortex.Zones[CombatZones.Far] = true
CombatSequences.CaptainDreadVortex.Zones[CombatZones.OuterRing] = true
CombatSequences.CaptainDreadVortex.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "OrderForwards",
		SpeedMultiplier = 6,
		SpellType = ESpellType.SPELL_VORTEX,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- CaptainDreadGettingShotTooMuch --
CombatSequences.CaptainDreadGettingShotTooMuch = {}
CombatSequences.CaptainDreadGettingShotTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.CaptainDreadGettingShotTooMuch.Priority = SequencePriorities.PreferredAttack
CombatSequences.CaptainDreadGettingShotTooMuch.CounterAttack = true
CombatSequences.CaptainDreadGettingShotTooMuch.Zones = {}
CombatSequences.CaptainDreadGettingShotTooMuch.Zones[CombatZones.Near] = true
CombatSequences.CaptainDreadGettingShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.CaptainDreadGettingShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.CaptainDreadGettingShotTooMuch.Zones[CombatZones.OuterRing] = true
CombatSequences.CaptainDreadGettingShotTooMuch.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "OrderForwards",
		SpeedMultiplier = 3,
		SpellType = ESpellType.SPELL_VORTEX,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- CaptainDreadGettingMagicedTooMuch --
CombatSequences.CaptainDreadGettingMagicedTooMuch = {}
CombatSequences.CaptainDreadGettingMagicedTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_SPELL, 5)
CombatSequences.CaptainDreadGettingMagicedTooMuch.Priority = SequencePriorities.PreferredAttack
CombatSequences.CaptainDreadGettingMagicedTooMuch.CounterAttack = true
CombatSequences.CaptainDreadGettingMagicedTooMuch.Zones = {}
CombatSequences.CaptainDreadGettingMagicedTooMuch.Zones[CombatZones.Near] = true
CombatSequences.CaptainDreadGettingMagicedTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.CaptainDreadGettingMagicedTooMuch.Zones[CombatZones.Far] = true
CombatSequences.CaptainDreadGettingMagicedTooMuch.Zones[CombatZones.OuterRing] = true
CombatSequences.CaptainDreadGettingMagicedTooMuch.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "OrderForwards",
		SpeedMultiplier = 3,
		SpellType = ESpellType.SPELL_VORTEX,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- CaptainDreadOrbSuckingResponse --
CombatSequences.CaptainDreadOrbSuckingResponse = {}
CombatSequences.CaptainDreadOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.CaptainDreadOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.CaptainDreadOrbSuckingResponse.CounterAttack = true
CombatSequences.CaptainDreadOrbSuckingResponse.Zones = {}
CombatSequences.CaptainDreadOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.CaptainDreadOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.CaptainDreadOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.CaptainDreadOrbSuckingResponse.Zones[CombatZones.OuterRing] = true
CombatSequences.CaptainDreadOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "OrderForwards",
		SpeedMultiplier = 3,
		SpellType = ESpellType.SPELL_VORTEX,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BanditLeaderRipperCloseAttackCombo --
CombatSequences.BanditLeaderRipperCloseAttackCombo = {}
CombatSequences.BanditLeaderRipperCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderRipperCloseAttackCombo.IsCombo = true
CombatSequences.BanditLeaderRipperCloseAttackCombo.Zones = {}
CombatSequences.BanditLeaderRipperCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5
	}
}

-- BanditLeaderRipperAttackCombo --
CombatSequences.BanditLeaderRipperAttackCombo = {}
CombatSequences.BanditLeaderRipperAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderRipperAttackCombo.IsCombo = true
CombatSequences.BanditLeaderRipperAttackCombo.Zones = {}
CombatSequences.BanditLeaderRipperAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderRipperAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5
	}
}

-- BanditLeaderRipperFlourishLeft --
CombatSequences.BanditLeaderRipperFlourishLeft = {}
CombatSequences.BanditLeaderRipperFlourishLeft.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderRipperFlourishLeft.Zones = {}
CombatSequences.BanditLeaderRipperFlourishLeft.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperFlourishLeft.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperFlourishLeft.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderRipperFlourishLeft.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperFlourishLeft.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperFlourishLeft.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderRipperFlourishLeft.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5
	}
}

-- BanditLeaderRipperAttackOutOfBlockShort --
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort = {}
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.CounterAttack = true
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.Zones = {}
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlockShort.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		FaceTarget = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	}
}

-- BanditLeaderRipperAttackOutOfBlock --
CombatSequences.BanditLeaderRipperAttackOutOfBlock = {}
CombatSequences.BanditLeaderRipperAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.BanditLeaderRipperAttackOutOfBlock.CounterAttack = true
CombatSequences.BanditLeaderRipperAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderRipperAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BanditLeaderRipperAttackOutOfBlock.Zones = {}
CombatSequences.BanditLeaderRipperAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderRipperAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderRipperAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		FaceTarget = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5
	}
}

-- BanditLeaderRipperGettingShotResponse --
CombatSequences.BanditLeaderRipperGettingShotResponse = {}
CombatSequences.BanditLeaderRipperGettingShotResponse.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.BanditLeaderRipperGettingShotResponse.CounterAttack = true
CombatSequences.BanditLeaderRipperGettingShotResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderRipperGettingShotResponse.Zones = {}
CombatSequences.BanditLeaderRipperGettingShotResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperGettingShotResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperGettingShotResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5
	}
}

-- BanditLeaderRipperOrbSuckingResponse --
CombatSequences.BanditLeaderRipperOrbSuckingResponse = {}
CombatSequences.BanditLeaderRipperOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BanditLeaderRipperOrbSuckingResponse.CounterAttack = true
CombatSequences.BanditLeaderRipperOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderRipperOrbSuckingResponse.Zones = {}
CombatSequences.BanditLeaderRipperOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderRipperOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderRipperOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- RipperAssassinCharge --
CombatSequences.RipperAssassinCharge = {}
CombatSequences.RipperAssassinCharge.Priority = SequencePriorities.Attack
CombatSequences.RipperAssassinCharge.IsCombo = true
CombatSequences.RipperAssassinCharge.Zones = {}
CombatSequences.RipperAssassinCharge.Zones[CombatZones.Near] = true
CombatSequences.RipperAssassinCharge.Zones[CombatZones.Middle] = true
CombatSequences.RipperAssassinCharge.Zones[CombatZones.Far] = true
CombatSequences.RipperAssassinCharge.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "Goad",
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	}
}

-- BanditLeaderFairfaxCloseAttackCombo --
CombatSequences.BanditLeaderFairfaxCloseAttackCombo = {}
CombatSequences.BanditLeaderFairfaxCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxCloseAttackCombo.IsCombo = true
CombatSequences.BanditLeaderFairfaxCloseAttackCombo.Zones = {}
CombatSequences.BanditLeaderFairfaxCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BanditLeaderFairfaxAttackCombo --
CombatSequences.BanditLeaderFairfaxAttackCombo = {}
CombatSequences.BanditLeaderFairfaxAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxAttackCombo.IsCombo = true
CombatSequences.BanditLeaderFairfaxAttackCombo.Zones = {}
CombatSequences.BanditLeaderFairfaxAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderFairfaxAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- BanditLeaderFairfaxFlourishLeft --
CombatSequences.BanditLeaderFairfaxFlourishLeft = {}
CombatSequences.BanditLeaderFairfaxFlourishLeft.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxFlourishLeft.Zones = {}
CombatSequences.BanditLeaderFairfaxFlourishLeft.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxFlourishLeft.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderFairfaxFlourishLeft.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxFlourishLeft.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxFlourishLeft.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderFairfaxFlourishLeft.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishLeft",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	}
}

-- BanditLeaderFairfaxAttackOutOfBlockShort --
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort = {}
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.CounterAttack = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.Zones = {}
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlockShort.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishLeft",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5,
		Unblockable = true,
		IsKnockdown = true
	}
}

-- BanditLeaderFairfaxAttackOutOfBlock --
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock = {}
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.CounterAttack = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.Zones = {}
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BanditLeaderFairfaxAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishLeft",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	}
}

-- BanditLeaderFairfaxGettingShotResponse --
CombatSequences.BanditLeaderFairfaxGettingShotResponse = {}
CombatSequences.BanditLeaderFairfaxGettingShotResponse.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.BanditLeaderFairfaxGettingShotResponse.CounterAttack = true
CombatSequences.BanditLeaderFairfaxGettingShotResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxGettingShotResponse.Zones = {}
CombatSequences.BanditLeaderFairfaxGettingShotResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxGettingShotResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxGettingShotResponse.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderFairfaxGettingShotResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishLeft",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5,
		Unblockable = true,
		IsKnockdown = true
	}
}

-- BanditLeaderFairfaxOrbSuckingResponse --
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse = {}
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse.CounterAttack = true
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse.Zones = {}
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderFairfaxOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishLeft",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5,
		Unblockable = true,
		IsKnockdown = true
	}
}

-- BanditLeaderFairfaxAssassinCharge --
CombatSequences.BanditLeaderFairfaxAssassinCharge = {}
CombatSequences.BanditLeaderFairfaxAssassinCharge.CounterAttack = true
CombatSequences.BanditLeaderFairfaxAssassinCharge.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxAssassinCharge.IsCombo = true
CombatSequences.BanditLeaderFairfaxAssassinCharge.Zones = {}
CombatSequences.BanditLeaderFairfaxAssassinCharge.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxAssassinCharge.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxAssassinCharge.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderFairfaxAssassinCharge.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishLeft",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	}
}

-- BanditLeaderFairfaxAssassinChargeCounter --
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter = {}
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter.CounterAttack = true
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter.Priority = SequencePriorities.Attack
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter.IsCombo = true
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter.Zones = {}
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter.Zones[CombatZones.Near] = true
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter.Zones[CombatZones.Middle] = true
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter.Zones[CombatZones.Far] = true
CombatSequences.BanditLeaderFairfaxAssassinChargeCounter.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 8,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	}
}

-- RenegadeLeaderCloseCombo --
CombatSequences.RenegadeLeaderCloseCombo = {}
CombatSequences.RenegadeLeaderCloseCombo.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderCloseCombo.IsCombo = true
CombatSequences.RenegadeLeaderCloseCombo.Zones = {}
CombatSequences.RenegadeLeaderCloseCombo.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderCloseCombo.ZonesWhilePlaying = {}
CombatSequences.RenegadeLeaderCloseCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.RenegadeLeaderCloseCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderCloseCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1,
		FaceTarget = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "InterruptStrikeRightToStrikeLeft",
		PushBackStrike = 1.5,
		FaceTarget = true
	}
}

-- RenegadeLeaderLeftStrike --
CombatSequences.RenegadeLeaderLeftStrike = {}
CombatSequences.RenegadeLeaderLeftStrike.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderLeftStrike.Zones = {}
CombatSequences.RenegadeLeaderLeftStrike.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderLeftStrike.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeLeft"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1.5,
		FaceTarget = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance"
	}
}

-- RenegadeLeaderRightStrike --
CombatSequences.RenegadeLeaderRightStrike = {}
CombatSequences.RenegadeLeaderRightStrike.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderRightStrike.Zones = {}
CombatSequences.RenegadeLeaderRightStrike.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderRightStrike.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeRight"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5,
		FaceTarget = true
	}
}

-- RenegadeLeaderStepBackPound --
CombatSequences.RenegadeLeaderStepBackPound = {}
CombatSequences.RenegadeLeaderStepBackPound.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderStepBackPound.Zones = {}
CombatSequences.RenegadeLeaderStepBackPound.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderStepBackPound.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeBackwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "GroundPunch",
		HasPound = true,
		Unblockable = true
	}
}

-- RenegadeLeaderLeftHookUppercut --
CombatSequences.RenegadeLeaderLeftHookUppercut = {}
CombatSequences.RenegadeLeaderLeftHookUppercut.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderLeftHookUppercut.IsCombo = true
CombatSequences.RenegadeLeaderLeftHookUppercut.Zones = {}
CombatSequences.RenegadeLeaderLeftHookUppercut.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderLeftHookUppercut.ZonesWhilePlaying = {}
CombatSequences.RenegadeLeaderLeftHookUppercut.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.RenegadeLeaderLeftHookUppercut.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderLeftHookUppercut.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		PushBackStrike = 0.75
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Uppercut",
		FaceTarget = true,
		PushBackStrike = 0.75
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance"
	}
}

-- RenegadeLeaderRageAttackUppercut --
CombatSequences.RenegadeLeaderRageAttackUppercut = {}
CombatSequences.RenegadeLeaderRageAttackUppercut.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderRageAttackUppercut.IsCombo = true
CombatSequences.RenegadeLeaderRageAttackUppercut.Zones = {}
CombatSequences.RenegadeLeaderRageAttackUppercut.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderRageAttackUppercut.ZonesWhilePlaying = {}
CombatSequences.RenegadeLeaderRageAttackUppercut.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.RenegadeLeaderRageAttackUppercut.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderRageAttackUppercut.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Unblockable = true,
		PushBackStrike = 0.75,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackUppercut",
		FaceTargetAtStart = true,
		PushBackStrike = 1.5,
		FaceTarget = false
	}
}

-- RenegadeLeaderRageAttackSlap --
CombatSequences.RenegadeLeaderRageAttackSlap = {}
CombatSequences.RenegadeLeaderRageAttackSlap.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderRageAttackSlap.IsCombo = true
CombatSequences.RenegadeLeaderRageAttackSlap.Zones = {}
CombatSequences.RenegadeLeaderRageAttackSlap.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderRageAttackSlap.ZonesWhilePlaying = {}
CombatSequences.RenegadeLeaderRageAttackSlap.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.RenegadeLeaderRageAttackSlap.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderRageAttackSlap.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Unblockable = true,
		PushBackStrike = 0.8,
		HitOutsideAttackArc = true,
		IsComboBreak = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackDoubleSlap",
		FaceTargetAtStart = true,
		PushBackStrike = 1.75,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance"
	}
}

-- RenegadeLeaderRageStepBackPound --
CombatSequences.RenegadeLeaderRageStepBackPound = {}
CombatSequences.RenegadeLeaderRageStepBackPound.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderRageStepBackPound.Zones = {}
CombatSequences.RenegadeLeaderRageStepBackPound.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderRageStepBackPound.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "EnrageGroundPunch",
		HasPound = true,
		Unblockable = true
	}
}

-- RenegadeLeaderStepInHit --
CombatSequences.RenegadeLeaderStepInHit = {}
CombatSequences.RenegadeLeaderStepInHit.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderStepInHit.Zones = {}
CombatSequences.RenegadeLeaderStepInHit.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInHit.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 1.5
	}
}

-- RenegadeLeaderStepInUppercut --
CombatSequences.RenegadeLeaderStepInUppercut = {}
CombatSequences.RenegadeLeaderStepInUppercut.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderStepInUppercut.IsCombo = true
CombatSequences.RenegadeLeaderStepInUppercut.Zones = {}
CombatSequences.RenegadeLeaderStepInUppercut.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInUppercut.ZonesWhilePlaying = {}
CombatSequences.RenegadeLeaderStepInUppercut.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.RenegadeLeaderStepInUppercut.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInUppercut.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		PushBackStrike = 0.75,
		IsComboBreak = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Uppercut",
		FaceTarget = true,
		PushBackStrike = 2.25
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance"
	}
}

-- RenegadeLeaderStepInFlourish --
CombatSequences.RenegadeLeaderStepInFlourish = {}
CombatSequences.RenegadeLeaderStepInFlourish.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderStepInFlourish.IsCombo = true
CombatSequences.RenegadeLeaderStepInFlourish.Zones = {}
CombatSequences.RenegadeLeaderStepInFlourish.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInFlourish.ZonesWhilePlaying = {}
CombatSequences.RenegadeLeaderStepInFlourish.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.RenegadeLeaderStepInFlourish.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInFlourish.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		PushBackStrike = 1.25,
		IsComboBreak = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "InterruptStrikeRightToStrikeLeft",
		PushBackStrike = 1.5
	}
}

-- RenegadeLeaderPunchCombo --
CombatSequences.RenegadeLeaderPunchCombo = {}
CombatSequences.RenegadeLeaderPunchCombo.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderPunchCombo.Zones = {}
CombatSequences.RenegadeLeaderPunchCombo.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderPunchCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchCombo",
		PushBackStrike = 1.5,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance"
	}
}

-- RenegadeLeaderStepInRageAttackUppercut --
CombatSequences.RenegadeLeaderStepInRageAttackUppercut = {}
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.IsCombo = true
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.Zones = {}
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.ZonesWhilePlaying = {}
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.RenegadeLeaderStepInRageAttackUppercut.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Unblockable = true,
		PushBackStrike = 0.75,
		HitOutsideAttackArc = true,
		IsComboBreak = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackUppercut",
		FaceTargetAtStart = true,
		PushBackStrike = 1.75,
		FaceTarget = false
	}
}

-- RenegadeLeaderStepInRageAttackSlap --
CombatSequences.RenegadeLeaderStepInRageAttackSlap = {}
CombatSequences.RenegadeLeaderStepInRageAttackSlap.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderStepInRageAttackSlap.IsCombo = true
CombatSequences.RenegadeLeaderStepInRageAttackSlap.Zones = {}
CombatSequences.RenegadeLeaderStepInRageAttackSlap.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInRageAttackSlap.ZonesWhilePlaying = {}
CombatSequences.RenegadeLeaderStepInRageAttackSlap.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.RenegadeLeaderStepInRageAttackSlap.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderStepInRageAttackSlap.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.RenegadeLeaderStepInRageAttackSlap.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeForwards"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		Unblockable = true,
		PushBackStrike = 1,
		HitOutsideAttackArc = true,
		IsComboBreak = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackDoubleSlap",
		FaceTargetAtStart = true,
		PushBackStrike = 1.75,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance"
	}
}

-- RenegadeLeaderThrowGrenade --
CombatSequences.RenegadeLeaderThrowGrenade = {}
CombatSequences.RenegadeLeaderThrowGrenade.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderThrowGrenade.IsValid = Predicate.TargetIsFurtherAwayThan(4.5)
CombatSequences.RenegadeLeaderThrowGrenade.Zones = {}
CombatSequences.RenegadeLeaderThrowGrenade.Zones[CombatZones.Far] = true
CombatSequences.RenegadeLeaderThrowGrenade.Actions = {
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT_AND_THROW_IT,
		EntityName = "RenegadeLeaderExplosive",
		Anim = "ThrowExplosive",
		FaceTargetThroughout = true,
		Angle = 5,
		OverrideLooking = true,
		AimAtFeet = true,
		LookAheadInSeconds = 0.1
	}
}

-- RenegadeLeaderFireballThrow --
CombatSequences.RenegadeLeaderFireballThrow = {}
CombatSequences.RenegadeLeaderFireballThrow.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderFireballThrow.Zones = {}
CombatSequences.RenegadeLeaderFireballThrow.Zones[CombatZones.Far] = true
CombatSequences.RenegadeLeaderFireballThrow.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FireballThrow",
		SpeedMultiplier = 0.9,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Mouth"
	}
}

-- EliteRenegadeLeaderFireballThrow --
CombatSequences.EliteRenegadeLeaderFireballThrow = {}
CombatSequences.EliteRenegadeLeaderFireballThrow.Priority = SequencePriorities.Attack
CombatSequences.EliteRenegadeLeaderFireballThrow.Zones = {}
CombatSequences.EliteRenegadeLeaderFireballThrow.Zones[CombatZones.Far] = true
CombatSequences.EliteRenegadeLeaderFireballThrow.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FireballThrow",
		SpeedMultiplier = 0.9,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2,
		Dummy = "Character.Carry.Mouth"
	}
}

-- RenegadeLeaderRearAttack --
CombatSequences.RenegadeLeaderRearAttack = {}
CombatSequences.RenegadeLeaderRearAttack.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderRearAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.RenegadeLeaderRearAttack.CounterAttack = true
CombatSequences.RenegadeLeaderRearAttack.Zones = {}
CombatSequences.RenegadeLeaderRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.RenegadeLeaderRearAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "GroundPunch",
		SpeedMultiplier = 1.2,
		HasPound = true,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_MAGIC
	}
}

-- RenegadeLeaderRageRearAttack --
CombatSequences.RenegadeLeaderRageRearAttack = {}
CombatSequences.RenegadeLeaderRageRearAttack.Priority = SequencePriorities.Attack
CombatSequences.RenegadeLeaderRageRearAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.RenegadeLeaderRageRearAttack.CounterAttack = true
CombatSequences.RenegadeLeaderRageRearAttack.Zones = {}
CombatSequences.RenegadeLeaderRageRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.RenegadeLeaderRageRearAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "EnrageGroundPunch",
		SpeedMultiplier = 1.2,
		HasPound = true,
		Unblockable = true,
		Priority = EActionPriority.PRIORITY_MAGIC
	}
}

-- RenegadeLeaderSpamResponseNear --
CombatSequences.RenegadeLeaderSpamResponseNear = {}
CombatSequences.RenegadeLeaderSpamResponseNear.IsValid = Predicate.CreateHaveIBeenStruckALotPredicate(2)
CombatSequences.RenegadeLeaderSpamResponseNear.Priority = SequencePriorities.PreferredAttack
CombatSequences.RenegadeLeaderSpamResponseNear.CounterAttack = true
CombatSequences.RenegadeLeaderSpamResponseNear.Zones = {}
CombatSequences.RenegadeLeaderSpamResponseNear.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderSpamResponseNear.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderSpamResponseNear.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "GroundPunch",
		SpeedMultiplier = 1.2,
		HasPound = true,
		Unblockable = true
	}
}

-- RenegadeLeaderSpamResponse --
CombatSequences.RenegadeLeaderSpamResponse = {}
CombatSequences.RenegadeLeaderSpamResponse.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsFurtherAwayThan(4.5)
	}
)
CombatSequences.RenegadeLeaderSpamResponse.Priority = SequencePriorities.PreferredAttack
CombatSequences.RenegadeLeaderSpamResponse.CounterAttack = true
CombatSequences.RenegadeLeaderSpamResponse.Zones = {}
CombatSequences.RenegadeLeaderSpamResponse.Zones[CombatZones.Far] = true
CombatSequences.RenegadeLeaderSpamResponse.Zones[CombatZones.None] = true
CombatSequences.RenegadeLeaderSpamResponse.Actions = {
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT_AND_THROW_IT,
		EntityName = "RenegadeLeaderExplosive",
		Anim = "ThrowExplosive",
		FaceTargetThroughout = true,
		Angle = 0,
		OverrideLooking = true,
		AimAtFeet = true,
		LookAheadInSeconds = 0.1
	}
}

-- SakerSpamResponse --
CombatSequences.SakerSpamResponse = {}
CombatSequences.SakerSpamResponse.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicateOverTime(2, 3),
		Predicate.TargetIsFurtherAwayThan(4.5)
	}
)
CombatSequences.SakerSpamResponse.Priority = SequencePriorities.PreferredAttack
CombatSequences.SakerSpamResponse.CounterAttack = true
CombatSequences.SakerSpamResponse.Zones = {}
CombatSequences.SakerSpamResponse.Zones[CombatZones.Far] = true
CombatSequences.SakerSpamResponse.Zones[CombatZones.None] = true
CombatSequences.SakerSpamResponse.Actions = {
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT_AND_THROW_IT,
		EntityName = "RenegadeLeaderExplosive",
		Anim = "ThrowExplosive",
		FaceTargetThroughout = true,
		Angle = 0,
		OverrideLooking = true,
		AimAtFeet = true,
		LookAheadInSeconds = 0.1
	}
}

-- RenegadeLeaderRageSpamResponseNear --
CombatSequences.RenegadeLeaderRageSpamResponseNear = {}
CombatSequences.RenegadeLeaderRageSpamResponseNear.IsValid = Predicate.CreateHaveIBeenStruckALotPredicate(2)
CombatSequences.RenegadeLeaderRageSpamResponseNear.Priority = SequencePriorities.PreferredAttack
CombatSequences.RenegadeLeaderRageSpamResponseNear.CounterAttack = true
CombatSequences.RenegadeLeaderRageSpamResponseNear.Zones = {}
CombatSequences.RenegadeLeaderRageSpamResponseNear.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderRageSpamResponseNear.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderRageSpamResponseNear.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "EnrageGroundPunch",
		SpeedMultiplier = 1.2,
		HasPound = true,
		Unblockable = true
	}
}

-- RenegadeLeaderFireballSpamResponse --
CombatSequences.RenegadeLeaderFireballSpamResponse = {}
CombatSequences.RenegadeLeaderFireballSpamResponse.IsValid = Predicate.CreateHaveIBeenStruckALotPredicate(2)
CombatSequences.RenegadeLeaderFireballSpamResponse.Priority = SequencePriorities.PreferredAttack
CombatSequences.RenegadeLeaderFireballSpamResponse.CounterAttack = true
CombatSequences.RenegadeLeaderFireballSpamResponse.Zones = {}
CombatSequences.RenegadeLeaderFireballSpamResponse.Zones[CombatZones.Far] = true
CombatSequences.RenegadeLeaderFireballSpamResponse.Zones[CombatZones.None] = true
CombatSequences.RenegadeLeaderFireballSpamResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FireballThrow",
		SpeedMultiplier = 0.9,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Dummy = "Character.Carry.Mouth"
	}
}

-- EliteRenegadeLeaderFireballSpamResponse --
CombatSequences.EliteRenegadeLeaderFireballSpamResponse = {}
CombatSequences.EliteRenegadeLeaderFireballSpamResponse.IsValid = Predicate.CreateHaveIBeenStruckALotPredicate(2)
CombatSequences.EliteRenegadeLeaderFireballSpamResponse.Priority = SequencePriorities.PreferredAttack
CombatSequences.EliteRenegadeLeaderFireballSpamResponse.CounterAttack = true
CombatSequences.EliteRenegadeLeaderFireballSpamResponse.Zones = {}
CombatSequences.EliteRenegadeLeaderFireballSpamResponse.Zones[CombatZones.Far] = true
CombatSequences.EliteRenegadeLeaderFireballSpamResponse.Zones[CombatZones.None] = true
CombatSequences.EliteRenegadeLeaderFireballSpamResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FireballThrow",
		SpeedMultiplier = 0.9,
		FaceTargetThroughout = true,
		SpellType = ESpellType.SPELL_FIREBALL,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2,
		Dummy = "Character.Carry.Mouth"
	}
}

-- RenegadeLeaderAttackOutOfBlock --
CombatSequences.RenegadeLeaderAttackOutOfBlock = {}
CombatSequences.RenegadeLeaderAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.RenegadeLeaderAttackOutOfBlock.Priority = SequencePriorities.PreferredAttack
CombatSequences.RenegadeLeaderAttackOutOfBlock.CounterAttack = true
CombatSequences.RenegadeLeaderAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.RenegadeLeaderAttackOutOfBlock.Zones = {}
CombatSequences.RenegadeLeaderAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackOutOfBlock",
		SpeedMultiplier = 0.7,
		Knockdown = true,
		Unblockable = true,
		FaceTarget = true,
		PushBackStrike = 3
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "GroundPunch",
		SpeedMultiplier = 1.2,
		HasPound = true,
		Unblockable = true
	}
}

-- RenegadeLeaderAttackOutOfBlockCombo --
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo = {}
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo.Priority = SequencePriorities.PreferredAttack
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo.CounterAttack = true
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo.Zones = {}
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo.Zones[CombatZones.Near] = true
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderAttackOutOfBlockCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchCombo",
		PushBackStrike = 1,
		Unblockable = true,
		FaceTarget = true
	}
}

-- Pace --
CombatSequences.Pace = {}
CombatSequences.Pace.Priority = SequencePriorities.Idle
CombatSequences.Pace.Zones = {}
CombatSequences.Pace.Zones[CombatZones.Middle] = true
CombatSequences.Pace.Zones[CombatZones.Far] = true
CombatSequences.Pace.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeRight"
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeLeft"
	}
}

-- RenegadeLeaderIdle --
CombatSequences.RenegadeLeaderIdle = {}
CombatSequences.RenegadeLeaderIdle.Priority = SequencePriorities.Idle
CombatSequences.RenegadeLeaderIdle.Zones = {}
CombatSequences.RenegadeLeaderIdle.Zones[CombatZones.Middle] = true
CombatSequences.RenegadeLeaderIdle.Zones[CombatZones.Far] = true
CombatSequences.RenegadeLeaderIdle.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Taunt",
		OverrideLooking = true
	}
}

-- DLC2ThugJumpAttack --
CombatSequences.DLC2ThugJumpAttack = {}
CombatSequences.DLC2ThugJumpAttack.Priority = SequencePriorities.Attack
CombatSequences.DLC2ThugJumpAttack.Zones = {}
CombatSequences.DLC2ThugJumpAttack.Zones[CombatZones.Far] = true
CombatSequences.DLC2ThugJumpAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "JumpAttack",
		SpeedMultiplier = 1.1
	}
}

-- DLC2ThugAttackCombo --
CombatSequences.DLC2ThugAttackCombo = {}
CombatSequences.DLC2ThugAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.DLC2ThugAttackCombo.IsCombo = true
CombatSequences.DLC2ThugAttackCombo.Zones = {}
CombatSequences.DLC2ThugAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.DLC2ThugAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.DLC2ThugAttackCombo.ZonesWhilePlaying = {}
CombatSequences.DLC2ThugAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.DLC2ThugAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.DLC2ThugAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishRight",
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	}
}

-- DLC2ThugShotTooMuch --
CombatSequences.DLC2ThugShotTooMuch = {}
CombatSequences.DLC2ThugShotTooMuch.IsValid = Predicate.OR(
	{
		Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5),
		Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_SPELL, 5)
	}
)
CombatSequences.DLC2ThugShotTooMuch.Priority = SequencePriorities.Attack
CombatSequences.DLC2ThugShotTooMuch.CounterAttack = true
CombatSequences.DLC2ThugShotTooMuch.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.DLC2ThugShotTooMuch.Zones = {}
CombatSequences.DLC2ThugShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.DLC2ThugShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.DLC2ThugShotTooMuch.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "JumpCounter",
		SpeedMultiplier = 1.2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- DLC2ThugGoad --
CombatSequences.DLC2ThugGoad = {}
CombatSequences.DLC2ThugGoad.Priority = SequencePriorities.Idle
CombatSequences.DLC2ThugGoad.Zones = {}
CombatSequences.DLC2ThugGoad.Zones[CombatZones.Far] = true
CombatSequences.DLC2ThugGoad.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 1
	}
}


-- uncomment for debug
-- GUI.DisplayMessageBox("BanditSequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end