
-- Balverine --
CombatStyles.Balverine = {}
CombatStyles.Balverine.CombatGroupType = CombatGroupTypes.BalverineLike
CombatStyles.Balverine.CanStrafe = true
CombatStyles.Balverine.CanFightUnarmed = true
CombatStyles.Balverine.PreferredRange = 1.7
CombatStyles.Balverine.StrafeActionTurnPerMetre = 60
CombatStyles.Balverine.EnterStrafeDist = 5
CombatStyles.Balverine.LeaveStrafeDelta = 2
CombatStyles.Balverine.BalverineJumpDist = 1.5
CombatStyles.Balverine.BalverineBoundAttackDistance = 7
CombatStyles.Balverine.BalverinePercentChanceOfJumpingBackToBoundDistance = 10
CombatStyles.Balverine.SecondsBetweenBounds = 4
CombatStyles.Balverine.SecondsBetweenJumps = 1
CombatStyles.Balverine.ActionModifiers = {}
CombatStyles.Balverine.ActionModifiers.MinDistToTarget = 1
CombatStyles.Balverine.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.Balverine.MinSecondsBetweenMeleeAttacks = 1.5
CombatStyles.Balverine.Limits = {}
CombatStyles.Balverine.Limits[CombatZones.Near] = 1.5
CombatStyles.Balverine.Limits[CombatZones.Middle] = 2.5
CombatStyles.Balverine.Limits[CombatZones.Far] = 13
CombatStyles.Balverine.Limits[CombatZones.Left] = 2.5
CombatStyles.Balverine.Limits[CombatZones.Right] = 2.5
CombatStyles.Balverine.Limits[CombatZones.Rear] = 2.5
CombatStyles.Balverine.Sequences = {}
CombatStyles.Balverine.Sequences[CombatSituations.Melee] = {
	{"BalverineFrenzyLowHealth", 3},
	"BalverinePostJumpCombo",
    "BalverineShotCausedClaw",
    "BalverineMagicedCausedClaw",
    "BalverineCombo",
    "BalverineCloseCombo",
	{"BalverineFrenzy", 8},
	"BackOff",
	{"IdleStrafe", 3},
	{"IdleStrafeLeft", 3},
	{"IdleStrafeRight", 3},
	"BalverineLeftAttack",
	"BalverineRightAttack",
	"BalverineRearAttack"
}
CombatStyles.Balverine.Sequences[CombatSituations.Dodging] = {
	"BalverineBloodedAttackAfterDodge"
}
CombatStyles.Balverine.CanBlock = true
CombatStyles.Balverine.BlockData = {}
CombatStyles.Balverine.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.Balverine.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 2.5
CombatStyles.Balverine.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.Balverine.BlockData.MaxHitsToBlock = 3
CombatStyles.Balverine.BlockData.SecondsToBlockFor = 3
CombatStyles.Balverine.DodgeAnimations = {
	"DodgeForwardRight",
	"DodgeForwardLeft"
}
CombatStyles.Balverine.LaughAtKnockdownAnim = "Howl"
CombatStyles.Balverine.DoRunIntoStrafe = true
CombatStyles.Balverine.AntiSpamData = {}
CombatStyles.Balverine.AntiSpamData.TimeToCheckFor = 5
CombatStyles.Balverine.AntiSpamData.ShotsToTrigger = 2
CombatStyles.Balverine.AntiSpamData.SpellsToTrigger = 2
CombatStyles.Balverine.AntiSpamData.TimeToAggroFor = 15
CombatStyles.Balverine.ValidStates = {}
CombatStyles.Balverine.ValidStates[CombatSituations.Melee] = {
	"LaughAtKnockdown",
	"BalverineCircle",
	"BalverineJump",
	"BalverineChase",
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"BalverineBoundAttack",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.Balverine.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Balverine.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Balverine Blooded --
CombatStyles.BalverineBlooded = {}
CombatStyles.BalverineBlooded.CombatGroupType = CombatGroupTypes.BalverineLike
CombatStyles.BalverineBlooded.CanStrafe = true
CombatStyles.BalverineBlooded.CanFightUnarmed = true
CombatStyles.BalverineBlooded.PreferredRange = 1.7
CombatStyles.BalverineBlooded.StrafeActionTurnPerMetre = 60
CombatStyles.BalverineBlooded.EnterStrafeDist = 5
CombatStyles.BalverineBlooded.LeaveStrafeDelta = 2
CombatStyles.BalverineBlooded.BalverineJumpDist = 2
CombatStyles.BalverineBlooded.BalverineBoundAttackDistance = 7
CombatStyles.BalverineBlooded.BalverinePercentChanceOfJumpingBackToBoundDistance = 40
CombatStyles.BalverineBlooded.SecondsBetweenBounds = 4
CombatStyles.BalverineBlooded.SecondsBetweenJumps = 1
CombatStyles.BalverineBlooded.ActionModifiers = {}
CombatStyles.BalverineBlooded.ActionModifiers.MinDistToTarget = 1
CombatStyles.BalverineBlooded.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.BalverineBlooded.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.BalverineBlooded.Limits = {}
CombatStyles.BalverineBlooded.Limits[CombatZones.Near] = 1.5
CombatStyles.BalverineBlooded.Limits[CombatZones.Middle] = 2.5
CombatStyles.BalverineBlooded.Limits[CombatZones.Far] = 13
CombatStyles.BalverineBlooded.Limits[CombatZones.Left] = 2.5
CombatStyles.BalverineBlooded.Limits[CombatZones.Right] = 2.5
CombatStyles.BalverineBlooded.Limits[CombatZones.Rear] = 2.5
CombatStyles.BalverineBlooded.Sequences = {}
CombatStyles.BalverineBlooded.Sequences[CombatSituations.Melee] = {
	"BalverineBloodedHeroFlourishResponse",
    "BalverineBloodedShotCausedClaw",
    "BalverineBloodedMagicedCausedClaw",
	{"BalverineBloodedFrenzy", 4},
	{"BalverineBloodedFrenzyLowHealth", 3},
	"BalverineBloodedPostJumpCombo",
	"BalverineBloodedCloseCombo",
	"BalverineBloodedCombo",
	{"IdleStrafe", 3},
	{"IdleStrafeLeft", 3},
	{"IdleStrafeRight", 3},
	"BackOff",
	"BalverineLeftAttack",
	"BalverineRightAttack",
	"BalverineRearAttack"
}
CombatStyles.BalverineBlooded.Sequences[CombatSituations.Dodging] = {
	"BalverineBloodedAttackAfterDodge"
}
CombatStyles.BalverineBlooded.CanBlock = true
CombatStyles.BalverineBlooded.BlockData = {}
CombatStyles.BalverineBlooded.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.BalverineBlooded.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 3
CombatStyles.BalverineBlooded.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.BalverineBlooded.BlockData.MaxHitsToBlock = 4
CombatStyles.BalverineBlooded.BlockData.SecondsToBlockFor = 1
CombatStyles.BalverineBlooded.DodgeAnimations = {
	"DodgeForwardRight",
	"DodgeForwardLeft"
}
CombatStyles.BalverineBlooded.LaughAtKnockdownAnim = "Howl"
CombatStyles.BalverineBlooded.RunIntoAttack = "BoundAttack"
CombatStyles.BalverineBlooded.DoRunIntoStrafe = true
CombatStyles.BalverineBlooded.AntiSpamData = {}
CombatStyles.BalverineBlooded.AntiSpamData.TimeToCheckFor = 5
CombatStyles.BalverineBlooded.AntiSpamData.ShotsToTrigger = 3
CombatStyles.BalverineBlooded.AntiSpamData.SpellsToTrigger = 2
CombatStyles.BalverineBlooded.AntiSpamData.TimeToAggroFor = 15
CombatStyles.BalverineBlooded.ValidStates = {}
CombatStyles.BalverineBlooded.ValidStates[CombatSituations.Melee] = {
	"LaughAtKnockdown",
	"BalverineCircle",
	"BalverineJump",
	"BalverineChase",
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"BalverineBoundAttack",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BalverineBlooded.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BalverineBlooded.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Balverine Sire --
CombatStyles.BalverineSire = {}
CombatStyles.BalverineSire.CombatGroupType = CombatGroupTypes.BalverineLike
CombatStyles.BalverineSire.CanStrafe = true
CombatStyles.BalverineSire.CanFightUnarmed = true
CombatStyles.BalverineSire.PreferredRange = 1.7
CombatStyles.BalverineSire.StrafeActionTurnPerMetre = 60
CombatStyles.BalverineSire.EnterStrafeDist = 5
CombatStyles.BalverineSire.LeaveStrafeDelta = 2
CombatStyles.BalverineSire.BalverineJumpDist = 2
CombatStyles.BalverineSire.BalverineBoundAttackDistance = 7
CombatStyles.BalverineSire.BalverinePercentChanceOfJumpingBackToBoundDistance = 50
CombatStyles.BalverineSire.SecondsBetweenBounds = 4
CombatStyles.BalverineSire.SecondsBetweenJumps = 1
CombatStyles.BalverineSire.ActionModifiers = {}
CombatStyles.BalverineSire.ActionModifiers.MinDistToTarget = 1
CombatStyles.BalverineSire.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.BalverineSire.MinSecondsBetweenMeleeAttacks = 0
CombatStyles.BalverineSire.Limits = {}
CombatStyles.BalverineSire.Limits[CombatZones.Near] = 1.5
CombatStyles.BalverineSire.Limits[CombatZones.Middle] = 2.5
CombatStyles.BalverineSire.Limits[CombatZones.Far] = 13
CombatStyles.BalverineSire.Limits[CombatZones.Left] = 2.5
CombatStyles.BalverineSire.Limits[CombatZones.Right] = 2.5
CombatStyles.BalverineSire.Limits[CombatZones.Rear] = 2.5
CombatStyles.BalverineSire.Sequences = {}
CombatStyles.BalverineSire.Sequences[CombatSituations.Melee] = {
	"BalverineSireHeroFlourishResponse",
    "BalverineSireShotCausedClaw",
    "BalverineSireMagicedCausedClaw",
	{"BalverineSireFrenzyLowHealth", 3},
	"BalverineSirePostJumpCombo",
	{"BalverineSireFrenzy", 4},
	"BalverineSireCloseCombo",
	"BalverineSireCombo",
	"BalverineSireFarCombo",
	{"IdleStrafe", 3},
	{"IdleStrafeLeft", 3},
	{"IdleStrafeRight", 3},
	"BackOff",
	"BalverineLeftAttack",
	"BalverineRightAttack",
	"BalverineRearAttack"
}
CombatStyles.BalverineSire.Sequences[CombatSituations.Dodging] = {
	"BalverineBloodedAttackAfterDodge"
}
CombatStyles.BalverineSire.CanBlock = true
CombatStyles.BalverineSire.BlockData = {}
CombatStyles.BalverineSire.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.BalverineSire.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 2.5
CombatStyles.BalverineSire.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.BalverineSire.BlockData.SecondsToBlockFor = 1
CombatStyles.BalverineSire.DodgeAnimations = {
	"DodgeForwardRight",
	"DodgeForwardLeft"
}
CombatStyles.BalverineSire.LaughAtKnockdownAnim = "Howl"
CombatStyles.BalverineSire.RunIntoAttack = "BoundAttack"
CombatStyles.BalverineSire.DoRunIntoStrafe = true
CombatStyles.BalverineSire.AntiSpamData = {}
CombatStyles.BalverineSire.AntiSpamData.TimeToCheckFor = 5
CombatStyles.BalverineSire.AntiSpamData.ShotsToTrigger = 3
CombatStyles.BalverineSire.AntiSpamData.SpellsToTrigger = 2
CombatStyles.BalverineSire.AntiSpamData.TimeToAggroFor = 15
CombatStyles.BalverineSire.ValidStates = {}
CombatStyles.BalverineSire.ValidStates[CombatSituations.Melee] = {
	"LaughAtKnockdown",
	"BalverineCircle",
	"BalverineJump",
	"BalverineBoundAttack",
	"BalverineChase",
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"BalverineBoundAttack",
	"MoveToFormationPos",
    "FaceTarget"
}
CombatStyles.BalverineSire.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BalverineSire.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Renegade Melee Balverine --
CombatStyles.RenegadeMeleeBalverine = DeepCopyTable(CombatStyles.RenegadeMelee)
CombatStyles.RenegadeMeleeBalverine.TransformTarget = "CreatureBalverine"
CombatStyles.RenegadeMeleeBalverine.ValidStates = {}
CombatStyles.RenegadeMeleeBalverine.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBalverineTransformation",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}


-- Renegade Ranged Balverine --
CombatStyles.RenegadeRangedBalverine = DeepCopyTable(CombatStyles.RenegadeRanged)
CombatStyles.RenegadeRangedBalverine.TransformTarget = "CreatureBalverine"
CombatStyles.RenegadeRangedBalverine.ValidStates = {}
CombatStyles.RenegadeRangedBalverine.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBalverineTransformation",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeRangedBalverine.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
    "PlayBanterCombatComment",
    "WaitForActionToFinish",
    "CheckForBalverineTransformation",
    "UpdateWeapon",
    "CheckForBetterTarget",
    "GetTargetInSights",
    "FireRangedWeapon",
    "OuterRingKeepDistance",
    "OuterRingSpreadOut",
    "PlayCombatSequence",
    "MoveToFormationPos",
    "FaceTarget",
    "IdleWithRangedWeapon"
}
CombatStyles.RenegadeRangedBalverine.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRangedBalverine.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRangedBalverine.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeRangedBalverine.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Renegade Elite Balverine --
CombatStyles.RenegadeEliteBalverine = DeepCopyTable(CombatStyles.RenegadeElite)
CombatStyles.RenegadeEliteBalverine.TransformTarget = "CreatureBalverineBlooded"
CombatStyles.RenegadeEliteBalverine.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"CheckForBalverineTransformation",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.RenegadeEliteBalverine.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
    "PlayBanterCombatComment",
    "WaitForActionToFinish",
    "CheckForBalverineTransformation",
    "UpdateWeapon",
    "CheckForBetterTarget",
    "RetreatFromFlourish",
    "GetTargetInSights",
    "FireRangedWeapon",
    "OuterRingKeepDistance",
    "OuterRingSpreadOut",
    "PlayCombatSequence",
    "MoveToFormationPos",
    "FaceTarget",
    "IdleWithRangedWeapon"
}
CombatStyles.RenegadeEliteBalverine.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeEliteBalverine.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeEliteBalverine.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.RenegadeEliteBalverine.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Renegade Leader Balverine --
CombatStyles.RenegadeLeaderBalverine = DeepCopyTable(CombatStyles.RenegadeEliteBalverine)
CombatStyles.RenegadeLeaderBalverine.TransformTarget = "CreatureBalverineSire"


-- Balverine Poisoner --
CombatStyles.BalverinePoisoner = DeepCopyTable(CombatStyles.BalverineSire)
CombatStyles.BalverinePoisoner.PoisonData = {}
CombatStyles.BalverinePoisoner.PoisonData.BalverinePoisonPoints = 10


-- Balverine Poisoner Easy --
CombatStyles.BalverinePoisonerEasy = DeepCopyTable(CombatStyles.BalverineSire)
CombatStyles.BalverinePoisonerEasy.PoisonData = {}
CombatStyles.BalverinePoisonerEasy.PoisonData.BalverinePoisonPoints = 10


-- Balverine Poisoner Medium --
CombatStyles.BalverinePoisonerMedium = DeepCopyTable(CombatStyles.BalverineSire)
CombatStyles.BalverinePoisonerMedium.PoisonData = {}
CombatStyles.BalverinePoisonerMedium.PoisonData.BalverinePoisonPoints = 10



-- uncomment for debug
-- GUI.DisplayMessageBox("balverinecombatstyles.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end