
-- DogHighAttack --
CombatSequences.DogHighAttack = {}
CombatSequences.DogHighAttack.Priority = SequencePriorities.Attack
CombatSequences.DogHighAttack.IsValid = Predicate.CreateTargetIsOfCreatureTypePredicate(ECreatureType.CREATURE_HOLLOWMAN)
CombatSequences.DogHighAttack.Zones = {}
CombatSequences.DogHighAttack.Zones[CombatZones.Near] = true
CombatSequences.DogHighAttack.Zones[CombatZones.Middle] = false
CombatSequences.DogHighAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DogAttackHigh",
		IsKnockdown = false,
		FaceTarget = true
	}
}

-- DogLowAttack --
CombatSequences.DogLowAttack = {}
CombatSequences.DogLowAttack.Priority = SequencePriorities.Attack
CombatSequences.DogLowAttack.IsValid = Predicate.CreateTargetIsOfCreatureTypePredicate(ECreatureType.CREATURE_HOLLOWMAN)
CombatSequences.DogLowAttack.Zones = {}
CombatSequences.DogLowAttack.Zones[CombatZones.Near] = true
CombatSequences.DogLowAttack.Zones[CombatZones.Middle] = false
CombatSequences.DogLowAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DogAttackLow",
		IsKnockdown = false,
		FaceTarget = true
	}
}

-- DogBasicAttack --
CombatSequences.DogBasicAttack = {}
CombatSequences.DogBasicAttack.Priority = SequencePriorities.Attack
CombatSequences.DogBasicAttack.Zones = {}
CombatSequences.DogBasicAttack.Zones[CombatZones.Near] = true
CombatSequences.DogBasicAttack.Zones[CombatZones.Middle] = true
CombatSequences.DogBasicAttack.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "DogAttackLeapInto"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DogAttackLeap",
		IsKnockdown = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "DogAttackLeapOutof"
	}
}

-- DogSnapAttack --
CombatSequences.DogSnapAttack = {}
CombatSequences.DogSnapAttack.Priority = SequencePriorities.Attack
CombatSequences.DogSnapAttack.IsValid = Predicate.DogIsInConfinedSpace
CombatSequences.DogSnapAttack.Zones = {}
CombatSequences.DogSnapAttack.Zones[CombatZones.Near] = true
CombatSequences.DogSnapAttack.Zones[CombatZones.Middle] = true
CombatSequences.DogSnapAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AttackSnap"
	}
}

-- DogIdle --
CombatSequences.DogIdle = {}
CombatSequences.DogIdle.Priority = SequencePriorities.Idle
CombatSequences.DogIdle.Zones = {}
CombatSequences.DogIdle.Zones[CombatZones.Middle] = true
CombatSequences.DogIdle.Zones[CombatZones.OuterRing] = true
CombatSequences.DogIdle.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "AttackSnarlLoop"
	}

}


-- uncomment for debug
-- GUI.DisplayMessageBox("dogsequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end
