
-- LuciensSoldierCloseAttack --
CombatSequences.LuciensSoldierCloseAttack = {}
CombatSequences.LuciensSoldierCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierCloseAttack.IsCombo = true
CombatSequences.LuciensSoldierCloseAttack.Zones = {}
CombatSequences.LuciensSoldierCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true,
		FaceTarget = false
	}
}

-- LuciensSoldierAttack --
CombatSequences.LuciensSoldierAttack = {}
CombatSequences.LuciensSoldierAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierAttack.IsCombo = true
CombatSequences.LuciensSoldierAttack.Zones = {}
CombatSequences.LuciensSoldierAttack.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierAttack.ZonesWhilePlaying = {}
CombatSequences.LuciensSoldierAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensSoldierAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensSoldierAttack.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "Walk"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true,
		FaceTarget = false
	}
}

-- LuciensSoldierFarAttackCombo --
CombatSequences.LuciensSoldierFarAttackCombo = {}
CombatSequences.LuciensSoldierFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierFarAttackCombo.IsCombo = true
CombatSequences.LuciensSoldierFarAttackCombo.Zones = {}
CombatSequences.LuciensSoldierFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.LuciensSoldierFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.LuciensSoldierFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensSoldierFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensSoldierFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensSoldierFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "Walk",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		IsComboBreak = true,
		HitOutsideAttackArc = true,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		IsComboBreak = true,
		HitOutsideAttackArc = true,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true,
		FaceTarget = false
	}
}

-- LuciensHeroFlourishResponse --
CombatSequences.LuciensHeroFlourishResponse = {}
CombatSequences.LuciensHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.LuciensHeroFlourishResponse.Priority = SequencePriorities.PreferredAttack
CombatSequences.LuciensHeroFlourishResponse.CounterAttack = true
CombatSequences.LuciensHeroFlourishResponse.Zones = {}
CombatSequences.LuciensHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.LuciensHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.LuciensHeroFlourishResponse.Zones[CombatZones.Far] = true
CombatSequences.LuciensHeroFlourishResponse.ZonesWhilePlaying = {}
CombatSequences.LuciensHeroFlourishResponse.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensHeroFlourishResponse.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensHeroFlourishResponse.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "BlockForcePush",
		SpeedMultiplier = 2.5,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_RESPONSE,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- LuciensSoldierAttackOutOfBlock --
CombatSequences.LuciensSoldierAttackOutOfBlock = {}
CombatSequences.LuciensSoldierAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.LuciensSoldierAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierAttackOutOfBlock.CounterAttack = true
CombatSequences.LuciensSoldierAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LuciensSoldierAttackOutOfBlock.Zones = {}
CombatSequences.LuciensSoldierAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.LuciensSoldierAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.LuciensSoldierAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensSoldierAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensSoldierAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensSoldierAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "BlockForcePush",
		SpeedMultiplier = 1.8,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 3
	},
	{
		Type = EScriptableAction.LUCIENS_SOLDIER_SPELL,
		Anim = "RangedAttack",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Spell = "LuciensSoldierSpellSmall"
	}
}

-- LuciensSoldierGroupAttack --
CombatSequences.LuciensSoldierGroupAttack = {}
CombatSequences.LuciensSoldierGroupAttack.IsValid = Predicate.GroupOrderIsStrike
CombatSequences.LuciensSoldierGroupAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierGroupAttack.CounterAttack = true
CombatSequences.LuciensSoldierGroupAttack.IsCombo = true
CombatSequences.LuciensSoldierGroupAttack.Zones = {}
CombatSequences.LuciensSoldierGroupAttack.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierGroupAttack.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierGroupAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true
	}
}

-- LuciensSoldierGroupSpellAttack --
CombatSequences.LuciensSoldierGroupSpellAttack = {}
CombatSequences.LuciensSoldierGroupSpellAttack.IsValid = Predicate.GroupOrderIsShoot
CombatSequences.LuciensSoldierGroupSpellAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierGroupSpellAttack.CounterAttack = true
CombatSequences.LuciensSoldierGroupSpellAttack.IsCombo = true
CombatSequences.LuciensSoldierGroupSpellAttack.Zones = {}
CombatSequences.LuciensSoldierGroupSpellAttack.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierGroupSpellAttack.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierGroupSpellAttack.Actions = {
	{
		Type = EScriptableAction.LUCIENS_SOLDIER_SPELL,
		Anim = "RangedAttack",
		Spell = "LuciensSoldierSpellSmall"
	}
}

-- LuciensSoldierShotTooMuch --
CombatSequences.LuciensSoldierShotTooMuch = {}
CombatSequences.LuciensSoldierShotTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(20, EAttackType.ATTACK_RANGED, 5)
CombatSequences.LuciensSoldierShotTooMuch.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierShotTooMuch.CounterAttack = true
CombatSequences.LuciensSoldierShotTooMuch.Zones = {}
CombatSequences.LuciensSoldierShotTooMuch.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.LuciensSoldierShotTooMuch.Actions = {
	{
		Type = EScriptableAction.LUCIENS_SOLDIER_SPELL,
		Anim = "RangedAttack",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Spell = "LuciensSoldierSpellSmall"
	}
}

-- LuciensSoldierMagicedTooMuch --
CombatSequences.LuciensSoldierMagicedTooMuch = {}
CombatSequences.LuciensSoldierMagicedTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(5, EAttackType.ATTACK_SPELL, 5)
CombatSequences.LuciensSoldierMagicedTooMuch.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierMagicedTooMuch.CounterAttack = true
CombatSequences.LuciensSoldierMagicedTooMuch.Zones = {}
CombatSequences.LuciensSoldierMagicedTooMuch.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierMagicedTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierMagicedTooMuch.Zones[CombatZones.Far] = true
CombatSequences.LuciensSoldierMagicedTooMuch.Actions = {
	{
		Type = EScriptableAction.LUCIENS_SOLDIER_SPELL,
		Anim = "RangedAttack",
		SpeedMultiplier = 1.8,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Spell = "LuciensSoldierSpellSmall"
	}
}

-- LuciensSoldierOrbSuckingResponse --
CombatSequences.LuciensSoldierOrbSuckingResponse = {}
CombatSequences.LuciensSoldierOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.LuciensSoldierOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierOrbSuckingResponse.CounterAttack = true
CombatSequences.LuciensSoldierOrbSuckingResponse.Zones = {}
CombatSequences.LuciensSoldierOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.LuciensSoldierOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Anim = "BlockForcePush",
		SpeedMultiplier = 1.8,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 3
	}
}

-- LuciensSoldierLieutenantCloseAttack --
CombatSequences.LuciensSoldierLieutenantCloseAttack = {}
CombatSequences.LuciensSoldierLieutenantCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierLieutenantCloseAttack.IsCombo = true
CombatSequences.LuciensSoldierLieutenantCloseAttack.Zones = {}
CombatSequences.LuciensSoldierLieutenantCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierLieutenantCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true,
		FaceTarget = false
	}
}

-- LuciensSoldierLieutenantAttack --
CombatSequences.LuciensSoldierLieutenantAttack = {}
CombatSequences.LuciensSoldierLieutenantAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierLieutenantAttack.IsCombo = true
CombatSequences.LuciensSoldierLieutenantAttack.Zones = {}
CombatSequences.LuciensSoldierLieutenantAttack.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierLieutenantAttack.ZonesWhilePlaying = {}
CombatSequences.LuciensSoldierLieutenantAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensSoldierLieutenantAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensSoldierLieutenantAttack.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "Walk",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		IsComboBreak = true,
		HitOutsideAttackArc = true,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	}
}

-- LuciensSoldierLieutenantFarAttackCombo --
CombatSequences.LuciensSoldierLieutenantFarAttackCombo = {}
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.IsCombo = true
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.Zones = {}
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensSoldierLieutenantFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "Walk",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		IsComboBreak = true,
		HitOutsideAttackArc = true,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		IsComboBreak = true,
		HitOutsideAttackArc = true,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrike",
		SpeedMultiplier = 1.2
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrongStrikeB",
		SpeedMultiplier = 1.2,
		HitOutsideAttackArc = true,
		FaceTarget = false
	}
}

-- LuciensSoldierLieutenantAttackOutOfBlock --
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock = {}
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.CounterAttack = true
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.Zones = {}
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensSoldierLieutenantAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Anim = "BlockForcePush",
		SpeedMultiplier = 1.8,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	},
	{
		Type = EScriptableAction.LUCIENS_SOLDIER_SPELL,
		Anim = "RangedAttack",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Spell = "LuciensSoldierSpellSmall"
	}
}

-- LuciensSoldierLieutenantOrbSuckingResponse --
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse = {}
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse.CounterAttack = true
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse.Zones = {}
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.LuciensSoldierLieutenantOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Anim = "BlockForcePush",
		SpeedMultiplier = 1.8,
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 4
	}
}

-- LuciensGuardCloseAttack --
CombatSequences.LuciensGuardCloseAttack = {}
CombatSequences.LuciensGuardCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardCloseAttack.IsCombo = true
CombatSequences.LuciensGuardCloseAttack.Zones = {}
CombatSequences.LuciensGuardCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.LuciensGuardCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- LuciensGuardAttack --
CombatSequences.LuciensGuardAttack = {}
CombatSequences.LuciensGuardAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardAttack.IsCombo = true
CombatSequences.LuciensGuardAttack.Zones = {}
CombatSequences.LuciensGuardAttack.Zones[CombatZones.Middle] = true
CombatSequences.LuciensGuardAttack.ZonesWhilePlaying = {}
CombatSequences.LuciensGuardAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensGuardAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensGuardAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- LuciensGuardFarAttack --
CombatSequences.LuciensGuardFarAttack = {}
CombatSequences.LuciensGuardFarAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardFarAttack.IsCombo = true
CombatSequences.LuciensGuardFarAttack.Zones = {}
CombatSequences.LuciensGuardFarAttack.Zones[CombatZones.Far] = true
CombatSequences.LuciensGuardFarAttack.ZonesWhilePlaying = {}
CombatSequences.LuciensGuardFarAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensGuardFarAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensGuardFarAttack.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensGuardFarAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- LuciensGuardHeroFlourishResponse --
CombatSequences.LuciensGuardHeroFlourishResponse = {}
CombatSequences.LuciensGuardHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.LuciensGuardHeroFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardHeroFlourishResponse.CounterAttack = true
CombatSequences.LuciensGuardHeroFlourishResponse.Zones = {}
CombatSequences.LuciensGuardHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.LuciensGuardHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.LuciensGuardHeroFlourishResponse.Zones[CombatZones.Far] = true
CombatSequences.LuciensGuardHeroFlourishResponse.ZonesWhilePlaying = {}
CombatSequences.LuciensGuardHeroFlourishResponse.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensGuardHeroFlourishResponse.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensGuardHeroFlourishResponse.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensGuardHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1,
		IsComboBreak = true
	}
}

-- LuciensGuardOrbSuckingResponse --
CombatSequences.LuciensGuardOrbSuckingResponse = {}
CombatSequences.LuciensGuardOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.LuciensGuardOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardOrbSuckingResponse.CounterAttack = true
CombatSequences.LuciensGuardOrbSuckingResponse.Zones = {}
CombatSequences.LuciensGuardOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.LuciensGuardOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.LuciensGuardOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.LuciensGuardOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5
	}
}

-- LuciensGuardLieutenantCloseAttack --
CombatSequences.LuciensGuardLieutenantCloseAttack = {}
CombatSequences.LuciensGuardLieutenantCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardLieutenantCloseAttack.IsCombo = true
CombatSequences.LuciensGuardLieutenantCloseAttack.Zones = {}
CombatSequences.LuciensGuardLieutenantCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.LuciensGuardLieutenantCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	}
}

-- LuciensGuardLieutenantAttack --
CombatSequences.LuciensGuardLieutenantAttack = {}
CombatSequences.LuciensGuardLieutenantAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardLieutenantAttack.IsCombo = true
CombatSequences.LuciensGuardLieutenantAttack.Zones = {}
CombatSequences.LuciensGuardLieutenantAttack.Zones[CombatZones.Middle] = true
CombatSequences.LuciensGuardLieutenantAttack.ZonesWhilePlaying = {}
CombatSequences.LuciensGuardLieutenantAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensGuardLieutenantAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensGuardLieutenantAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	}
}

-- LuciensGuardLieutenantFarAttack --
CombatSequences.LuciensGuardLieutenantFarAttack = {}
CombatSequences.LuciensGuardLieutenantFarAttack.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardLieutenantFarAttack.IsCombo = true
CombatSequences.LuciensGuardLieutenantFarAttack.Zones = {}
CombatSequences.LuciensGuardLieutenantFarAttack.Zones[CombatZones.Far] = true
CombatSequences.LuciensGuardLieutenantFarAttack.ZonesWhilePlaying = {}
CombatSequences.LuciensGuardLieutenantFarAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensGuardLieutenantFarAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensGuardLieutenantFarAttack.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensGuardLieutenantFarAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	}
}

-- LuciensGuardLieutenantAttackOutOfBlockShort --
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort = {}
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(4)
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.CounterAttack = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.Zones = {}
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.Zones[CombatZones.Near] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.Zones[CombatZones.Middle] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.ZonesWhilePlaying = {}
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlockShort.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3
	}
}

-- LuciensGuardLieutenantAttackOutOfBlock --
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock = {}
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(4)
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.CounterAttack = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.Zones = {}
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LuciensGuardLieutenantAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PunchAttack",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	}
}

-- LuciensGuardLieutenantOrbSuckingResponse --
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse = {}
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse.CounterAttack = true
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse.Zones = {}
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.LuciensGuardLieutenantOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.5
	}
}

-- BeetleTakeOffOnlyWhenClose --
CombatSequences.BeetleTakeOffOnlyWhenClose = {}
CombatSequences.BeetleTakeOffOnlyWhenClose.IsValid = Predicate.NOT(Predicate.HasEntityModeFlying)
CombatSequences.BeetleTakeOffOnlyWhenClose.Priority = SequencePriorities.Movement
CombatSequences.BeetleTakeOffOnlyWhenClose.Uninterruptable = true
CombatSequences.BeetleTakeOffOnlyWhenClose.Zones = {}
CombatSequences.BeetleTakeOffOnlyWhenClose.Zones[CombatZones.Near] = true
CombatSequences.BeetleTakeOffOnlyWhenClose.Zones[CombatZones.Middle] = true
CombatSequences.BeetleTakeOffOnlyWhenClose.Zones[CombatZones.Left] = true
CombatSequences.BeetleTakeOffOnlyWhenClose.Zones[CombatZones.Right] = true
CombatSequences.BeetleTakeOffOnlyWhenClose.Zones[CombatZones.Rear] = true
CombatSequences.BeetleTakeOffOnlyWhenClose.Actions = {
	{
		Type = EScriptableAction.TAKE_OFF_FROM_GROUND,
		Anim = "TakeOff"
	}
}

-- BeetleTakeOffAtFar --
CombatSequences.BeetleTakeOffAtFar = {}
CombatSequences.BeetleTakeOffAtFar.IsValid = Predicate.NOT(Predicate.HasEntityModeFlying)
CombatSequences.BeetleTakeOffAtFar.Priority = SequencePriorities.Attack
CombatSequences.BeetleTakeOffAtFar.Uninterruptable = true
CombatSequences.BeetleTakeOffAtFar.Zones = {}
CombatSequences.BeetleTakeOffAtFar.Zones[CombatZones.Far] = true
CombatSequences.BeetleTakeOffAtFar.Zones[CombatZones.Near] = true
CombatSequences.BeetleTakeOffAtFar.Zones[CombatZones.Middle] = true
CombatSequences.BeetleTakeOffAtFar.Zones[CombatZones.Left] = true
CombatSequences.BeetleTakeOffAtFar.Zones[CombatZones.Right] = true
CombatSequences.BeetleTakeOffAtFar.Zones[CombatZones.Rear] = true
CombatSequences.BeetleTakeOffAtFar.Actions = {
	{
		Type = EScriptableAction.TAKE_OFF_FROM_GROUND,
		Anim = "TakeOff"
	}
}

-- BeetleLandWhenOutOfRange --
CombatSequences.BeetleLandWhenOutOfRange = {}
CombatSequences.BeetleLandWhenOutOfRange.Priority = SequencePriorities.Movement
CombatSequences.BeetleLandWhenOutOfRange.IsValid = Predicate.HasEntityModeFlying
CombatSequences.BeetleLandWhenOutOfRange.Uninterruptable = true
CombatSequences.BeetleLandWhenOutOfRange.Zones = {}
CombatSequences.BeetleLandWhenOutOfRange.Zones[CombatZones.None] = true
CombatSequences.BeetleLandWhenOutOfRange.Zones[CombatZones.OuterRing] = true
CombatSequences.BeetleLandWhenOutOfRange.Actions = {
	{
		Type = EScriptableAction.LAND_FROM_FLIGHT,
		Anim = "Land"
	}
}

-- BeetleLandAtFar --
CombatSequences.BeetleLandAtFar = {}
CombatSequences.BeetleLandAtFar.Priority = SequencePriorities.Movement
CombatSequences.BeetleLandAtFar.IsValid = Predicate.HasEntityModeFlying
CombatSequences.BeetleLandAtFar.Uninterruptable = true
CombatSequences.BeetleLandAtFar.Zones = {}
CombatSequences.BeetleLandAtFar.Zones[CombatZones.Far] = true
CombatSequences.BeetleLandAtFar.Actions = {
	{
		Type = EScriptableAction.LAND_FROM_FLIGHT,
		Anim = "Land"
	}
}

-- BeetleCloseAttack --
CombatSequences.BeetleCloseAttack = {}
CombatSequences.BeetleCloseAttack.IsValid = Predicate.AND(
	{
		Predicate.HasEntityModeFlying,
		Predicate.NOT(Predicate.TargetHasPlayerModeInteraction)
	}
)
CombatSequences.BeetleCloseAttack.Priority = SequencePriorities.Attack
CombatSequences.BeetleCloseAttack.Zones = {}
CombatSequences.BeetleCloseAttack.Zones[CombatZones.Near] = true
CombatSequences.BeetleCloseAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlyingAttackA",
		FaceTargetThroughout = true
	}
}

-- BeetleAttack --
CombatSequences.BeetleAttack = {}
CombatSequences.BeetleAttack.IsValid = Predicate.AND(
	{
		Predicate.HasEntityModeFlying,
		Predicate.NOT(Predicate.TargetHasPlayerModeInteraction)
	}
)
CombatSequences.BeetleAttack.Priority = SequencePriorities.Attack
CombatSequences.BeetleAttack.Zones = {}
CombatSequences.BeetleAttack.Zones[CombatZones.Middle] = true
CombatSequences.BeetleAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlyingAttackA",
		FaceTargetThroughout = true
	}
}

-- SuperBeetleAssassinCharge --
CombatSequences.SuperBeetleAssassinCharge = {}
CombatSequences.SuperBeetleAssassinCharge.IsValid = Predicate.AND(
	{
		Predicate.HasEntityModeFlying
	}
)
CombatSequences.SuperBeetleAssassinCharge.Priority = SequencePriorities.Attack
CombatSequences.SuperBeetleAssassinCharge.Zones = {}
CombatSequences.SuperBeetleAssassinCharge.Zones[CombatZones.Near] = true
CombatSequences.SuperBeetleAssassinCharge.Zones[CombatZones.Middle] = true
CombatSequences.SuperBeetleAssassinCharge.Zones[CombatZones.Far] = true
CombatSequences.SuperBeetleAssassinCharge.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlyingAttackB",
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		IsKnockdown = false
	}
}

-- ClockworkBeetleAssassinCharge --
CombatSequences.ClockworkBeetleAssassinCharge = {}
CombatSequences.SuperBeetleAssassinCharge.IsValid = Predicate.AND(
	{
		Predicate.HasEntityModeFlying
	}
)
CombatSequences.ClockworkBeetleAssassinCharge.Priority = SequencePriorities.Attack
CombatSequences.ClockworkBeetleAssassinCharge.Zones = {}
CombatSequences.ClockworkBeetleAssassinCharge.Zones[CombatZones.Far] = true
CombatSequences.ClockworkBeetleAssassinCharge.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "FlyingAttackB",
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		Dummy = "Character.Focal.Chest",
		PowerLevel = 1,
		IsKnockdown = false
	}
}

-- BansheeChildCloseAttackCombo --
CombatSequences.BansheeChildCloseAttackCombo = {}
CombatSequences.BansheeChildCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BansheeChildCloseAttackCombo.IsCombo = true
CombatSequences.BansheeChildCloseAttackCombo.Zones = {}
CombatSequences.BansheeChildCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.BansheeChildCloseAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BansheeChildCloseAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BansheeChildCloseAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BansheeChildCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AltStrike",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AltStrikeFollowUp",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "RunAttack",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	}
}

-- BansheeChildAttackCombo --
CombatSequences.BansheeChildAttackCombo = {}
CombatSequences.BansheeChildAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.BansheeChildAttackCombo.IsCombo = true
CombatSequences.BansheeChildAttackCombo.Zones = {}
CombatSequences.BansheeChildAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.BansheeChildAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.BansheeChildAttackCombo.ZonesWhilePlaying = {}
CombatSequences.BansheeChildAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.BansheeChildAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.BansheeChildAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.BansheeChildAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AltStrike",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AltStrikeFollowUp",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "RunAttack",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	}
}

-- BansheeChildOrbSuckingResponse --
CombatSequences.BansheeChildOrbSuckingResponse = {}
CombatSequences.BansheeChildOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.BansheeChildOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.BansheeChildOrbSuckingResponse.CounterAttack = true
CombatSequences.BansheeChildOrbSuckingResponse.Zones = {}
CombatSequences.BansheeChildOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.BansheeChildOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.BansheeChildOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.BansheeChildOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "AltStrike",
		SpeedMultiplier = 1.7,
		IsComboBreak = true
	}
}

-- AttackLeftMid --
CombatSequences.AttackLeftMid = {}
CombatSequences.AttackLeftMid.Priority = SequencePriorities.Attack
CombatSequences.AttackLeftMid.IsCombo = true
CombatSequences.AttackLeftMid.Zones = {}
CombatSequences.AttackLeftMid.Zones[CombatZones.Middle] = true
CombatSequences.AttackLeftMid.ZonesWhilePlaying = {}
CombatSequences.AttackLeftMid.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AttackLeftMid.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AttackLeftMid.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeUppercut",
		IsKnockdown = true,
		Unblockable = true
	}
}

-- AttackRightMid --
CombatSequences.AttackRightMid = {}
CombatSequences.AttackRightMid.Priority = SequencePriorities.Attack
CombatSequences.AttackRightMid.IsCombo = true
CombatSequences.AttackRightMid.Zones = {}
CombatSequences.AttackRightMid.Zones[CombatZones.Middle] = true
CombatSequences.AttackRightMid.ZonesWhilePlaying = {}
CombatSequences.AttackRightMid.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AttackRightMid.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AttackRightMid.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight3",
		IsKnockdown = true,
		Unblockable = true
	}
}

-- AttackLeftMidBanditsOnly --
CombatSequences.AttackLeftMidBanditsOnly = {}
CombatSequences.AttackLeftMidBanditsOnly.IsValid = Predicate.CreateTargetIsOfCreatureTypePredicate(ECreatureType.CREATURE_BANDIT)
CombatSequences.AttackLeftMidBanditsOnly.Priority = SequencePriorities.PreferredAttack
CombatSequences.AttackLeftMidBanditsOnly.IsCombo = true
CombatSequences.AttackLeftMidBanditsOnly.Zones = {}
CombatSequences.AttackLeftMidBanditsOnly.Zones[CombatZones.Middle] = true
CombatSequences.AttackLeftMidBanditsOnly.ZonesWhilePlaying = {}
CombatSequences.AttackLeftMidBanditsOnly.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AttackLeftMidBanditsOnly.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AttackLeftMidBanditsOnly.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeUppercut",
		IsKnockdown = true,
		Unblockable = true
	}
}

-- AttackRightMidBanditsOnly --
CombatSequences.AttackRightMidBanditsOnly = {}
CombatSequences.AttackRightMidBanditsOnly.IsValid = Predicate.CreateTargetIsOfCreatureTypePredicate(ECreatureType.CREATURE_BANDIT)
CombatSequences.AttackRightMidBanditsOnly.Priority = SequencePriorities.Attack
CombatSequences.AttackRightMidBanditsOnly.Zones = {}
CombatSequences.AttackRightMidBanditsOnly.Zones[CombatZones.Middle] = true
CombatSequences.AttackRightMidBanditsOnly.ZonesWhilePlaying = {}
CombatSequences.AttackRightMidBanditsOnly.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AttackRightMidBanditsOnly.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AttackRightMidBanditsOnly.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight3",
		IsKnockdown = true,
		Unblockable = true
	}
}

-- CloseAttackWithOffHand --
CombatSequences.CloseAttackWithOffHand = {}
CombatSequences.CloseAttackWithOffHand.Priority = SequencePriorities.Attack
CombatSequences.CloseAttackWithOffHand.IsCombo = true
CombatSequences.CloseAttackWithOffHand.Zones = {}
CombatSequences.CloseAttackWithOffHand.Zones[CombatZones.Near] = true
CombatSequences.CloseAttackWithOffHand.ZonesWhilePlaying = {}
CombatSequences.CloseAttackWithOffHand.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.CloseAttackWithOffHand.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeOffHand",
		Unblockable = true,
		SpeedMultiplier = 1.2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeUppercut",
		IsKnockdown = true,
		Unblockable = true
	}
}

-- SpecialAttackOverhead --
CombatSequences.SpecialAttackOverhead = {}
CombatSequences.SpecialAttackOverhead.Priority = SequencePriorities.Attack
CombatSequences.SpecialAttackOverhead.Zones = {}
CombatSequences.SpecialAttackOverhead.Zones[CombatZones.Middle] = true
CombatSequences.SpecialAttackOverhead.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeOverhead",
		HasPound = true,
		IsKnockdown = true,
		Unblockable = true
	}
}

-- SpecialAttackShoulderCharge --
CombatSequences.SpecialAttackShoulderCharge = {}
CombatSequences.SpecialAttackShoulderCharge.Priority = SequencePriorities.Attack
CombatSequences.SpecialAttackShoulderCharge.IsCombo = true
CombatSequences.SpecialAttackShoulderCharge.Zones = {}
CombatSequences.SpecialAttackShoulderCharge.Zones[CombatZones.Far] = true
CombatSequences.SpecialAttackShoulderCharge.ZonesWhilePlaying = {}
CombatSequences.SpecialAttackShoulderCharge.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.SpecialAttackShoulderCharge.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.SpecialAttackShoulderCharge.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.SpecialAttackShoulderCharge.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackInto",
		Unblockable = true,
		SpeedMultiplier = 1.2,
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackLoop",
		Unblockable = true,
		SpeedMultiplier = 1.2,
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "ChargeAttackOutOfNormal",
		Unblockable = true,
		SpeedMultiplier = 1.2,
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeOverhead",
		HasPound = true,
		IsKnockdown = true,
		Unblockable = true
	}
}

-- SpecialAttackSpinAround --
CombatSequences.SpecialAttackSpinAround = {}
CombatSequences.SpecialAttackSpinAround.IsValid = Predicate.IsSurrounded
CombatSequences.SpecialAttackSpinAround.Priority = SequencePriorities.PreferredAttack
CombatSequences.SpecialAttackSpinAround.Zones = {}
CombatSequences.SpecialAttackSpinAround.Zones[CombatZones.Near] = true
CombatSequences.SpecialAttackSpinAround.Zones[CombatZones.Middle] = true
CombatSequences.SpecialAttackSpinAround.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "SpinAttack",
		IsKnockdown = true,
		Unblockable = true,
		HitOutsideAttackArc = true
	}
}

-- SpecialAttackStrikeBehind --
CombatSequences.SpecialAttackStrikeBehind = {}
CombatSequences.SpecialAttackStrikeBehind.Priority = SequencePriorities.PreferredAttack
CombatSequences.SpecialAttackStrikeBehind.Zones = {}
CombatSequences.SpecialAttackStrikeBehind.Zones[CombatZones.Rear] = true
CombatSequences.SpecialAttackStrikeBehind.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Turn180AndStrike",
		FaceTarget = false,
		AdditionalTurning = false,
		HitOutsideAttackArc = true
	}
}

-- HammerStrikeToTheLeft --
CombatSequences.HammerStrikeToTheLeft = {}
CombatSequences.HammerStrikeToTheLeft.Priority = SequencePriorities.Attack
CombatSequences.HammerStrikeToTheLeft.Zones = {}
CombatSequences.HammerStrikeToTheLeft.Zones[CombatZones.Left] = true
CombatSequences.HammerStrikeToTheLeft.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight2",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendOutTime = 0.3
	}
}

-- HammerStrikeToTheRight --
CombatSequences.HammerStrikeToTheRight = {}
CombatSequences.HammerStrikeToTheRight.Priority = SequencePriorities.Attack
CombatSequences.HammerStrikeToTheRight.Zones = {}
CombatSequences.HammerStrikeToTheRight.Zones[CombatZones.Right] = true
CombatSequences.HammerStrikeToTheRight.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft2",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendOutTime = 0.3
	}
}

-- HammerAttackOutOfBlock --
CombatSequences.HammerAttackOutOfBlock = {}
CombatSequences.HammerAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.HammerAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.HammerAttackOutOfBlock.CounterAttack = true
CombatSequences.HammerAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.HammerAttackOutOfBlock.Zones = {}
CombatSequences.HammerAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.HammerAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.HammerAttackOutOfBlock.Zones[CombatZones.Far] = true
CombatSequences.HammerAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.HammerAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HammerAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HammerAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HammerAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight3",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.2,
		Unblockable = true,
		IsKnockdown = true
	}
}

-- CastSwordsTargeted --
CombatSequences.CastSwordsTargeted = {}
CombatSequences.CastSwordsTargeted.Priority = SequencePriorities.PreferredAttack
CombatSequences.CastSwordsTargeted.Zones = {}
CombatSequences.CastSwordsTargeted.Zones[CombatZones.Far] = true
CombatSequences.CastSwordsTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "SpellCastForwardInto",
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellCastForwardLoop"
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellCastForwardOutOf"
	}
}

-- CastSwordsSurrounded --
CombatSequences.CastSwordsSurrounded = {}
CombatSequences.CastSwordsSurrounded.IsValid = Predicate.CreatureHasHealthBelow(50)
CombatSequences.CastSwordsSurrounded.Priority = SequencePriorities.Attack
CombatSequences.CastSwordsSurrounded.Zones = {}
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.Near] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.Middle] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.Far] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.Left] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.Right] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.Rear] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.OuterRing] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.LeftFar] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.RightFar] = true
CombatSequences.CastSwordsSurrounded.Zones[CombatZones.RearFar] = true
CombatSequences.CastSwordsSurrounded.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "AreaQuickCast",
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		PowerLevel = 4
	}
}

-- CastForcePushSurrounded --
CombatSequences.CastForcePushSurrounded = {}
CombatSequences.CastForcePushSurrounded.IsValid = Predicate.IsSurrounded
CombatSequences.CastForcePushSurrounded.Priority = SequencePriorities.PreferredAttack
CombatSequences.CastForcePushSurrounded.Zones = {}
CombatSequences.CastForcePushSurrounded.Zones[CombatZones.Near] = true
CombatSequences.CastForcePushSurrounded.Zones[CombatZones.Middle] = true
CombatSequences.CastForcePushSurrounded.Zones[CombatZones.Far] = true
CombatSequences.CastForcePushSurrounded.Zones[CombatZones.Left] = true
CombatSequences.CastForcePushSurrounded.Zones[CombatZones.Right] = true
CombatSequences.CastForcePushSurrounded.Zones[CombatZones.Rear] = true
CombatSequences.CastForcePushSurrounded.Zones[CombatZones.OuterRing] = true
CombatSequences.CastForcePushSurrounded.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "AreaQuickCast",
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		PowerLevel = 2
	}
}

-- CastForcePushTargeted --
CombatSequences.CastForcePushTargeted = {}
CombatSequences.CastForcePushTargeted.Priority = SequencePriorities.PreferredAttack
CombatSequences.CastForcePushTargeted.Zones = {}
CombatSequences.CastForcePushTargeted.Zones[CombatZones.Near] = true
CombatSequences.CastForcePushTargeted.Zones[CombatZones.Middle] = true
CombatSequences.CastForcePushTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "AreaQuickCast",
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_SURROUND,
		PowerLevel = 2
	}
}

-- CastMayorForcePushTargeted --
CombatSequences.CastMayorForcePushTargeted = {}
CombatSequences.CastMayorForcePushTargeted.Priority = SequencePriorities.PreferredAttack
CombatSequences.CastMayorForcePushTargeted.Zones = {}
CombatSequences.CastMayorForcePushTargeted.Zones[CombatZones.Near] = true
CombatSequences.CastMayorForcePushTargeted.Zones[CombatZones.Middle] = true
CombatSequences.CastMayorForcePushTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "PeacefulWorshipInto",
		SpellType = ESpellType.SPELL_FORCE_PUSH,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 3
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "PeacefulWorshipOutOf"
	}
}

-- CastMayorSwordsTargeted --
CombatSequences.CastMayorSwordsTargeted = {}
CombatSequences.CastMayorSwordsTargeted.Priority = SequencePriorities.PreferredAttack
CombatSequences.CastMayorSwordsTargeted.Zones = {}
CombatSequences.CastMayorSwordsTargeted.Zones[CombatZones.Far] = true
CombatSequences.CastMayorSwordsTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "PeacefulWorshipInto",
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 3
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "PeacefulWorshipOutOf"
	}
}

-- CastLightningTargeted --
CombatSequences.CastLightningTargeted = {}
CombatSequences.CastLightningTargeted.Priority = SequencePriorities.PreferredAttack
CombatSequences.CastLightningTargeted.Zones = {}
CombatSequences.CastLightningTargeted.Zones[CombatZones.Far] = true
CombatSequences.CastLightningTargeted.Zones[CombatZones.Middle] = true
CombatSequences.CastLightningTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "SpellCastForwardInto",
		SpellType = ESpellType.SPELL_LIGHTNING,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellCastForwardLoop"
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellCastForwardOutOf"
	}
}

-- GarthVortexSwordTargetCombo --
CombatSequences.GarthVortexSwordTargetCombo = {}
CombatSequences.GarthVortexSwordTargetCombo.Priority = SequencePriorities.PreferredAttack
CombatSequences.GarthVortexSwordTargetCombo.Zones = {}
CombatSequences.GarthVortexSwordTargetCombo.Zones[CombatZones.Far] = true
CombatSequences.GarthVortexSwordTargetCombo.Zones[CombatZones.Middle] = true
CombatSequences.GarthVortexSwordTargetCombo.Zones[CombatZones.Near] = true
CombatSequences.GarthVortexSwordTargetCombo.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "SpellCastForwardInto",
		SpellType = ESpellType.SPELL_VORTEX,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellCastForwardLoop"
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellCastForwardOutOf"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "SpellCastForwardInto",
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 2
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellCastForwardLoop"
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SpellCastForwardOutOf"
	}
}

-- ReaverMeleeForwards --
CombatSequences.ReaverMeleeForwards = {}
CombatSequences.ReaverMeleeForwards.Priority = SequencePriorities.Attack
CombatSequences.ReaverMeleeForwards.Zones = {}
CombatSequences.ReaverMeleeForwards.Zones[CombatZones.Near] = true
CombatSequences.ReaverMeleeForwards.Zones[CombatZones.Rear] = true
CombatSequences.ReaverMeleeForwards.Zones[CombatZones.Left] = true
CombatSequences.ReaverMeleeForwards.Zones[CombatZones.Right] = true
CombatSequences.ReaverMeleeForwards.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE_UNSHEATHE_AND_SHEATHE_WEAPON,
		Anim = "DrawStrikeFlourishForwards",
		IsKnockdown = true,
		Unblockable = true,
		FaceTarget = true,
		Priority = EActionPriority.PRIORITY_MAGIC,
		SpeedMultiplier = 0.8,
		HandDummy = DummyObjects.HAND_LEFT
	}
}

-- ReaverRollBackShooting --
CombatSequences.ReaverRollBackShooting = {}
CombatSequences.ReaverRollBackShooting.Priority = SequencePriorities.Attack
CombatSequences.ReaverRollBackShooting.Zones = {}
CombatSequences.ReaverRollBackShooting.Zones[CombatZones.Near] = true
CombatSequences.ReaverRollBackShooting.Zones[CombatZones.Middle] = true
CombatSequences.ReaverRollBackShooting.Zones[CombatZones.Left] = true
CombatSequences.ReaverRollBackShooting.Zones[CombatZones.Right] = true
CombatSequences.ReaverRollBackShooting.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackward"
	}
}

-- ReaverSnapFire --
CombatSequences.ReaverSnapFire = {}
CombatSequences.ReaverSnapFire.Priority = SequencePriorities.Attack
CombatSequences.ReaverSnapFire.Zones = {}
CombatSequences.ReaverSnapFire.Zones[CombatZones.Near] = true
CombatSequences.ReaverSnapFire.Zones[CombatZones.Middle] = true
CombatSequences.ReaverSnapFire.Zones[CombatZones.Far] = true
CombatSequences.ReaverSnapFire.Actions = {
	{
		Type = EScriptableAction.SHOOT,
		Anim = "ShootFromHip"
	}
}

-- DrawAndStrikeFrontNear --
CombatSequences.DrawAndStrikeFrontNear = {}
CombatSequences.DrawAndStrikeFrontNear.Priority = SequencePriorities.Attack
CombatSequences.DrawAndStrikeFrontNear.Uninterruptable = true
CombatSequences.DrawAndStrikeFrontNear.Zones = {}
CombatSequences.DrawAndStrikeFrontNear.Zones[CombatZones.Near] = true
CombatSequences.DrawAndStrikeFrontNear.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE_UNSHEATHE_AND_SHEATHE_WEAPON,
		Anim = "DrawStrikeFlourishForwards",
		IsKnockdown = true,
		Unblockable = true,
		FaceTarget = false,
		Priority = EActionPriority.PRIORITY_MAGIC,
		HandDummy = DummyObjects.HAND_LEFT
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "FastBackOff"
	}
}

-- DrawAndStrikeFrontMiddle --
CombatSequences.DrawAndStrikeFrontMiddle = {}
CombatSequences.DrawAndStrikeFrontMiddle.Priority = SequencePriorities.Attack
CombatSequences.DrawAndStrikeFrontMiddle.Uninterruptable = true
CombatSequences.DrawAndStrikeFrontMiddle.Zones = {}
CombatSequences.DrawAndStrikeFrontMiddle.Zones[CombatZones.Middle] = true
CombatSequences.DrawAndStrikeFrontMiddle.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE_UNSHEATHE_AND_SHEATHE_WEAPON,
		Anim = "DrawStrikeFlourishForwards",
		IsKnockdown = true,
		Unblockable = true,
		FaceTarget = false,
		Priority = EActionPriority.PRIORITY_MAGIC,
		HandDummy = DummyObjects.HAND_LEFT
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeBackwards"
	}
}

-- DrawAndStrikeBack --
CombatSequences.DrawAndStrikeBack = {}
CombatSequences.DrawAndStrikeBack.Priority = SequencePriorities.PreferredAttack
CombatSequences.DrawAndStrikeBack.Uninterruptable = true
CombatSequences.DrawAndStrikeBack.Zones = {}
CombatSequences.DrawAndStrikeBack.Zones[CombatZones.Rear] = true
CombatSequences.DrawAndStrikeBack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE_UNSHEATHE_AND_SHEATHE_WEAPON,
		Anim = "DrawStrikeFlourishBackwards",
		IsKnockdown = true,
		Unblockable = true,
		FaceTarget = false,
		Priority = EActionPriority.PRIORITY_MAGIC,
		HandDummy = DummyObjects.HAND_LEFT
	}
}

-- DrawAndStrikeLeft --
CombatSequences.DrawAndStrikeLeft = {}
CombatSequences.DrawAndStrikeLeft.Priority = SequencePriorities.PreferredAttack
CombatSequences.DrawAndStrikeLeft.Uninterruptable = true
CombatSequences.DrawAndStrikeLeft.Zones = {}
CombatSequences.DrawAndStrikeLeft.Zones[CombatZones.Left] = true
CombatSequences.DrawAndStrikeLeft.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE_UNSHEATHE_AND_SHEATHE_WEAPON,
		Anim = "DrawStrikeFlourishLeft",
		IsKnockdown = true,
		Unblockable = true,
		FaceTarget = false,
		Priority = EActionPriority.PRIORITY_MAGIC,
		HandDummy = DummyObjects.HAND_LEFT
	}
}

-- DrawAndStrikeRight --
CombatSequences.DrawAndStrikeRight = {}
CombatSequences.DrawAndStrikeRight.Priority = SequencePriorities.PreferredAttack
CombatSequences.DrawAndStrikeRight.Uninterruptable = true
CombatSequences.DrawAndStrikeRight.Zones = {}
CombatSequences.DrawAndStrikeRight.Zones[CombatZones.Right] = true
CombatSequences.DrawAndStrikeRight.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE_UNSHEATHE_AND_SHEATHE_WEAPON,
		Anim = "DrawStrikeFlourishRight",
		IsKnockdown = true,
		Unblockable = true,
		FaceTarget = false,
		Priority = EActionPriority.PRIORITY_MAGIC,
		HandDummy = DummyObjects.HAND_LEFT
	}
}

-- ShootBack --
CombatSequences.ShootBack = {}
CombatSequences.ShootBack.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShootBack.Zones = {}
CombatSequences.ShootBack.Zones[CombatZones.RearFar] = true
CombatSequences.ShootBack.Actions = {
	{

	}
}

-- ShootLeft --
CombatSequences.ShootLeft = {}
CombatSequences.ShootLeft.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShootLeft.Zones = {}
CombatSequences.ShootLeft.Zones[CombatZones.LeftFar] = true
CombatSequences.ShootLeft.Actions = {
	{

	}
}

-- ShootRight --
CombatSequences.ShootRight = {}
CombatSequences.ShootRight.Priority = SequencePriorities.PreferredAttack
CombatSequences.ShootRight.Zones = {}
CombatSequences.ShootRight.Zones[CombatZones.RightFar] = true
CombatSequences.ShootRight.Actions = {
	{

	}
}



-- uncomment for debug
-- GUI.DisplayMessageBox("Fable2LegacySequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end