
-- DervishQueenVortex --
CombatSequences.DervishQueenVortex = {}
CombatSequences.DervishQueenVortex.Priority = SequencePriorities.PreferredAttack
CombatSequences.DervishQueenVortex.Zones = {}
CombatSequences.DervishQueenVortex.Zones[CombatZones.Far] = true
CombatSequences.DervishQueenVortex.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "SpellCast",
		SpellType = ESpellType.SPELL_VORTEX,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	}
}

-- HighwaymanRollBack --
CombatSequences.HighwaymanRollBack = {}
CombatSequences.HighwaymanRollBack.Priority = SequencePriorities.Movement
CombatSequences.HighwaymanRollBack.Uninterruptable = true
CombatSequences.HighwaymanRollBack.Zones = {}
CombatSequences.HighwaymanRollBack.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanRollBack.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanStrikeThenRoll --
CombatSequences.HighwaymanStrikeThenRoll = {}
CombatSequences.HighwaymanStrikeThenRoll.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanStrikeThenRoll.IsCombo = true
CombatSequences.HighwaymanStrikeThenRoll.Zones = {}
CombatSequences.HighwaymanStrikeThenRoll.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanStrikeThenRoll.ZonesWhilePlaying = {}
CombatSequences.HighwaymanStrikeThenRoll.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanStrikeThenRoll.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanStrikeThenRoll.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		SpeedMultiplier = 1.3,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanGoad --
CombatSequences.HighwaymanGoad = {}
CombatSequences.HighwaymanGoad.Priority = SequencePriorities.Idle
CombatSequences.HighwaymanGoad.Zones = {}
CombatSequences.HighwaymanGoad.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanGoad.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanGoad.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad"
	}
}

-- HighwaymanCloseAttackCombo --
CombatSequences.HighwaymanCloseAttackCombo = {}
CombatSequences.HighwaymanCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCloseAttackCombo.IsCombo = true
CombatSequences.HighwaymanCloseAttackCombo.Zones = {}
CombatSequences.HighwaymanCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanAttackCombo --
CombatSequences.HighwaymanAttackCombo = {}
CombatSequences.HighwaymanAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanAttackCombo.IsCombo = true
CombatSequences.HighwaymanAttackCombo.Zones = {}
CombatSequences.HighwaymanAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HighwaymanAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		TurnPerMetre = 180,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanFarAttackCombo --
CombatSequences.HighwaymanFarAttackCombo = {}
CombatSequences.HighwaymanFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanFarAttackCombo.IsCombo = true
CombatSequences.HighwaymanFarAttackCombo.Zones = {}
CombatSequences.HighwaymanFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HighwaymanFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HighwaymanFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		TurnPerMetre = 180,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanLeftAttack --
CombatSequences.HighwaymanLeftAttack = {}
CombatSequences.HighwaymanLeftAttack.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanLeftAttack.Zones = {}
CombatSequences.HighwaymanLeftAttack.Zones[CombatZones.Left] = true
CombatSequences.HighwaymanLeftAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendOutTime = 0.3
	}
}

-- HighwaymanRightAttack --
CombatSequences.HighwaymanRightAttack = {}
CombatSequences.HighwaymanRightAttack.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanRightAttack.Zones = {}
CombatSequences.HighwaymanRightAttack.Zones[CombatZones.Right] = true
CombatSequences.HighwaymanRightAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		BlendOutTime = 0.3
	}
}

-- HighwaymanRearAttack --
CombatSequences.HighwaymanRearAttack = {}
CombatSequences.HighwaymanRearAttack.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanRearAttack.IsCombo = true
CombatSequences.HighwaymanRearAttack.Zones = {}
CombatSequences.HighwaymanRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.HighwaymanRearAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		IsComboBreak = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- HighwaymanOrbSuckingResponse --
CombatSequences.HighwaymanOrbSuckingResponse = {}
CombatSequences.HighwaymanOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HighwaymanOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanOrbSuckingResponse.CounterAttack = true
CombatSequences.HighwaymanOrbSuckingResponse.Zones = {}
CombatSequences.HighwaymanOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		IsComboBreak = true
	}
}

-- HighwaymanEliteCloseAttackCombo --
CombatSequences.HighwaymanEliteCloseAttackCombo = {}
CombatSequences.HighwaymanEliteCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanEliteCloseAttackCombo.IsCombo = true
CombatSequences.HighwaymanEliteCloseAttackCombo.Zones = {}
CombatSequences.HighwaymanEliteCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanEliteCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanEliteAttackCombo --
CombatSequences.HighwaymanEliteAttackCombo = {}
CombatSequences.HighwaymanEliteAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanEliteAttackCombo.IsCombo = true
CombatSequences.HighwaymanEliteAttackCombo.Zones = {}
CombatSequences.HighwaymanEliteAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanEliteAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HighwaymanEliteAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanEliteAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanEliteAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		TurnPerMetre = 180,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanEliteFarAttackCombo --
CombatSequences.HighwaymanEliteFarAttackCombo = {}
CombatSequences.HighwaymanEliteFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanEliteFarAttackCombo.IsCombo = true
CombatSequences.HighwaymanEliteFarAttackCombo.Zones = {}
CombatSequences.HighwaymanEliteFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanEliteFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HighwaymanEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanEliteFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HighwaymanEliteFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		TurnPerMetre = 180,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanGroupShooting --
CombatSequences.HighwaymanGroupShooting = {}
CombatSequences.HighwaymanGroupShooting.IsValid = Predicate.GroupOrderIsShoot
CombatSequences.HighwaymanGroupShooting.Priority = SequencePriorities.PreferredAttack
CombatSequences.HighwaymanGroupShooting.CounterAttack = true
CombatSequences.HighwaymanGroupShooting.IsCombo = true
CombatSequences.HighwaymanGroupShooting.Zones = {}
CombatSequences.HighwaymanGroupShooting.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanGroupShooting.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanGroupShooting.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanGroupShooting.Actions = {
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT,
		EntityName = "NPC_F3_Dervish_Crossbow",
		Anim = "RapidPistolShotUnsheathe",
		HasMovement = true,
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "RapidPistolShotShoot",
		Knockdown = false,
		DoReload = false,
		FaceTargetAtStart = true
	},
	{
		Type = EScriptableAction.DESTROY_ENTITY_IN_SLOT,
		Anim = "RapidPistolShotSheathe"
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad"
	}
}

-- HighwaymanRollBackShooting --
CombatSequences.HighwaymanRollBackShooting = {}
CombatSequences.HighwaymanRollBackShooting.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.HighwaymanRollBackShooting.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanRollBackShooting.CounterAttack = true
CombatSequences.HighwaymanRollBackShooting.Zones = {}
CombatSequences.HighwaymanRollBackShooting.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanRollBackShooting.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanRollBackShooting.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanRollBackShooting.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT,
		EntityName = "NPC_F3_Dervish_Crossbow",
		Anim = "RapidPistolShotUnsheathe",
		HasMovement = false,
		FaceTargetThroughout = true
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "RapidPistolShotShoot",
		SpeedMultiplier = 2,
		Knockdown = false,
		DoReload = false,
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.DESTROY_ENTITY_IN_SLOT,
		Anim = "RapidPistolShotSheathe",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- HighwaymanGetRidOfPistol --
CombatSequences.HighwaymanGetRidOfPistol = {}
CombatSequences.HighwaymanGetRidOfPistol.IsValid = Predicate.HoldingPistolInLeftHand
CombatSequences.HighwaymanGetRidOfPistol.Priority = SequencePriorities.PreferredAttack
CombatSequences.HighwaymanGetRidOfPistol.CounterAttack = true
CombatSequences.HighwaymanGetRidOfPistol.Uninterruptable = true
CombatSequences.HighwaymanGetRidOfPistol.Zones = {}
CombatSequences.HighwaymanGetRidOfPistol.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanGetRidOfPistol.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanGetRidOfPistol.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanGetRidOfPistol.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanGetRidOfPistol.Actions = {
	{
		Type = EScriptableAction.DESTROY_ENTITY_IN_SLOT,
		Anim = "RapidPistolShotSheathe"
	}
}

-- HighwaymanIdleStrafeLeft --
CombatSequences.HighwaymanIdleStrafeLeft = {}
CombatSequences.HighwaymanIdleStrafeLeft.Priority = SequencePriorities.Idle
CombatSequences.HighwaymanIdleStrafeLeft.Zones = {}
CombatSequences.HighwaymanIdleStrafeLeft.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanIdleStrafeLeft.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanIdleStrafeLeft.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanIdleStrafeLeft.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeLeft",
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeLeft",
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeLeft",
		SpeedMultiplier = 2
	}
}

-- HighwaymanIdleStrafeRight --
CombatSequences.HighwaymanIdleStrafeRight = {}
CombatSequences.HighwaymanIdleStrafeRight.Priority = SequencePriorities.Idle
CombatSequences.HighwaymanIdleStrafeRight.Zones = {}
CombatSequences.HighwaymanIdleStrafeRight.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanIdleStrafeRight.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanIdleStrafeRight.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanIdleStrafeRight.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeRight",
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeRight",
		SpeedMultiplier = 2
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeRight",
		SpeedMultiplier = 2
	}
}

-- HighwaymanHeroFlourishResponse --
CombatSequences.HighwaymanHeroFlourishResponse = {}
CombatSequences.HighwaymanHeroFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.HighwaymanHeroFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanHeroFlourishResponse.CounterAttack = true
CombatSequences.HighwaymanHeroFlourishResponse.Zones = {}
CombatSequences.HighwaymanHeroFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanHeroFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanHeroFlourishResponse.ZonesWhilePlaying = {}
CombatSequences.HighwaymanHeroFlourishResponse.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanHeroFlourishResponse.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanHeroFlourishResponse.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanShotTooMuch --
CombatSequences.HighwaymanShotTooMuch = {}
CombatSequences.HighwaymanShotTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.HighwaymanShotTooMuch.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanShotTooMuch.CounterAttack = true
CombatSequences.HighwaymanShotTooMuch.Zones = {}
CombatSequences.HighwaymanShotTooMuch.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanShotTooMuch.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards",
		SpeedMultiplier = 2.2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT,
		EntityName = "NPC_F3_Dervish_Crossbow",
		Anim = "RapidPistolShotUnsheathe",
		HasMovement = false,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "RapidPistolShotShoot",
		SpeedMultiplier = 2.2,
		Knockdown = false,
		DoReload = false,
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.DESTROY_ENTITY_IN_SLOT,
		Anim = "RapidPistolShotSheathe",
		SpeedMultiplier = 2.2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2.2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- HighwaymanEliteOrbSuckingResponse --
CombatSequences.HighwaymanEliteOrbSuckingResponse = {}
CombatSequences.HighwaymanEliteOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HighwaymanEliteOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanEliteOrbSuckingResponse.CounterAttack = true
CombatSequences.HighwaymanEliteOrbSuckingResponse.Zones = {}
CombatSequences.HighwaymanEliteOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanEliteOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanEliteOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanEliteOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		IsComboBreak = true
	}
}

-- HighwaymanDariusCloseAttackCombo --
CombatSequences.HighwaymanDariusCloseAttackCombo = {}
CombatSequences.HighwaymanDariusCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanDariusCloseAttackCombo.IsCombo = true
CombatSequences.HighwaymanDariusCloseAttackCombo.Zones = {}
CombatSequences.HighwaymanDariusCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanDariusCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	}
}

-- HighwaymanDariusAttackCombo --
CombatSequences.HighwaymanDariusAttackCombo = {}
CombatSequences.HighwaymanDariusAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanDariusAttackCombo.IsCombo = true
CombatSequences.HighwaymanDariusAttackCombo.Zones = {}
CombatSequences.HighwaymanDariusAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanDariusAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HighwaymanDariusAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanDariusAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanDariusAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		TurnPerMetre = 180,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	}
}

-- HighwaymanCloseAttackCombo --
CombatSequences.HighwaymanDariusFarAttackCombo = {}
CombatSequences.HighwaymanDariusFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanDariusFarAttackCombo.IsCombo = true
CombatSequences.HighwaymanDariusFarAttackCombo.Zones = {}
CombatSequences.HighwaymanDariusFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanDariusFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HighwaymanDariusFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanDariusFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanDariusFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HighwaymanDariusFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		TurnPerMetre = 180,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	}
}

-- HighwaymanDariusTeleportAttack --
CombatSequences.HighwaymanDariusTeleportAttack = {}
CombatSequences.HighwaymanDariusTeleportAttack.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanDariusTeleportAttack.CounterAttack = true
CombatSequences.HighwaymanDariusTeleportAttack.IsCombo = true
CombatSequences.HighwaymanDariusTeleportAttack.Zones = {}
CombatSequences.HighwaymanDariusTeleportAttack.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanDariusTeleportAttack.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanDariusTeleportAttack.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanDariusTeleportAttack.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanDariusTeleportAttack.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 3
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanDariusTeleportDodgeAttack --
CombatSequences.HighwaymanDariusTeleportDodgeAttack = {}
CombatSequences.HighwaymanDariusTeleportDodgeAttack.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanDariusTeleportDodgeAttack.CounterAttack = true
CombatSequences.HighwaymanDariusTeleportDodgeAttack.IsCombo = true
CombatSequences.HighwaymanDariusTeleportDodgeAttack.Zones = {}
CombatSequences.HighwaymanDariusTeleportDodgeAttack.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanDariusTeleportDodgeAttack.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanDariusTeleportDodgeAttack.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanDariusTeleportDodgeAttack.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanDariusTeleportDodgeAttack.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.3,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- HighwaymanDariusShotTooMuch --
CombatSequences.HighwaymanDariusShotTooMuch = {}
CombatSequences.HighwaymanDariusShotTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.HighwaymanDariusShotTooMuch.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanDariusShotTooMuch.CounterAttack = true
CombatSequences.HighwaymanDariusShotTooMuch.Zones = {}
CombatSequences.HighwaymanDariusShotTooMuch.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanDariusShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanDariusShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanDariusShotTooMuch.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards",
		SpeedMultiplier = 4,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT,
		EntityName = "NPC_F3_Dervish_Crossbow",
		Anim = "RapidPistolShotUnsheathe",
		HasMovement = false,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.SHOOT,
		Anim = "RapidPistolShotShoot",
		SpeedMultiplier = 4,
		Knockdown = false,
		DoReload = false,
		FaceTargetAtStart = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.DESTROY_ENTITY_IN_SLOT,
		Anim = "RapidPistolShotSheathe",
		SpeedMultiplier = 3,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	}
}

-- HighwaymanDariusMagicedTooMuch --
CombatSequences.HighwaymanDariusMagicedTooMuch = {}
CombatSequences.HighwaymanDariusMagicedTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_SPELL, 5)
CombatSequences.HighwaymanDariusMagicedTooMuch.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanDariusMagicedTooMuch.CounterAttack = true
CombatSequences.HighwaymanDariusMagicedTooMuch.Zones = {}
CombatSequences.HighwaymanDariusMagicedTooMuch.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanDariusMagicedTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanDariusMagicedTooMuch.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanDariusMagicedTooMuch.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	}
}

-- HighwaymanDariusFlourishResponse --
CombatSequences.HighwaymanDariusFlourishResponse = {}
CombatSequences.HighwaymanDariusFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.HighwaymanDariusFlourishResponse.Priority = SequencePriorities.PreferredAttack
CombatSequences.HighwaymanDariusFlourishResponse.CounterAttack = true
CombatSequences.HighwaymanDariusFlourishResponse.Zones = {}
CombatSequences.HighwaymanDariusFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanDariusFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanDariusFlourishResponse.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanDariusFlourishResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "RollForwards",
		SpeedMultiplier = 4,
		SpellType = ESpellType.SPELL_SLOW_TIME,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- HighwaymanCorneliusRollBack --
CombatSequences.HighwaymanCorneliusRollBack = {}
CombatSequences.HighwaymanCorneliusRollBack.Priority = SequencePriorities.Movement
CombatSequences.HighwaymanCorneliusRollBack.Uninterruptable = true
CombatSequences.HighwaymanCorneliusRollBack.Zones = {}
CombatSequences.HighwaymanCorneliusRollBack.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusRollBack.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanCorneliusStrikeThenRoll --
CombatSequences.HighwaymanCorneliusStrikeThenRoll = {}
CombatSequences.HighwaymanCorneliusStrikeThenRoll.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCorneliusStrikeThenRoll.IsCombo = true
CombatSequences.HighwaymanCorneliusStrikeThenRoll.Zones = {}
CombatSequences.HighwaymanCorneliusStrikeThenRoll.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusStrikeThenRoll.ZonesWhilePlaying = {}
CombatSequences.HighwaymanCorneliusStrikeThenRoll.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusStrikeThenRoll.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusStrikeThenRoll.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanCorneliusGoad --
CombatSequences.HighwaymanCorneliusGoad = {}
CombatSequences.HighwaymanCorneliusGoad.Priority = SequencePriorities.Idle
CombatSequences.HighwaymanCorneliusGoad.Zones = {}
CombatSequences.HighwaymanCorneliusGoad.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusGoad.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanCorneliusGoad.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad"
	}
}

-- HighwaymanCorneliusCloseAttackCombo --
CombatSequences.HighwaymanCorneliusCloseAttackCombo = {}
CombatSequences.HighwaymanCorneliusCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCorneliusCloseAttackCombo.IsCombo = true
CombatSequences.HighwaymanCorneliusCloseAttackCombo.Zones = {}
CombatSequences.HighwaymanCorneliusCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.5,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTarget = true,
		SpeedMultiplier = 1.5,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.25,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.25,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanCorneliusAttackCombo --
CombatSequences.HighwaymanCorneliusAttackCombo = {}
CombatSequences.HighwaymanCorneliusAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCorneliusAttackCombo.IsCombo = true
CombatSequences.HighwaymanCorneliusAttackCombo.Zones = {}
CombatSequences.HighwaymanCorneliusAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HighwaymanCorneliusAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.5,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		TurnPerMetre = 180,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.25,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.25,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanCorneliusFarAttackCombo --
CombatSequences.HighwaymanCorneliusFarAttackCombo = {}
CombatSequences.HighwaymanCorneliusFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCorneliusFarAttackCombo.IsCombo = true
CombatSequences.HighwaymanCorneliusFarAttackCombo.Zones = {}
CombatSequences.HighwaymanCorneliusFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanCorneliusFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.HighwaymanCorneliusFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.HighwaymanCorneliusFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = true,
		SpeedMultiplier = 1.5,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		TurnPerMetre = 180,
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeA",
		FaceTarget = true,
		SpeedMultiplier = 1.25,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeB",
		FaceTarget = true,
		SpeedMultiplier = 1.25,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards"
	}
}

-- HighwaymanCorneliusOrbSuckingResponse --
CombatSequences.HighwaymanCorneliusOrbSuckingResponse = {}
CombatSequences.HighwaymanCorneliusOrbSuckingResponse.IsValid = Predicate.IsSuckModeActive
CombatSequences.HighwaymanCorneliusOrbSuckingResponse.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCorneliusOrbSuckingResponse.CounterAttack = true
CombatSequences.HighwaymanCorneliusOrbSuckingResponse.Zones = {}
CombatSequences.HighwaymanCorneliusOrbSuckingResponse.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusOrbSuckingResponse.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusOrbSuckingResponse.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanCorneliusOrbSuckingResponse.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "Goad",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- HighwaymanCorneliusCastSwordsTargeted --
CombatSequences.HighwaymanCorneliusCastSwordsTargeted = {}
CombatSequences.HighwaymanCorneliusCastSwordsTargeted.Priority = SequencePriorities.PreferredAttack
CombatSequences.HighwaymanCorneliusCastSwordsTargeted.Zones = {}
CombatSequences.HighwaymanCorneliusCastSwordsTargeted.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusCastSwordsTargeted.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusCastSwordsTargeted.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanCorneliusCastSwordsTargeted.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanCorneliusCastSwordsTargeted.Actions = {
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "Goad",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- HighwaymanCorneliusShotTooMuch --
CombatSequences.HighwaymanCorneliusShotTooMuch = {}
CombatSequences.HighwaymanCorneliusShotTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5)
CombatSequences.HighwaymanCorneliusShotTooMuch.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCorneliusShotTooMuch.CounterAttack = true
CombatSequences.HighwaymanCorneliusShotTooMuch.Zones = {}
CombatSequences.HighwaymanCorneliusShotTooMuch.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanCorneliusShotTooMuch.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "Goad",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- HighwaymanCorneliusMagicedTooMuch --
CombatSequences.HighwaymanCorneliusMagicedTooMuch = {}
CombatSequences.HighwaymanCorneliusMagicedTooMuch.IsValid = Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_SPELL, 5)
CombatSequences.HighwaymanCorneliusMagicedTooMuch.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCorneliusMagicedTooMuch.CounterAttack = true
CombatSequences.HighwaymanCorneliusMagicedTooMuch.Zones = {}
CombatSequences.HighwaymanCorneliusMagicedTooMuch.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusMagicedTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusMagicedTooMuch.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanCorneliusMagicedTooMuch.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "Goad",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- HighwaymanCorneliusRollBackCastSwords --
CombatSequences.HighwaymanCorneliusRollBackCastSwords = {}
CombatSequences.HighwaymanCorneliusRollBackCastSwords.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(1)
CombatSequences.HighwaymanCorneliusRollBackCastSwords.Priority = SequencePriorities.Attack
CombatSequences.HighwaymanCorneliusRollBackCastSwords.CounterAttack = true
CombatSequences.HighwaymanCorneliusRollBackCastSwords.Zones = {}
CombatSequences.HighwaymanCorneliusRollBackCastSwords.Zones[CombatZones.Near] = true
CombatSequences.HighwaymanCorneliusRollBackCastSwords.Zones[CombatZones.Middle] = true
CombatSequences.HighwaymanCorneliusRollBackCastSwords.Zones[CombatZones.Far] = true
CombatSequences.HighwaymanCorneliusRollBackCastSwords.Zones[CombatZones.OuterRing] = true
CombatSequences.HighwaymanCorneliusRollBackCastSwords.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "RollBackwards",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.NPC_MAGIC_QUICK_CAST,
		Anim = "Goad",
		SpeedMultiplier = 2,
		SpellType = ESpellType.SPELL_SWORDS,
		SpellDirectionMode = ESpellCastDirMode.eSCDM_TARGETED,
		PowerLevel = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "Goad",
		SpeedMultiplier = 2,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
	}
}

-- AssassinShotTooMuch --
CombatSequences.AssassinShotTooMuch = {}
CombatSequences.AssassinShotTooMuch.IsValid = Predicate.OR(
	{
		Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_RANGED, 5),
		Predicate.CreateHasTakenThisMuchDamageOfTypeInTimePredicate(1, EAttackType.ATTACK_SPELL, 5)
	}
)
CombatSequences.AssassinShotTooMuch.Priority = SequencePriorities.Attack
CombatSequences.AssassinShotTooMuch.CounterAttack = true
CombatSequences.AssassinShotTooMuch.IsCombo = true
CombatSequences.AssassinShotTooMuch.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.AssassinShotTooMuch.Zones = {}
CombatSequences.AssassinShotTooMuch.Zones[CombatZones.Middle] = true
CombatSequences.AssassinShotTooMuch.Zones[CombatZones.Far] = true
CombatSequences.AssassinShotTooMuch.ZonesWhilePlaying = {}
CombatSequences.AssassinShotTooMuch.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AssassinShotTooMuch.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AssassinShotTooMuch.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.AssassinShotTooMuch.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		PushBackStrike = 0.3,
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
}

-- AssassinFarAttackCombo --
CombatSequences.AssassinFarAttackCombo = {}
CombatSequences.AssassinFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.AssassinFarAttackCombo.IsCombo = true
CombatSequences.AssassinFarAttackCombo.Zones = {}
CombatSequences.AssassinFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.AssassinFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.AssassinFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AssassinFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AssassinFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.AssassinFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "TripleStrikeC",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_START",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		PushBackStrike = 0.5,
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		PushBackStrike = 0.6,
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeBackwards"
	}
}

-- AssassinAttackCombo --
CombatSequences.AssassinAttackCombo = {}
CombatSequences.AssassinAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.AssassinAttackCombo.IsCombo = true
CombatSequences.AssassinAttackCombo.Zones = {}
CombatSequences.AssassinAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.AssassinAttackCombo.ZonesWhilePlaying = {}
CombatSequences.AssassinAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AssassinAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AssassinAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeB",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		PushBackStrike = 0.6,
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		PushBackStrike = 0.5,
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeBackwards"
	}
}

-- AssassinCloseAttackCombo --
CombatSequences.AssassinCloseAttackCombo = {}
CombatSequences.AssassinCloseAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.AssassinCloseAttackCombo.IsCombo = true
CombatSequences.AssassinCloseAttackCombo.Zones = {}
CombatSequences.AssassinCloseAttackCombo.Zones[CombatZones.Near] = true
CombatSequences.AssassinCloseAttackCombo.ZonesWhilePlaying = {}
CombatSequences.AssassinCloseAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AssassinCloseAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		FaceTarget = false,
		SpeedMultiplier = 1,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		FaceTarget = false,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		PushBackStrike = 0.5,
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeB",
		PushBackStrike = 0.6,
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	},
	{
		Type = EScriptableAction.STRAFE,
		Anim = "CombatStrafeBackwards"
	}
}

-- AssassinLeftRightCombo --
CombatSequences.AssassinLeftRightCombo = {}
CombatSequences.AssassinLeftRightCombo.Priority = SequencePriorities.Attack
CombatSequences.AssassinLeftRightCombo.Zones = {}
CombatSequences.AssassinLeftRightCombo.Zones[CombatZones.Near] = true
CombatSequences.AssassinLeftRightCombo.Zones[CombatZones.Middle] = true
CombatSequences.AssassinLeftRightCombo.ZonesWhilePlaying = {}
CombatSequences.AssassinLeftRightCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AssassinLeftRightCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AssassinLeftRightCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		FaceTarget = false
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		FaceTarget = false
	}
}

-- AssassinLeftRightKickCombo --
CombatSequences.AssassinLeftRightKickCombo = {}
CombatSequences.AssassinLeftRightKickCombo.Priority = SequencePriorities.Attack
CombatSequences.AssassinLeftRightKickCombo.IsCombo = true
CombatSequences.AssassinLeftRightKickCombo.Zones = {}
CombatSequences.AssassinLeftRightKickCombo.Zones[CombatZones.Near] = true
CombatSequences.AssassinLeftRightKickCombo.Zones[CombatZones.Middle] = true
CombatSequences.AssassinLeftRightKickCombo.ZonesWhilePlaying = {}
CombatSequences.AssassinLeftRightKickCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.AssassinLeftRightKickCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.AssassinLeftRightKickCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		FaceTarget = false,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		FaceTarget = false,
		HitOutsideAttackArc = true,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "NormalSpeedTripleStrikeA",
		PushBackStrike = 0.3,
		FaceTarget = true,
		SpeedMultiplier = 1,
		IsComboBreak = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true
	}
}

-- AssassinOutOfBlock --
CombatSequences.AssassinOutOfBlock = {}
CombatSequences.AssassinOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(3)
CombatSequences.AssassinOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.AssassinOutOfBlock.CounterAttack = true
CombatSequences.AssassinOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.AssassinOutOfBlock.Zones = {}
CombatSequences.AssassinOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.AssassinOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.AssassinOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "DoubleStrikeA",
		SpeedMultiplier = 1.25,
		PushBackStrike = 3,
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		DamageMultiplier = 1.5
	}
}

-- AssassinRearAttack --
CombatSequences.AssassinRearAttack = {}
CombatSequences.AssassinRearAttack.Priority = SequencePriorities.Attack
CombatSequences.AssassinRearAttack.CounterAttack = true
CombatSequences.AssassinRearAttack.IsCombo = true
CombatSequences.AssassinRearAttack.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.AssassinRearAttack.Zones = {}
CombatSequences.AssassinRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.AssassinRearAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1,
		FaceTarget = false,
		AdditionalTurning = true,
		HitOutsideAttackArc = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
	}
}



-- uncomment for debug
-- GUI.DisplayMessageBox("HighwayMenSequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end