
-- LoganSoldierSwordGrenadeThrow --
CombatSequences.LoganSoldierSwordGrenadeThrow = {}
CombatSequences.LoganSoldierSwordGrenadeThrow.IsValid = Predicate.AND(
	{
		Predicate.TargetIsFurtherAwayThan(4.5),
		Predicate.IsCarryingWeaponOfType(WeaponTypes.Melee)
	}
)
CombatSequences.LoganSoldierSwordGrenadeThrow.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierSwordGrenadeThrow.IsCombo = true
CombatSequences.LoganSoldierSwordGrenadeThrow.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LoganSoldierSwordGrenadeThrow.Zones = {}
CombatSequences.LoganSoldierSwordGrenadeThrow.Zones[CombatZones.Far] = true
CombatSequences.LoganSoldierSwordGrenadeThrow.Actions = {
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT_AND_THROW_IT,
		EntityName = "LoganSoldierExplosive",
		Anim = "GrenadeThrow",
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Angle = 5,
		AimAtFeet = true,
		LookAheadInSeconds = 0.1
	}
}

-- LoganSoldierAntiSpamSwordGrenadeThrow --
CombatSequences.LoganSoldierAntiSpamSwordGrenadeThrow = {}
CombatSequences.LoganSoldierAntiSpamSwordGrenadeThrow.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsFurtherAwayThan(4.5),
		Predicate.IsCarryingWeaponOfType(WeaponTypes.Melee)
	}
)
CombatSequences.LoganSoldierAntiSpamSwordGrenadeThrow.CounterAttack = true
CombatSequences.LoganSoldierAntiSpamSwordGrenadeThrow.Priority = SequencePriorities.PreferredAttack
CombatSequences.LoganSoldierAntiSpamSwordGrenadeThrow.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LoganSoldierAntiSpamSwordGrenadeThrow.Zones = {}
CombatSequences.LoganSoldierAntiSpamSwordGrenadeThrow.Zones[CombatZones.Far] = true
CombatSequences.LoganSoldierAntiSpamSwordGrenadeThrow.Actions = {
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT_AND_THROW_IT,
		EntityName = "LoganSoldierExplosive",
		Anim = "GrenadeThrow",
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Angle = 5,
		AimAtFeet = true,
		LookAheadInSeconds = 0.1
	}
}

-- LoganSoldierPistolGrenadeThrow --
CombatSequences.LoganSoldierPistolGrenadeThrow = {}
CombatSequences.LoganSoldierPistolGrenadeThrow.IsValid = Predicate.TargetIsFurtherAwayThan(4.5)
CombatSequences.LoganSoldierPistolGrenadeThrow.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierPistolGrenadeThrow.IsCombo = true
CombatSequences.LoganSoldierPistolGrenadeThrow.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LoganSoldierPistolGrenadeThrow.Zones = {}
CombatSequences.LoganSoldierPistolGrenadeThrow.Zones[CombatZones.Far] = true
CombatSequences.LoganSoldierPistolGrenadeThrow.Actions = {
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT_AND_THROW_IT,
		EntityName = "LoganSoldierExplosive",
		Anim = "GrenadeThrow",
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Angle = 5,
		AimAtFeet = true,
		LookAheadInSeconds = 0.1
	}
}

-- LoganSoldierAntiSpamPistolGrenadeThrow --
CombatSequences.LoganSoldierAntiSpamPistolGrenadeThrow = {}
CombatSequences.LoganSoldierAntiSpamPistolGrenadeThrow.IsValid = Predicate.AND(
	{
		Predicate.CreateHaveIBeenStruckALotPredicate(2),
		Predicate.TargetIsFurtherAwayThan(4.5)
	}
)
CombatSequences.LoganSoldierAntiSpamPistolGrenadeThrow.Priority = SequencePriorities.PreferredAttack
CombatSequences.LoganSoldierAntiSpamPistolGrenadeThrow.CounterAttack = true
CombatSequences.LoganSoldierAntiSpamPistolGrenadeThrow.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LoganSoldierAntiSpamPistolGrenadeThrow.Zones = {}
CombatSequences.LoganSoldierAntiSpamPistolGrenadeThrow.Zones[CombatZones.Far] = true
CombatSequences.LoganSoldierAntiSpamPistolGrenadeThrow.Actions = {
	{
		Type = EScriptableAction.CREATE_ENTITY_IN_SLOT_AND_THROW_IT,
		EntityName = "LoganSoldierExplosive",
		Anim = "GrenadeThrow",
		FaceTargetThroughout = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		Angle = 5,
		AimAtFeet = true,
		LookAheadInSeconds = 0.1
	}
}

-- LoganSoldierFarAttackCombo --
CombatSequences.LoganSoldierFarAttackCombo = {}
CombatSequences.LoganSoldierFarAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierFarAttackCombo.IsCombo = true
CombatSequences.LoganSoldierFarAttackCombo.Zones = {}
CombatSequences.LoganSoldierFarAttackCombo.Zones[CombatZones.Far] = true
CombatSequences.LoganSoldierFarAttackCombo.ZonesWhilePlaying = {}
CombatSequences.LoganSoldierFarAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LoganSoldierFarAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LoganSoldierFarAttackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LoganSoldierFarAttackCombo.Actions = {
	{
		Type = EScriptableAction.STRAFE,
		Anim = "StrafeForwardOneStep"
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "SettleBackToRegularStance",
		SpeedMultiplier = 1
	}
}

-- LoganSoldierAttackComboVar01 --
CombatSequences.LoganSoldierAttackComboVar01 = {}
CombatSequences.LoganSoldierAttackComboVar01.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierAttackComboVar01.IsCombo = true
CombatSequences.LoganSoldierAttackComboVar01.Zones = {}
CombatSequences.LoganSoldierAttackComboVar01.Zones[CombatZones.Middle] = true
CombatSequences.LoganSoldierAttackComboVar01.ZonesWhilePlaying = {}
CombatSequences.LoganSoldierAttackComboVar01.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LoganSoldierAttackComboVar01.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LoganSoldierAttackComboVar01.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LoganSoldierAttackComboVar01.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeftVar001",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	}
}

-- LoganSoldierAttackCombo --
CombatSequences.LoganSoldierAttackCombo = {}
CombatSequences.LoganSoldierAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierAttackCombo.IsCombo = true
CombatSequences.LoganSoldierAttackCombo.Zones = {}
CombatSequences.LoganSoldierAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.LoganSoldierAttackCombo.ZonesWhilePlaying = {}
CombatSequences.LoganSoldierAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LoganSoldierAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LoganSoldierAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeRight",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StrikeLeft",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.PLAY_ANIMATION,
		Anim = "StrikeRight",
		SpeedMultiplier = 1
	}
}

-- LoganSoldierTwoStrikesAttackCombo --
CombatSequences.LoganSoldierTwoStrikesAttackCombo = {}
CombatSequences.LoganSoldierTwoStrikesAttackCombo.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierTwoStrikesAttackCombo.IsCombo = true
CombatSequences.LoganSoldierTwoStrikesAttackCombo.Zones = {}
CombatSequences.LoganSoldierTwoStrikesAttackCombo.Zones[CombatZones.Middle] = true
CombatSequences.LoganSoldierTwoStrikesAttackCombo.ZonesWhilePlaying = {}
CombatSequences.LoganSoldierTwoStrikesAttackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LoganSoldierTwoStrikesAttackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LoganSoldierTwoStrikesAttackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "StartingStrike",
		SpeedMultiplier = 1.1,
		FaceTarget = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FollowingStrike",
		SpeedMultiplier = 1.1,
		FaceTarget = true,
		RotateUntilNote = "STRIKE_END",
		HitOutsideAttackArc = true,
		IsComboBreak = true
	}
}

-- LoganSoldierElitePushBackCombo --
CombatSequences.LoganSoldierElitePushBackCombo = {}
CombatSequences.LoganSoldierElitePushBackCombo.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierElitePushBackCombo.IsCombo = true
CombatSequences.LoganSoldierElitePushBackCombo.Zones = {}
CombatSequences.LoganSoldierElitePushBackCombo.Zones[CombatZones.Middle] = true
CombatSequences.LoganSoldierElitePushBackCombo.Zones[CombatZones.Far] = true
CombatSequences.LoganSoldierElitePushBackCombo.ZonesWhilePlaying = {}
CombatSequences.LoganSoldierElitePushBackCombo.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LoganSoldierElitePushBackCombo.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LoganSoldierElitePushBackCombo.ZonesWhilePlaying[CombatZones.Far] = true
CombatSequences.LoganSoldierElitePushBackCombo.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeftVar001",
		SpeedMultiplier = 1.1,
		IsComboBreak = true
	},
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PushBackStrike",
		SpeedMultiplier = 1.1,
		IsComboBreak = true,
		PushBackStrike = 1.5
	}
}

-- LoganSoldierEliteClosePushBackAttack --
CombatSequences.LoganSoldierEliteClosePushBackAttack = {}
CombatSequences.LoganSoldierEliteClosePushBackAttack.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierEliteClosePushBackAttack.IsCombo = true
CombatSequences.LoganSoldierEliteClosePushBackAttack.Zones = {}
CombatSequences.LoganSoldierEliteClosePushBackAttack.Zones[CombatZones.Near] = true
CombatSequences.LoganSoldierEliteClosePushBackAttack.Zones[CombatZones.Middle] = true
CombatSequences.LoganSoldierEliteClosePushBackAttack.ZonesWhilePlaying = {}
CombatSequences.LoganSoldierEliteClosePushBackAttack.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LoganSoldierEliteClosePushBackAttack.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LoganSoldierEliteClosePushBackAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "PushBackStrike",
		SpeedMultiplier = 1.1,
		IsComboBreak = true,
		PushBackStrike = 1.5
	}
}

-- LoganSoldierInteruptAllSpellsMelee --
CombatSequences.LoganSoldierInteruptAllSpellsMelee = {}
CombatSequences.LoganSoldierInteruptAllSpellsMelee.IsValid = Predicate.CreateIsTargetChargingSpellOfAtLeastLevelPredicate(0)
CombatSequences.LoganSoldierInteruptAllSpellsMelee.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierInteruptAllSpellsMelee.Zones = {}
CombatSequences.LoganSoldierInteruptAllSpellsMelee.Zones[CombatZones.Near] = true
CombatSequences.LoganSoldierInteruptAllSpellsMelee.Zones[CombatZones.Middle] = true
CombatSequences.LoganSoldierInteruptAllSpellsMelee.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeftShort",
		SpeedMultiplier = 1.1
	}
}

-- LoganSoldierFlourishResponse --
CombatSequences.LoganSoldierFlourishResponse = {}
CombatSequences.LoganSoldierFlourishResponse.IsValid = Predicate.IsChargingFlourish
CombatSequences.LoganSoldierFlourishResponse.CounterAttack = true
CombatSequences.LoganSoldierFlourishResponse.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierFlourishResponse.Zones = {}
CombatSequences.LoganSoldierFlourishResponse.Zones[CombatZones.Near] = true
CombatSequences.LoganSoldierFlourishResponse.Zones[CombatZones.Middle] = true
CombatSequences.LoganSoldierFlourishResponse.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "FlourishLeftShort",
		SpeedMultiplier = 1.1
	}
}

-- LoganSoldierRearAttack --
CombatSequences.LoganSoldierRearAttack = {}
CombatSequences.LoganSoldierRearAttack.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierRearAttack.Zones = {}
CombatSequences.LoganSoldierRearAttack.Zones[CombatZones.Rear] = true
CombatSequences.LoganSoldierRearAttack.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "RearAttack",
		SpeedMultiplier = 1.1,
		HitOutsideAttackArc = true,
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		PushBackStrike = 2
	}
}

-- LoganSoldierAttackOutOfBlock --
CombatSequences.LoganSoldierAttackOutOfBlock = {}
CombatSequences.LoganSoldierAttackOutOfBlock.IsValid = Predicate.HasBlockedThisManyStrikesInCurrentMode(2)
CombatSequences.LoganSoldierAttackOutOfBlock.CounterAttack = true
CombatSequences.LoganSoldierAttackOutOfBlock.Priority = SequencePriorities.Attack
CombatSequences.LoganSoldierAttackOutOfBlock.OverrideActionPriority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE
CombatSequences.LoganSoldierAttackOutOfBlock.Zones = {}
CombatSequences.LoganSoldierAttackOutOfBlock.Zones[CombatZones.Near] = true
CombatSequences.LoganSoldierAttackOutOfBlock.Zones[CombatZones.Middle] = true
CombatSequences.LoganSoldierAttackOutOfBlock.ZonesWhilePlaying = {}
CombatSequences.LoganSoldierAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Near] = true
CombatSequences.LoganSoldierAttackOutOfBlock.ZonesWhilePlaying[CombatZones.Middle] = true
CombatSequences.LoganSoldierAttackOutOfBlock.Actions = {
	{
		Type = EScriptableAction.MELEE_STRIKE,
		Anim = "Counterattack",
		Priority = EActionPriority.PRIORITY_COMBAT_UNINTERRUPTABLE_STRIKE,
		SpeedMultiplier = 1.2,
		PushBackStrike = 2.5
	}
}


-- uncomment for debug
-- GUI.DisplayMessageBox("LoganSoldierCombatSequences.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end