
-- Bandit Easy --
CombatStyles.BanditEasy = {}
CombatStyles.BanditEasy.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.BanditEasy.CanStrafe = true
CombatStyles.BanditEasy.StrafeActionSpeed = 1
CombatStyles.BanditEasy.EnterRangedStrafeDist = 10
CombatStyles.BanditEasy.CanSheatheWeapon = true
CombatStyles.BanditEasy.Limits = {}
CombatStyles.BanditEasy.Limits[CombatZones.Near] = 1.5
CombatStyles.BanditEasy.Limits[CombatZones.Middle] = 2.5
CombatStyles.BanditEasy.Limits[CombatZones.Far] = 4.5
CombatStyles.BanditEasy.Limits[CombatZones.Left] = 1
CombatStyles.BanditEasy.Limits[CombatZones.Right] = 1
CombatStyles.BanditEasy.Limits[CombatZones.Rear] = 1
CombatStyles.BanditEasy.CanFlee = false
CombatStyles.BanditEasy.FleeAnim = "Flee"
CombatStyles.BanditEasy.FleeIntoAnim = "FleeInto"
CombatStyles.BanditEasy.FleeOutOfAnim = "FleeOutOf"
CombatStyles.BanditEasy.CombatStyleWhenDisarmed = "BasicUnarmedEasy"
CombatStyles.BanditEasy.Sequences = {}
CombatStyles.BanditEasy.Sequences[CombatSituations.Melee] = {
	"BanditEasyOrbSuckingResponse",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
	"BanditEasyFarAttackCombo",
	"BanditEasyCloseAttackCombo",
	"BanditEasyAttackCombo",
    "BanditHeroFlourishResponse"
}
CombatStyles.BanditEasy.Sequences[CombatSituations.Ranged] = {
	"BanditOuterGoad"
}
CombatStyles.BanditEasy.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.BanditEasy.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.BanditEasy.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.BanditEasy.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.BanditEasy.MinSecondsBetweenRangedAttacks = 8
CombatStyles.BanditEasy.CanStandOffAndShoot = "Aggressive"
CombatStyles.BanditEasy.CanBlock = true
CombatStyles.BanditEasy.BlockData = {}
CombatStyles.BanditEasy.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.BanditEasy.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.BanditEasy.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.BanditEasy.BlockData.SecondsToBlockFor = 1
CombatStyles.BanditEasy.OuterRingPercentAsRanged = 0.5
CombatStyles.BanditEasy.ValidStates = {}
CombatStyles.BanditEasy.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BanditEasy.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.BanditEasy.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditEasy.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditEasy.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditEasy.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.BanditEasy.ShootingBalanceData = {}
CombatStyles.BanditEasy.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.BanditEasy.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.2
CombatStyles.BanditEasy.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.BanditEasy.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.BanditEasy.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.03
CombatStyles.BanditEasy.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.04
CombatStyles.BanditEasy.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 24
CombatStyles.BanditEasy.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.BanditEasy.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.BanditEasy.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Crap Bandit --
CombatStyles.CrapBandit = DeepCopyTable(CombatStyles.BanditEasy)
CombatStyles.CrapBandit.CanStrafe = true


-- Bandit --
CombatStyles.Bandit = {}
CombatStyles.Bandit.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.Bandit.CanStrafe = true
CombatStyles.Bandit.DesiredRange = 4
CombatStyles.Bandit.StrafeActionSpeed = 1
CombatStyles.Bandit.EnterRangedStrafeDist = 10
CombatStyles.Bandit.CanSheatheWeapon = true
CombatStyles.Bandit.Limits = {}
CombatStyles.Bandit.Limits[CombatZones.Near] = 1.5
CombatStyles.Bandit.Limits[CombatZones.Middle] = 2.5
CombatStyles.Bandit.Limits[CombatZones.Far] = 4.5
CombatStyles.Bandit.Limits[CombatZones.Left] = 2
CombatStyles.Bandit.Limits[CombatZones.Right] = 2
CombatStyles.Bandit.Limits[CombatZones.Rear] = 3
CombatStyles.Bandit.CanFlee = false
CombatStyles.Bandit.FleeAnim = "Flee"
CombatStyles.Bandit.FleeIntoAnim = "FleeInto"
CombatStyles.Bandit.FleeOutOfAnim = "FleeOutOf"
CombatStyles.Bandit.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.Bandit.Sequences = {}
CombatStyles.Bandit.Sequences[CombatSituations.Melee] = {
	"BanditOrbSuckingResponse",
	"BanditFarAttackCombo",
	"BanditCloseAttackCombo",
	"BanditAttackCombo",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
    "BanditHeroFlourishResponse",
    "BanditLeftAttack",
    "BanditRightAttack",
    "BanditRearAttack"
}
CombatStyles.Bandit.Sequences[CombatSituations.Ranged] = {
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.Bandit.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.Bandit.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.Bandit.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.Bandit.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.Bandit.MinSecondsBetweenRangedAttacks = 7
CombatStyles.Bandit.CanStandOffAndShoot = "Aggressive"
CombatStyles.Bandit.CanBlock = true
CombatStyles.Bandit.BlockData = {}
CombatStyles.Bandit.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.Bandit.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.Bandit.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.Bandit.BlockData.SecondsToBlockFor = 1.3
CombatStyles.Bandit.OuterRingPercentAsRanged = 0.5
CombatStyles.Bandit.AntiSpamData = {}
CombatStyles.Bandit.AntiSpamData.TimeToCheckFor = 4
CombatStyles.Bandit.AntiSpamData.ShotsToTrigger = 4
CombatStyles.Bandit.AntiSpamData.SpellsToTrigger = 4
CombatStyles.Bandit.AntiSpamData.TimeToAggroFor = 8
CombatStyles.Bandit.ValidStates = {}
CombatStyles.Bandit.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.Bandit.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.Bandit.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Bandit.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Bandit.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.Bandit.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.Bandit.ShootingBalanceData = {}
CombatStyles.Bandit.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.Bandit.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.3
CombatStyles.Bandit.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.Bandit.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.Bandit.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.Bandit.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.Bandit.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.Bandit.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.Bandit.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.Bandit.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Turret Bandit --
CombatStyles.TurretBandit = {}
CombatStyles.TurretBandit.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.TurretBandit.CanStrafe = true
CombatStyles.TurretBandit.StrafeActionSpeed = 1
CombatStyles.TurretBandit.EnterRangedStrafeDist = 10
CombatStyles.TurretBandit.MinTimeToReturnToFiringPos = 20
CombatStyles.TurretBandit.CanSheatheWeapon = true
CombatStyles.TurretBandit.TurretBalanceData = {}
CombatStyles.TurretBandit.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.TurretBandit.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.TurretBandit.TurretBalanceData.NonTurretCombatStyle = "Bandit"
CombatStyles.TurretBandit.Limits = {}
CombatStyles.TurretBandit.Limits[CombatZones.Near] = 1.5
CombatStyles.TurretBandit.Limits[CombatZones.Middle] = 2.5
CombatStyles.TurretBandit.Limits[CombatZones.Far] = 5.5
CombatStyles.TurretBandit.Limits[CombatZones.Left] = 2
CombatStyles.TurretBandit.Limits[CombatZones.Right] = 2
CombatStyles.TurretBandit.Limits[CombatZones.Rear] = 3
CombatStyles.TurretBandit.CanFlee = false
CombatStyles.TurretBandit.FleeAnim = "Flee"
CombatStyles.TurretBandit.FleeIntoAnim = "FleeInto"
CombatStyles.TurretBandit.FleeOutOfAnim = "FleeOutOf"
CombatStyles.TurretBandit.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.TurretBandit.Sequences = {}
CombatStyles.TurretBandit.Sequences[CombatSituations.Melee] = {
	"AttackComboLeftRightFastStep",
	"CloseAttackLeftRight",
	"BanditGoadAfterAttack",
	"BanditGoad",
	"BanditOuterGoad",
	"BanditLeftAttack",
	"BanditRightAttack",
    "BanditRearAttack",
    "Idle"
}
CombatStyles.TurretBandit.Sequences[CombatSituations.Ranged] = {
	"Idle",
	"FarIdle"
}
CombatStyles.TurretBandit.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.TurretBandit.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.TurretBandit.SecondsToWaitAfterTargetIsHit = 3
CombatStyles.TurretBandit.MinSecondsBetweenRangedAttacks = 5
CombatStyles.TurretBandit.CanStandOffAndShoot = "Turret"
CombatStyles.TurretBandit.CanBlock = true
CombatStyles.TurretBandit.BlockData = {}
CombatStyles.TurretBandit.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.TurretBandit.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.TurretBandit.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.TurretBandit.BlockData.SecondsToBlockFor = 0.9
CombatStyles.TurretBandit.OuterRingPercentAsRanged = 0.5
CombatStyles.TurretBandit.ValidStates = {}
CombatStyles.TurretBandit.ValidStates[CombatSituations.Ranged] = {
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.TurretBandit.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.TurretBandit.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.TurretBandit.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.TurretBandit.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.TurretBandit.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.TurretBandit.ShootingBalanceData = {}
CombatStyles.TurretBandit.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.TurretBandit.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.3
CombatStyles.TurretBandit.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.TurretBandit.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.TurretBandit.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.TurretBandit.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.TurretBandit.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.TurretBandit.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.TurretBandit.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.TurretBandit.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Turret Bandit NoWait --
CombatStyles.TurretBanditNoWait = DeepCopyTable(CombatStyles.TurretBandit)
CombatStyles.TurretBanditNoWait.MoveToFiringPosNoWait = true


-- Bandit NoRanged --
CombatStyles.BanditNoRanged = DeepCopyTable(CombatStyles.Bandit)
CombatStyles.BanditNoRanged.ForceWeaponType = WeaponTypes.Melee


-- Ranged Bandit --
CombatStyles.RangedBandit = DeepCopyTable(CombatStyles.Bandit)
CombatStyles.RangedBandit.ForceWeaponType = WeaponTypes.Ranged
CombatStyles.RangedBandit.CanStandOffAndShoot = "Defensive"


-- Bandit Defensive --
CombatStyles.BanditDefensive = DeepCopyTable(CombatStyles.Bandit)
CombatStyles.BanditDefensive.ForceWeaponType = WeaponTypes.Ranged
CombatStyles.BanditDefensive.CanStandOffAndShoot = "Defensive"


-- Bandit Elite --
CombatStyles.BanditElite = {}
CombatStyles.BanditElite.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.BanditElite.CanStrafe = true
CombatStyles.BanditElite.StrafeActionSpeed = 1
CombatStyles.BanditElite.EnterRangedStrafeDist = 10
CombatStyles.BanditElite.MinTimeToReturnToFiringPos = 20
CombatStyles.BanditElite.CanSheatheWeapon = true
CombatStyles.BanditElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.BanditElite.TurretBalanceData = {}
CombatStyles.BanditElite.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.BanditElite.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.BanditElite.TurretBalanceData.NonTurretCombatStyle = "BanditElite"
CombatStyles.BanditElite.Limits = {}
CombatStyles.BanditElite.Limits[CombatZones.Near] = 1.5
CombatStyles.BanditElite.Limits[CombatZones.Middle] = 2.5
CombatStyles.BanditElite.Limits[CombatZones.Far] = 5.5
CombatStyles.BanditElite.Limits[CombatZones.Left] = 2
CombatStyles.BanditElite.Limits[CombatZones.Right] = 2
CombatStyles.BanditElite.Limits[CombatZones.Rear] = 3
CombatStyles.BanditElite.CanFlee = false
CombatStyles.BanditElite.FleeAnim = "Flee"
CombatStyles.BanditElite.FleeIntoAnim = "FleeInto"
CombatStyles.BanditElite.FleeOutOfAnim = "FleeOutOf"
CombatStyles.BanditElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.BanditElite.Sequences = {}
CombatStyles.BanditElite.Sequences[CombatSituations.Melee] = {
	"AttackComboLeftRightFastStep",
	"CloseAttackLeftRight",
	"BanditGoadAfterAttack",
	"BanditGoad",
	"BanditOuterGoad",
	"BanditLeftAttack",
	"BanditRightAttack",
    "BanditRearAttack",
    "Idle"
}
CombatStyles.BanditElite.Sequences[CombatSituations.Ranged] = {
	"Idle",
	"FarIdle"
}
CombatStyles.BanditElite.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.BanditElite.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.BanditElite.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.BanditElite.MinSecondsBetweenRangedAttacks = 4
CombatStyles.BanditElite.CanStandOffAndShoot = "Turret"
CombatStyles.BanditElite.CanBlock = true
CombatStyles.BanditElite.BlockData = {}
CombatStyles.BanditElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.BanditElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 5
CombatStyles.BanditElite.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.BanditElite.BlockData.SecondsToBlockFor = 1.4
CombatStyles.BanditElite.OuterRingPercentAsRanged = 0.5
CombatStyles.BanditElite.CanEvadeShots = false
CombatStyles.BanditElite.EvadeShotsData = {}
CombatStyles.BanditElite.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.BanditElite.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.BanditElite.EvadeShotsData.HitsToStartEvading = 4
CombatStyles.BanditElite.EvadeAnimations = {
	"DodgeLeft",
    "DodgeRight"
}
CombatStyles.BanditElite.AntiSpamData = {}
CombatStyles.BanditElite.AntiSpamData.TimeToCheckFor = 4
CombatStyles.BanditElite.AntiSpamData.ShotsToTrigger = 4
CombatStyles.BanditElite.AntiSpamData.SpellsToTrigger = 4
CombatStyles.BanditElite.AntiSpamData.TimeToAggroFor = 8
CombatStyles.BanditElite.ValidStates = {}
CombatStyles.BanditElite.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BanditElite.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BanditElite.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditElite.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditElite.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditElite.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.BanditElite.ShootingBalanceData = {}
CombatStyles.BanditElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.BanditElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.3
CombatStyles.BanditElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.BanditElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.BanditElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.BanditElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.06
CombatStyles.BanditElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.BanditElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.BanditElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.BanditElite.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Bandit Leader --
CombatStyles.BanditLeader = {}
CombatStyles.BanditLeader.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.BanditLeader.CanStrafe = true
CombatStyles.BanditLeader.DesiredRange = 4
CombatStyles.BanditLeader.MovementTolerance = 0.45
CombatStyles.BanditLeader.StrafeActionSpeed = 1
CombatStyles.BanditLeader.PreferOuterRing = true
CombatStyles.BanditLeader.IsLeaderType = true
CombatStyles.BanditLeader.EnterRangedStrafeDist = 10
CombatStyles.BanditLeader.CanSheatheWeapon = true
CombatStyles.BanditLeader.Limits = {}
CombatStyles.BanditLeader.Limits[CombatZones.Near] = 1.5
CombatStyles.BanditLeader.Limits[CombatZones.Middle] = 2.5
CombatStyles.BanditLeader.Limits[CombatZones.Far] = 5
CombatStyles.BanditLeader.Limits[CombatZones.Left] = 2
CombatStyles.BanditLeader.Limits[CombatZones.Right] = 2
CombatStyles.BanditLeader.Limits[CombatZones.Rear] = 3
CombatStyles.BanditLeader.CanFlee = false
CombatStyles.BanditLeader.FleeAnim = "Flee"
CombatStyles.BanditLeader.FleeIntoAnim = "FleeInto"
CombatStyles.BanditLeader.FleeOutOfAnim = "FleeOutOf"
CombatStyles.BanditLeader.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.BanditLeader.Sequences = {}
CombatStyles.BanditLeader.Sequences[CombatSituations.Melee] = {
	"BanditLeaderInteruptSpellMelee",
	"BanditLeaderShotCausedFlourish",
	"BanditLeaderOrbSuckingResponse",
	"BanditGoad",
	"BanditOuterGoad",
	"Idle",
	"BanditLeaderAttackCombo",
	{"BanditLeaderFlourishLeft", 10},
	"BanditLeaderCloseAttackCombo",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.BanditLeader.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.BanditLeader.Sequences[CombatSituations.HardBlocking] = {
	"BanditLeaderAttackOutOfBlock",
	"BanditLeaderAttackOutOfBlockShort"
}
CombatStyles.BanditLeader.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.BanditLeader.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.BanditLeader.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.BanditLeader.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.BanditLeader.MinSecondsBetweenRangedAttacks = 5
CombatStyles.BanditLeader.LaughAtKnockdown = {}
CombatStyles.BanditLeader.LaughAtKnockdown.Anim = "ReactLaugh"
CombatStyles.BanditLeader.LaughAtKnockdown.MinSecondsBetween = 8
CombatStyles.BanditLeader.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.BanditLeader.CanStandOffAndShoot = "Aggressive"
CombatStyles.BanditLeader.CanBlock = true
CombatStyles.BanditLeader.BlockData = {}
CombatStyles.BanditLeader.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.BanditLeader.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.BanditLeader.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.BanditLeader.BlockData.SecondsToBlockFor = 2
CombatStyles.BanditLeader.CanEvadeShots = false
CombatStyles.BanditLeader.EvadeShotsData = {}
CombatStyles.BanditLeader.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.BanditLeader.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.BanditLeader.EvadeShotsData.HitsToStartEvading = 4
CombatStyles.BanditLeader.EvadeAnimations = {
	"DodgeLeft",
    "DodgeRight"
}
CombatStyles.BanditLeader.AntiSpamData = {}
CombatStyles.BanditLeader.AntiSpamData.TimeToCheckFor = 5
CombatStyles.BanditLeader.AntiSpamData.ShotsToTrigger = 3
CombatStyles.BanditLeader.AntiSpamData.SpellsToTrigger = 3
CombatStyles.BanditLeader.AntiSpamData.TimeToAggroFor = 10
CombatStyles.BanditLeader.OuterRingPercentAsRanged = 0.5
CombatStyles.BanditLeader.ValidStates = {}
CombatStyles.BanditLeader.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BanditLeader.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.BanditLeader.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeader.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeader.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeader.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.BanditLeader.ShootingBalanceData = {}
CombatStyles.BanditLeader.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.BanditLeader.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.6
CombatStyles.BanditLeader.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.BanditLeader.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.BanditLeader.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.BanditLeader.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.BanditLeader.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.BanditLeader.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.BanditLeader.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.BanditLeader.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Bandit Leader Elite --
CombatStyles.BanditLeaderElite = {}
CombatStyles.BanditLeaderElite.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.BanditLeaderElite.CanStrafe = true
CombatStyles.BanditLeaderElite.DesiredRange = 4
CombatStyles.BanditLeaderElite.MovementTolerance = 0.45
CombatStyles.BanditLeaderElite.StrafeActionSpeed = 1
CombatStyles.BanditLeaderElite.PreferOuterRing = true
CombatStyles.BanditLeaderElite.IsLeaderType = true
CombatStyles.BanditLeaderElite.CanSheatheWeapon = true
CombatStyles.BanditLeaderElite.EnterRangedStrafeDist = 10
CombatStyles.BanditLeaderElite.Limits = {}
CombatStyles.BanditLeaderElite.Limits[CombatZones.Near] = 1.5
CombatStyles.BanditLeaderElite.Limits[CombatZones.Middle] = 2.5
CombatStyles.BanditLeaderElite.Limits[CombatZones.Far] = 5.5
CombatStyles.BanditLeaderElite.Limits[CombatZones.Left] = 2
CombatStyles.BanditLeaderElite.Limits[CombatZones.Right] = 2
CombatStyles.BanditLeaderElite.Limits[CombatZones.Rear] = 3
CombatStyles.BanditLeaderElite.CanFlee = false
CombatStyles.BanditLeaderElite.FleeAnim = "Flee"
CombatStyles.BanditLeaderElite.FleeIntoAnim = "FleeInto"
CombatStyles.BanditLeaderElite.FleeOutOfAnim = "FleeOutOf"
CombatStyles.BanditLeaderElite.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.BanditLeaderElite.LaughAtKnockdown = {}
CombatStyles.BanditLeaderElite.LaughAtKnockdown.Anim = "ReactLaugh"
CombatStyles.BanditLeaderElite.LaughAtKnockdown.MinSecondsBetween = 8
CombatStyles.BanditLeaderElite.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.BanditLeaderElite.Sequences = {}
CombatStyles.BanditLeaderElite.Sequences[CombatSituations.Melee] = {
	"BanditLeaderInteruptSpellMelee",
	"BanditLeaderHeroFlourishResponse",
	"BanditLeaderGettingShotResponse",
	"BanditLeaderEliteOrbSuckingResponse",
	"BanditOuterGoad",
	"BanditGoadAfterAttack",
	"Idle",
    "BanditLeaderEliteAttackCombo",
	{"BanditLeaderEliteFlourishLeft", 15},
	"BanditLeaderEliteCloseAttackCombo",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.BanditLeaderElite.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.BanditLeaderElite.Sequences[CombatSituations.HardBlocking] = {
	"BanditLeaderEliteAttackOutOfBlockShort",
	"BanditLeaderEliteAttackOutOfBlock"
}
CombatStyles.BanditLeaderElite.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.BanditLeaderElite.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.BanditLeaderElite.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.BanditLeaderElite.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.BanditLeaderElite.MinSecondsBetweenRangedAttacks = 5
CombatStyles.BanditLeaderElite.CanStandOffAndShoot = "Aggressive"
CombatStyles.BanditLeaderElite.CanBlock = true
CombatStyles.BanditLeaderElite.BlockData = {}
CombatStyles.BanditLeaderElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.BanditLeaderElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.BanditLeaderElite.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.BanditLeaderElite.BlockData.SecondsToBlockFor = 2
CombatStyles.BanditLeaderElite.CanEvadeShots = false
CombatStyles.BanditLeaderElite.EvadeShotsData = {}
CombatStyles.BanditLeaderElite.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.BanditLeaderElite.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.BanditLeaderElite.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.BanditLeaderElite.EvadeAnimations = {
	"DodgeLeft",
    "DodgeRight"
}
CombatStyles.BanditLeaderElite.AntiSpamData = {}
CombatStyles.BanditLeaderElite.AntiSpamData.TimeToCheckFor = 5
CombatStyles.BanditLeaderElite.AntiSpamData.ShotsToTrigger = 3
CombatStyles.BanditLeaderElite.AntiSpamData.SpellsToTrigger = 3
CombatStyles.BanditLeaderElite.AntiSpamData.TimeToAggroFor = 10
CombatStyles.BanditLeaderElite.OuterRingPercentAsRanged = 0.5
CombatStyles.BanditLeaderElite.ValidStates = {}
CombatStyles.BanditLeaderElite.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BanditLeaderElite.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.BanditLeaderElite.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeaderElite.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeaderElite.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeaderElite.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.BanditLeaderElite.ShootingBalanceData = {}
CombatStyles.BanditLeaderElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.BanditLeaderElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.7
CombatStyles.BanditLeaderElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.BanditLeaderElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.BanditLeaderElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.BanditLeaderElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.1
CombatStyles.BanditLeaderElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 35
CombatStyles.BanditLeaderElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.6
CombatStyles.BanditLeaderElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.7
CombatStyles.BanditLeaderElite.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Bandit Crucible --
CombatStyles.BanditCrucible = {}
CombatStyles.BanditCrucible.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.BanditCrucible.CanStrafe = true
CombatStyles.BanditCrucible.DesiredRange = 4
CombatStyles.BanditCrucible.StrafeActionSpeed = 1
CombatStyles.BanditCrucible.EnterRangedStrafeDist = 10
CombatStyles.BanditCrucible.CanSheatheWeapon = true
CombatStyles.BanditCrucible.Limits = {}
CombatStyles.BanditCrucible.Limits[CombatZones.Near] = 1.5
CombatStyles.BanditCrucible.Limits[CombatZones.Middle] = 2.5
CombatStyles.BanditCrucible.Limits[CombatZones.Far] = 4.5
CombatStyles.BanditCrucible.Limits[CombatZones.Left] = 2
CombatStyles.BanditCrucible.Limits[CombatZones.Right] = 2
CombatStyles.BanditCrucible.Limits[CombatZones.Rear] = 3
CombatStyles.BanditCrucible.CanFlee = false
CombatStyles.BanditCrucible.FleeAnim = "Flee"
CombatStyles.BanditCrucible.FleeIntoAnim = "FleeInto"
CombatStyles.BanditCrucible.FleeOutOfAnim = "FleeOutOf"
CombatStyles.BanditCrucible.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.BanditCrucible.LaughAtKnockdown = {}
CombatStyles.BanditCrucible.LaughAtKnockdown.Anim = "ReactLaugh"
CombatStyles.BanditCrucible.LaughAtKnockdown.MinSecondsBetween = 8
CombatStyles.BanditCrucible.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.BanditCrucible.Sequences = {}
CombatStyles.BanditCrucible.Sequences[CombatSituations.Melee] = {
	"BanditInteruptSpellMelee",
	"BanditEliteOrbSuckingResponse",
	"BanditOuterGoad",
	"Idle",
	"BanditEliteFarAttackCombo",
	"BanditEliteCloseAttackCombo",
	"BanditEliteAttackCombo",
    "BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.BanditCrucible.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.BanditCrucible.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.BanditCrucible.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.BanditCrucible.MinSecondsBetweenMeleeAttacks = 0
CombatStyles.BanditCrucible.SecondsToWaitAfterTargetIsHit = 0
CombatStyles.BanditCrucible.MinSecondsBetweenRangedAttacks = 4
CombatStyles.BanditCrucible.CanStandOffAndShoot = "Aggressive"
CombatStyles.BanditCrucible.CanBlock = true
CombatStyles.BanditCrucible.BlockData = {}
CombatStyles.BanditCrucible.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.BanditCrucible.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.BanditCrucible.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.BanditCrucible.BlockData.SecondaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.BanditCrucible.BlockData.SecondsForSuccessiveHitsToSecondaryBlock = 8
CombatStyles.BanditCrucible.BlockData.NumberOfHitsToForceSecondaryBlock = 2
CombatStyles.BanditCrucible.BlockData.SecondsToBlockFor = 2.5
CombatStyles.BanditCrucible.CanEvadeShots = false
CombatStyles.BanditCrucible.EvadeShotsData = {}
CombatStyles.BanditCrucible.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.BanditCrucible.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.BanditCrucible.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.BanditCrucible.EvadeAnimations = {
	"DodgeLeft",
    "DodgeRight"
}
CombatStyles.BanditCrucible.AntiSpamData = {}
CombatStyles.BanditCrucible.AntiSpamData.TimeToCheckFor = 5
CombatStyles.BanditCrucible.AntiSpamData.ShotsToTrigger = 4
CombatStyles.BanditCrucible.AntiSpamData.SpellsToTrigger = 4
CombatStyles.BanditCrucible.AntiSpamData.TimeToAggroFor = 10
CombatStyles.BanditCrucible.OuterRingPercentAsRanged = 0.5
CombatStyles.BanditCrucible.ValidStates = {}
CombatStyles.BanditCrucible.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BanditCrucible.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"RetreatFromFlourish",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.BanditCrucible.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditCrucible.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditCrucible.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditCrucible.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.BanditCrucible.ShootingBalanceData = {}
CombatStyles.BanditCrucible.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.BanditCrucible.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.7
CombatStyles.BanditCrucible.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.BanditCrucible.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.BanditCrucible.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.BanditCrucible.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.08
CombatStyles.BanditCrucible.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 21
CombatStyles.BanditCrucible.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.BanditCrucible.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.BanditCrucible.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Bandit Crucible Turret --
CombatStyles.BanditCrucibleTurret = DeepCopyTable(CombatStyles.TurretBandit)


-- Bandit Leader Crucible --
CombatStyles.BanditLeaderCrucible = {}
CombatStyles.BanditLeaderCrucible.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.BanditLeaderCrucible.CanStrafe = true
CombatStyles.BanditLeaderCrucible.DesiredRange = 4
CombatStyles.BanditLeaderCrucible.MovementTolerance = 0.45
CombatStyles.BanditLeaderCrucible.StrafeActionSpeed = 1
CombatStyles.BanditLeaderCrucible.PreferOuterRing = true
CombatStyles.BanditLeaderCrucible.IsLeaderType = true
CombatStyles.BanditLeaderCrucible.CanSheatheWeapon = true
CombatStyles.BanditLeaderCrucible.EnterRangedStrafeDist = 10
CombatStyles.BanditLeaderCrucible.Limits = {}
CombatStyles.BanditLeaderCrucible.Limits[CombatZones.Near] = 1.5
CombatStyles.BanditLeaderCrucible.Limits[CombatZones.Middle] = 2.5
CombatStyles.BanditLeaderCrucible.Limits[CombatZones.Far] = 5.5
CombatStyles.BanditLeaderCrucible.Limits[CombatZones.Left] = 2
CombatStyles.BanditLeaderCrucible.Limits[CombatZones.Right] = 2
CombatStyles.BanditLeaderCrucible.Limits[CombatZones.Rear] = 3
CombatStyles.BanditLeaderCrucible.CanFlee = false
CombatStyles.BanditLeaderCrucible.FleeAnim = "Flee"
CombatStyles.BanditLeaderCrucible.FleeIntoAnim = "FleeInto"
CombatStyles.BanditLeaderCrucible.FleeOutOfAnim = "FleeOutOf"
CombatStyles.BanditLeaderCrucible.CombatStyleWhenDisarmed = "BasicUnarmed"
CombatStyles.BanditLeaderCrucible.LaughAtKnockdown = {}
CombatStyles.BanditLeaderCrucible.LaughAtKnockdown.Anim = "ReactLaugh"
CombatStyles.BanditLeaderCrucible.LaughAtKnockdown.MinSecondsBetween = 8
CombatStyles.BanditLeaderCrucible.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.BanditLeaderCrucible.Sequences = {}
CombatStyles.BanditLeaderCrucible.Sequences[CombatSituations.Melee] = {
	"BanditLeaderInteruptSpellMelee",
	"BanditLeaderHeroFlourishResponse",
	"BanditLeaderGettingShotResponse",
	"BanditLeaderEliteOrbSuckingResponse",
	"BanditOuterGoad",
	"BanditGoadAfterAttack",
	"Idle",
    "BanditLeaderEliteAttackCombo",
	{"BanditLeaderEliteFlourishLeft", 15},
	"BanditLeaderEliteCloseAttackCombo",
	"BanditLeftAttack",
	"BanditRightAttack",
	"BanditRearAttack"
}
CombatStyles.BanditLeaderCrucible.Sequences[CombatSituations.Ranged] = {
	"BanditLeaderInteruptSpellRanged",
	"BanditOuterGoad",
	"RangedIdle"
}
CombatStyles.BanditLeaderCrucible.Sequences[CombatSituations.HardBlocking] = {
	"BanditLeaderEliteAttackOutOfBlockShort",
	"BanditLeaderEliteAttackOutOfBlock"
}
CombatStyles.BanditLeaderCrucible.Sequences[CombatSituations.GroupOrders] = {
	"BanditGroupRifleShooting",
	"BanditGroupMeleeAttack",
	"BanditGoad",
	"BanditOuterGoad"
}
CombatStyles.BanditLeaderCrucible.FastWeaponChanges = {
	"SheatheOneHandedWeaponThenUnsheatheRifle",
	"SheatheRifleThenUnsheatheOneHandedWeapon"
}
CombatStyles.BanditLeaderCrucible.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.BanditLeaderCrucible.SecondsToWaitAfterTargetIsHit = 2
CombatStyles.BanditLeaderCrucible.MinSecondsBetweenRangedAttacks = 5
CombatStyles.BanditLeaderCrucible.CanStandOffAndShoot = "Aggressive"
CombatStyles.BanditLeaderCrucible.CanBlock = true
CombatStyles.BanditLeaderCrucible.BlockData = {}
CombatStyles.BanditLeaderCrucible.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.BanditLeaderCrucible.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.BanditLeaderCrucible.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.BanditLeaderCrucible.BlockData.SecondsToBlockFor = 2
CombatStyles.BanditLeaderCrucible.CanEvadeShots = false
CombatStyles.BanditLeaderCrucible.EvadeShotsData = {}
CombatStyles.BanditLeaderCrucible.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.BanditLeaderCrucible.EvadeShotsData.TimeToEvadeFor = 4
CombatStyles.BanditLeaderCrucible.EvadeShotsData.HitsToStartEvading = 3
CombatStyles.BanditLeaderCrucible.EvadeAnimations = {
	"DodgeLeft",
    "DodgeRight"
}
CombatStyles.BanditLeaderCrucible.AntiSpamData = {}
CombatStyles.BanditLeaderCrucible.AntiSpamData.TimeToCheckFor = 5
CombatStyles.BanditLeaderCrucible.AntiSpamData.ShotsToTrigger = 3
CombatStyles.BanditLeaderCrucible.AntiSpamData.SpellsToTrigger = 3
CombatStyles.BanditLeaderCrucible.AntiSpamData.TimeToAggroFor = 10
CombatStyles.BanditLeaderCrucible.OuterRingPercentAsRanged = 0.5
CombatStyles.BanditLeaderCrucible.ValidStates = {}
CombatStyles.BanditLeaderCrucible.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.BanditLeaderCrucible.ValidStates[CombatSituations.Ranged] = {
	"AntiSpamCheck",
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"GetTargetInSights",
	"FireRangedWeapon",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.BanditLeaderCrucible.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeaderCrucible.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeaderCrucible.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.BanditLeaderCrucible.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.BanditLeaderCrucible.ShootingBalanceData = {}
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.7
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.05
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.1
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 35
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.6
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.7
CombatStyles.BanditLeaderCrucible.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Basic Unarmed --
CombatStyles.BasicUnarmed = {}
CombatStyles.BasicUnarmed.CombatGroupType = CombatGroupTypes.BanditLike
CombatStyles.BasicUnarmed.CanFightUnarmed = true
CombatStyles.BasicUnarmed.CanStrafe = true
CombatStyles.BasicUnarmed.EnterStrafeDist = 20
CombatStyles.BasicUnarmed.StrafeCone = 0
CombatStyles.BasicUnarmed.CanSheatheWeapon = false
CombatStyles.BasicUnarmed.NonFormation = true
CombatStyles.BasicUnarmed.TurnToFaceTolerance = 30
CombatStyles.BasicUnarmed.PreferredRange = 1.5
CombatStyles.BasicUnarmed.CanFlee = false
CombatStyles.BasicUnarmed.FleeAnim = "Flee"
CombatStyles.BasicUnarmed.FleeIntoAnim = "FleeInto"
CombatStyles.BasicUnarmed.FleeOutOfAnim = "FleeOutOf"
CombatStyles.BasicUnarmed.Limits = {}
CombatStyles.BasicUnarmed.Limits[CombatZones.Near] = 1.3
CombatStyles.BasicUnarmed.Limits[CombatZones.Middle] = 2.2
CombatStyles.BasicUnarmed.Limits[CombatZones.Far] = 5
CombatStyles.BasicUnarmed.Limits[CombatZones.Left] = 1.5
CombatStyles.BasicUnarmed.Limits[CombatZones.Right] = 1.5
CombatStyles.BasicUnarmed.Limits[CombatZones.Rear] = 2
CombatStyles.BasicUnarmed.MinSecondsBetweenMeleeAttacks = 0.5
CombatStyles.BasicUnarmed.SecondsToWaitAfterTargetIsHit = 1
CombatStyles.BasicUnarmed.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.BasicUnarmed.CanBlock = true
CombatStyles.BasicUnarmed.BlockData = {}
CombatStyles.BasicUnarmed.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_PUSHED_BACK
CombatStyles.BasicUnarmed.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.BasicUnarmed.BlockData.NumberOfHitsToForcePrimaryBlock = 3
CombatStyles.BasicUnarmed.BlockData.SecondsToBlockFor = 1
CombatStyles.BasicUnarmed.OuterRingPercentAsRanged = 0.5
CombatStyles.BasicUnarmed.Sequences = {}
CombatStyles.BasicUnarmed.Sequences[CombatSituations.Melee] = {
	"AttackComboLeftRight",
	"CloseAttack",
	"Idle",
	"IdleLong",
	"Advance",
	"BackOff",
	"UnarmedLeftAttack",
    "UnarmedRightAttack",
	"UnarmedRearAttack"
}
CombatStyles.BasicUnarmed.ValidStates = {}
CombatStyles.BasicUnarmed.ValidStates[CombatSituations.Melee] = {
	"WaitForActionToFinish",
	"CheckForBetterTarget",
	"OuterRingKeepDistanceSimple",
	"PlayBanterCombatComment",
	"NonFormationSpreadOut",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}


-- Basic Unarmed Easy --
CombatStyles.BasicUnarmedEasy = DeepCopyTable(CombatStyles.BasicUnarmed)
CombatStyles.BasicUnarmedEasy.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.BasicUnarmedEasy.SecondsToWaitAfterTargetIsHit = 5



-- uncomment for debug
-- GUI.DisplayMessageBox("banditcombatstyles.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end

