
-- Hobbe --
CombatStyles.Hobbe = {}
CombatStyles.Hobbe.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.Hobbe.CanStrafe = true
CombatStyles.Hobbe.EnterStrafeDist = 3
CombatStyles.Hobbe.DisableAimMode = true
CombatStyles.Hobbe.ActionModifiers = {}
CombatStyles.Hobbe.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.Hobbe.CanSheatheWeapon = true
CombatStyles.Hobbe.Limits = {}
CombatStyles.Hobbe.Limits[CombatZones.Near] = 1.5
CombatStyles.Hobbe.Limits[CombatZones.Middle] = 2.5
CombatStyles.Hobbe.Limits[CombatZones.Far] = 4.5
CombatStyles.Hobbe.Limits[CombatZones.Left] = 2
CombatStyles.Hobbe.Limits[CombatZones.Right] = 2
CombatStyles.Hobbe.Limits[CombatZones.Rear] = 2.5
CombatStyles.Hobbe.DoSpotTargetAnim = true
CombatStyles.Hobbe.CanFlee = true
CombatStyles.Hobbe.FleeAnim = "Flee"
CombatStyles.Hobbe.FleeIntoAnim = "FleeInto"
CombatStyles.Hobbe.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.Hobbe.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.Hobbe.SecondsToWaitAfterTargetIsHit = 1.5
CombatStyles.Hobbe.MinSecondsBetweenRangedAttacks = 4
CombatStyles.Hobbe.Enrage = {}
CombatStyles.Hobbe.Enrage.Anim = "CombatRoar"
CombatStyles.Hobbe.Enrage.DamageMultiplier = 1.1
CombatStyles.Hobbe.Enrage.SpeedMultiplier = 1.1
CombatStyles.Hobbe.Enrage.Duration = 5
CombatStyles.Hobbe.Sequences = {}
CombatStyles.Hobbe.Sequences[CombatSituations.Melee] = {
	"HobbeHeroFlourishResponse",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack",
	"HobbeAttackCombo",
	"HobbeCloseAttackCombo",
	"HobbeFarAttackCombo",
	"Idle",
	"IdleStrafe",
	"BackOff"
}
CombatStyles.Hobbe.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.Hobbe.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.Hobbe.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Easy --
CombatStyles.HobbeEasy = {}
CombatStyles.HobbeEasy.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeEasy.CanStrafe = true
CombatStyles.HobbeEasy.EnterStrafeDist = 2
CombatStyles.HobbeEasy.DisableAimMode = true
CombatStyles.HobbeEasy.ActionModifiers = {}
CombatStyles.HobbeEasy.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeEasy.CanSheatheWeapon = true
CombatStyles.HobbeEasy.Limits = {}
CombatStyles.HobbeEasy.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeEasy.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeEasy.Limits[CombatZones.Far] = 4.5
CombatStyles.HobbeEasy.Limits[CombatZones.Left] = 2
CombatStyles.HobbeEasy.Limits[CombatZones.Right] = 2
CombatStyles.HobbeEasy.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeEasy.DoSpotTargetAnim = true
CombatStyles.HobbeEasy.CanFlee = true
CombatStyles.HobbeEasy.FleeAnim = "Flee"
CombatStyles.HobbeEasy.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeEasy.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeEasy.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.HobbeEasy.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeEasy.Enrage = {}
CombatStyles.HobbeEasy.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeEasy.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeEasy.Enrage.SpeedMultiplier = 1.1
CombatStyles.HobbeEasy.Enrage.Duration = 5
CombatStyles.HobbeEasy.Sequences = {}
CombatStyles.HobbeEasy.Sequences[CombatSituations.Melee] = {
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack",
	"HobbeAttackCombo",
	"HobbeCloseAttackCombo",
	"HobbeFarAttackCombo",
	"Idle",
	"IdleStrafe",
	"IdleLong",
	"Advance",
	"BackOff"
}
CombatStyles.HobbeEasy.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeEasy.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeEasy.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Sniper --
CombatStyles.HobbeSniper = DeepCopyTable(CombatStyles.Hobbe)
CombatStyles.HobbeSniper.ForceWeaponType = WeaponTypes.Ranged
CombatStyles.HobbeSniper.ShootingBalanceData = {}
CombatStyles.HobbeSniper.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.HobbeSniper.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.05
CombatStyles.HobbeSniper.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 1
CombatStyles.HobbeSniper.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.HobbeSniper.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.HobbeSniper.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.HobbeSniper.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 20
CombatStyles.HobbeSniper.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.5
CombatStyles.HobbeSniper.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.HobbeSniper.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Hobbe Elite WithDodgeBlock--
CombatStyles.HobbeElite = {}
CombatStyles.HobbeElite.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeElite.CanStrafe = true
CombatStyles.HobbeElite.CanSheatheWeapon = true
CombatStyles.HobbeElite.EnterStrafeDist = 3
CombatStyles.HobbeElite.DisableAimMode = true
CombatStyles.HobbeElite.ActionModifiers = {}
CombatStyles.HobbeElite.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeElite.Limits = {}
CombatStyles.HobbeElite.Limits[CombatZones.Near] = 2
CombatStyles.HobbeElite.Limits[CombatZones.Middle] = 4
CombatStyles.HobbeElite.Limits[CombatZones.Far] = 5.5
CombatStyles.HobbeElite.Limits[CombatZones.Left] = 2
CombatStyles.HobbeElite.Limits[CombatZones.Right] = 2
CombatStyles.HobbeElite.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeElite.DoSpotTargetAnim = true
CombatStyles.HobbeElite.CanFlee = false
CombatStyles.HobbeElite.FleeAnim = "Flee"
CombatStyles.HobbeElite.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeElite.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeElite.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.HobbeElite.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.HobbeElite.MinSecondsBetweenRangedAttacks = 4
CombatStyles.HobbeElite.LaughAtKnockdown = {}
CombatStyles.HobbeElite.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeElite.LaughAtKnockdown.MinSecondsBetween = 5
CombatStyles.HobbeElite.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeElite.Enrage = {}
CombatStyles.HobbeElite.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeElite.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeElite.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeElite.Enrage.Duration = 5
CombatStyles.HobbeElite.Sequences = {}
CombatStyles.HobbeElite.Sequences[CombatSituations.Melee] = {
	"HobbeEliteOrbSuckingResponse",
	"HobbeEliteAttackCombo",
	"HobbeEliteCloseAttackCombo",
	"HobbeEliteFarAttackCombo",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeElite.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeElite.Sequences[CombatSituations.Dodging] = {
	"HobbeEliteBerserk"
}
CombatStyles.HobbeElite.CanBlock = true
CombatStyles.HobbeElite.BlockData = {}
CombatStyles.HobbeElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeElite.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeElite.BlockData.MaxHitsToBlock = 3
CombatStyles.HobbeElite.BlockData.SecondsToBlockFor = 1.6
CombatStyles.HobbeElite.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeElite.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeElite.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Elite WithHardBlock --
CombatStyles.HobbeEliteWithHardBlock = {}
CombatStyles.HobbeEliteWithHardBlock.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeEliteWithHardBlock.CanStrafe = true
CombatStyles.HobbeEliteWithHardBlock.CanSheatheWeapon = true
CombatStyles.HobbeEliteWithHardBlock.EnterStrafeDist = 3
CombatStyles.HobbeEliteWithHardBlock.DisableAimMode = true
CombatStyles.HobbeEliteWithHardBlock.ActionModifiers = {}
CombatStyles.HobbeEliteWithHardBlock.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeEliteWithHardBlock.Limits = {}
CombatStyles.HobbeEliteWithHardBlock.Limits[CombatZones.Near] = 2
CombatStyles.HobbeEliteWithHardBlock.Limits[CombatZones.Middle] = 4
CombatStyles.HobbeEliteWithHardBlock.Limits[CombatZones.Far] = 5.5
CombatStyles.HobbeEliteWithHardBlock.Limits[CombatZones.Left] = 2
CombatStyles.HobbeEliteWithHardBlock.Limits[CombatZones.Right] = 2
CombatStyles.HobbeEliteWithHardBlock.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeEliteWithHardBlock.DoSpotTargetAnim = true
CombatStyles.HobbeEliteWithHardBlock.CanFlee = false
CombatStyles.HobbeEliteWithHardBlock.FleeAnim = "Flee"
CombatStyles.HobbeEliteWithHardBlock.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeEliteWithHardBlock.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeEliteWithHardBlock.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.HobbeEliteWithHardBlock.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.HobbeEliteWithHardBlock.MinSecondsBetweenRangedAttacks = 4
CombatStyles.HobbeEliteWithHardBlock.LaughAtKnockdown = {}
CombatStyles.HobbeEliteWithHardBlock.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeEliteWithHardBlock.LaughAtKnockdown.MinSecondsBetween = 5
CombatStyles.HobbeEliteWithHardBlock.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeEliteWithHardBlock.Enrage = {}
CombatStyles.HobbeEliteWithHardBlock.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeEliteWithHardBlock.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeEliteWithHardBlock.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeEliteWithHardBlock.Enrage.Duration = 5
CombatStyles.HobbeEliteWithHardBlock.Sequences = {}
CombatStyles.HobbeEliteWithHardBlock.Sequences[CombatSituations.Melee] = {
	"HobbeEliteOrbSuckingResponse",
	"HobbeEliteAttackCombo",
	"HobbeEliteCloseAttackCombo",
	"HobbeEliteFarAttackCombo",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeEliteWithHardBlock.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeEliteWithHardBlock.Sequences[CombatSituations.HardBlocking] = {
	"HobbeEliteBerserk"
}
CombatStyles.HobbeEliteWithHardBlock.CanBlock = true
CombatStyles.HobbeEliteWithHardBlock.BlockData = {}
CombatStyles.HobbeEliteWithHardBlock.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.HobbeEliteWithHardBlock.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 4
CombatStyles.HobbeEliteWithHardBlock.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeEliteWithHardBlock.BlockData.SecondsToBlockFor = 1.6
CombatStyles.HobbeEliteWithHardBlock.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeEliteWithHardBlock.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Sniper Elite --
CombatStyles.HobbeSniperElite = {}
CombatStyles.HobbeSniperElite.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeSniperElite.CanStrafe = true
CombatStyles.HobbeSniperElite.CanSheatheWeapon = true
CombatStyles.HobbeSniperElite.EnterStrafeDist = 3
CombatStyles.HobbeSniperElite.DisableAimMode = true
CombatStyles.HobbeSniperElite.ForceWeaponType = WeaponTypes.Ranged
CombatStyles.HobbeSniperElite.ActionModifiers = {}
CombatStyles.HobbeSniperElite.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeSniperElite.Limits = {}
CombatStyles.HobbeSniperElite.Limits[CombatZones.Near] = 2
CombatStyles.HobbeSniperElite.Limits[CombatZones.Middle] = 4
CombatStyles.HobbeSniperElite.Limits[CombatZones.Far] = 5.5
CombatStyles.HobbeSniperElite.Limits[CombatZones.Left] = 2
CombatStyles.HobbeSniperElite.Limits[CombatZones.Right] = 2
CombatStyles.HobbeSniperElite.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeSniperElite.DoSpotTargetAnim = true
CombatStyles.HobbeSniperElite.CanFlee = false
CombatStyles.HobbeSniperElite.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.HobbeSniperElite.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.HobbeSniperElite.MinSecondsBetweenRangedAttacks = 4
CombatStyles.HobbeSniperElite.LaughAtKnockdown = {}
CombatStyles.HobbeSniperElite.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeSniperElite.LaughAtKnockdown.MinSecondsBetween = 5
CombatStyles.HobbeSniperElite.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeSniperElite.Enrage = {}
CombatStyles.HobbeSniperElite.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeSniperElite.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeSniperElite.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeSniperElite.Enrage.Duration = 5
CombatStyles.HobbeSniperElite.Sequences = {}
CombatStyles.HobbeSniperElite.Sequences[CombatSituations.Melee] = {
	"HobbeEliteOrbSuckingResponse",
	"HobbeEliteAttackCombo",
	"HobbeEliteCloseAttackCombo",
	"HobbeEliteFarAttackCombo",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeSniperElite.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeSniperElite.Sequences[CombatSituations.Dodging] = {
	"HobbeEliteBerserk"
}
CombatStyles.HobbeSniperElite.CanBlock = true
CombatStyles.HobbeSniperElite.BlockData = {}
CombatStyles.HobbeSniperElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeSniperElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeSniperElite.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeSniperElite.BlockData.MaxHitsToBlock = 3
CombatStyles.HobbeSniperElite.BlockData.SecondsToBlockFor = 1
CombatStyles.HobbeSniperElite.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeSniperElite.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeSniperElite.ShootingBalanceData = {}
CombatStyles.HobbeSniperElite.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.HobbeSniperElite.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.05
CombatStyles.HobbeSniperElite.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 1
CombatStyles.HobbeSniperElite.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.HobbeSniperElite.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.01
CombatStyles.HobbeSniperElite.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.01
CombatStyles.HobbeSniperElite.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 20
CombatStyles.HobbeSniperElite.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.5
CombatStyles.HobbeSniperElite.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.HobbeSniperElite.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Hobbe Ambusher Elite --
CombatStyles.HobbeAmbusherElite = {}
CombatStyles.HobbeAmbusherElite.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeAmbusherElite.CanStrafe = true
CombatStyles.HobbeAmbusherElite.CanSheatheWeapon = true
CombatStyles.HobbeAmbusherElite.EnterStrafeDist = 3
CombatStyles.HobbeAmbusherElite.DisableAimMode = true
CombatStyles.HobbeAmbusherElite.ActionModifiers = {}
CombatStyles.HobbeAmbusherElite.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeAmbusherElite.Limits = {}
CombatStyles.HobbeAmbusherElite.Limits[CombatZones.Near] = 2
CombatStyles.HobbeAmbusherElite.Limits[CombatZones.Middle] = 4
CombatStyles.HobbeAmbusherElite.Limits[CombatZones.Far] = 5.5
CombatStyles.HobbeAmbusherElite.Limits[CombatZones.Left] = 2
CombatStyles.HobbeAmbusherElite.Limits[CombatZones.Right] = 2
CombatStyles.HobbeAmbusherElite.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeAmbusherElite.DoSpotTargetAnim = true
CombatStyles.HobbeAmbusherElite.CanFlee = false
CombatStyles.HobbeAmbusherElite.FleeAnim = "Flee"
CombatStyles.HobbeAmbusherElite.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeAmbusherElite.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeAmbusherElite.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.HobbeAmbusherElite.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.HobbeAmbusherElite.MinSecondsBetweenRangedAttacks = 4
CombatStyles.HobbeAmbusherElite.LaughAtKnockdown = {}
CombatStyles.HobbeAmbusherElite.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeAmbusherElite.LaughAtKnockdown.MinSecondsBetween = 5
CombatStyles.HobbeAmbusherElite.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeAmbusherElite.Enrage = {}
CombatStyles.HobbeAmbusherElite.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeAmbusherElite.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeAmbusherElite.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeAmbusherElite.Enrage.Duration = 5
CombatStyles.HobbeAmbusherElite.Sequences = {}
CombatStyles.HobbeAmbusherElite.Sequences[CombatSituations.Melee] = {
	"HobbeEliteOrbSuckingResponse",
	"HobbeEliteAttackCombo",
	"HobbeEliteCloseAttackCombo",
	"HobbeEliteFarAttackCombo",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeAmbusherElite.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeAmbusherElite.Sequences[CombatSituations.Dodging] = {
	"HobbeEliteBerserk"
}
CombatStyles.HobbeAmbusherElite.CanBlock = true
CombatStyles.HobbeAmbusherElite.BlockData = {}
CombatStyles.HobbeAmbusherElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeAmbusherElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeAmbusherElite.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeAmbusherElite.BlockData.MaxHitsToBlock = 2
CombatStyles.HobbeAmbusherElite.BlockData.SecondsToBlockFor = 1
CombatStyles.HobbeAmbusherElite.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeAmbusherElite.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeAmbusherElite.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Crucible --
CombatStyles.HobbeCrucible = {}
CombatStyles.HobbeCrucible.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeCrucible.CanStrafe = true
CombatStyles.HobbeCrucible.CanSheatheWeapon = true
CombatStyles.HobbeCrucible.EnterStrafeDist = 3
CombatStyles.HobbeCrucible.DisableAimMode = true
CombatStyles.HobbeCrucible.ActionModifiers = {}
CombatStyles.HobbeCrucible.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeCrucible.Limits = {}
CombatStyles.HobbeCrucible.Limits[CombatZones.Near] = 1.3
CombatStyles.HobbeCrucible.Limits[CombatZones.Middle] = 2
CombatStyles.HobbeCrucible.Limits[CombatZones.Far] = 4
CombatStyles.HobbeCrucible.Limits[CombatZones.Left] = 2
CombatStyles.HobbeCrucible.Limits[CombatZones.Right] = 2
CombatStyles.HobbeCrucible.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeCrucible.DoSpotTargetAnim = true
CombatStyles.HobbeCrucible.KillWhenDisarmed = true
CombatStyles.HobbeCrucible.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeCrucible.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.HobbeCrucible.MinSecondsBetweenRangedAttacks = 3
CombatStyles.HobbeCrucible.LaughAtKnockdown = {}
CombatStyles.HobbeCrucible.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeCrucible.LaughAtKnockdown.MinSecondsBetween = 5
CombatStyles.HobbeCrucible.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeCrucible.Enrage = {}
CombatStyles.HobbeCrucible.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeCrucible.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeCrucible.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeCrucible.Enrage.Duration = 5
CombatStyles.HobbeCrucible.Sequences = {}
CombatStyles.HobbeCrucible.Sequences[CombatSituations.Melee] = {
	"HobbeEliteOrbSuckingResponse",
	"HobbeEliteAttackCombo",
	"HobbeEliteCloseAttackCombo",
	"HobbeEliteFarAttackCombo",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeCrucible.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeCrucible.Sequences[CombatSituations.Dodging] = {
	"HobbeEliteBerserk"
}
CombatStyles.HobbeCrucible.CanBlock = true
CombatStyles.HobbeCrucible.BlockData = {}
CombatStyles.HobbeCrucible.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeCrucible.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeCrucible.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeCrucible.BlockData.SecondsToBlockFor = 2
CombatStyles.HobbeCrucible.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeCrucible.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeCrucible.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Leader --
CombatStyles.HobbeLeader = {}
CombatStyles.HobbeLeader.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeLeader.CanStrafe = true
CombatStyles.HobbeLeader.CanSheatheWeapon = true
CombatStyles.HobbeLeader.PreferOuterRing = true
CombatStyles.HobbeLeader.IsLeaderType = true
CombatStyles.HobbeLeader.EnterStrafeDist = 7.5
CombatStyles.HobbeLeader.DisableAimMode = true
CombatStyles.HobbeLeader.ActionModifiers = {}
CombatStyles.HobbeLeader.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeLeader.Limits = {}
CombatStyles.HobbeLeader.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeLeader.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeLeader.Limits[CombatZones.Far] = 4.5
CombatStyles.HobbeLeader.Limits[CombatZones.Left] = 2
CombatStyles.HobbeLeader.Limits[CombatZones.Right] = 2
CombatStyles.HobbeLeader.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeLeader.DoSpotTargetAnim = true
CombatStyles.HobbeLeader.CanFlee = true
CombatStyles.HobbeLeader.FleeAnim = "Flee"
CombatStyles.HobbeLeader.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeLeader.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeLeader.MinSecondsBetweenMeleeAttacks = 2.5
CombatStyles.HobbeLeader.MinSecondsBetweenRangedAttacks = 4
CombatStyles.HobbeLeader.LaughAtKnockdown = {}
CombatStyles.HobbeLeader.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeLeader.LaughAtKnockdown.MinSecondsBetween = 10
CombatStyles.HobbeLeader.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeLeader.Enrage = {}
CombatStyles.HobbeLeader.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeLeader.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeLeader.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeLeader.Enrage.Duration = 5
CombatStyles.HobbeLeader.Sequences = {}
CombatStyles.HobbeLeader.Sequences[CombatSituations.Melee] = {
	{"HobbeLeaderFlourishLeft", 20},
	"HobbeLeaderOrbSuckingResponse",
	"HobbeLeaderCloseAttackCombo",
	"HobbeLeaderFarAttackCombo",
	"HobbeLeaderAttackCombo",
	"Idle",
	"IdleStrafe",
	"Advance",
	"BackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeLeader.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeLeader.Sequences[CombatSituations.Dodging] = {
	"HobbeLeaderBlockBreaker"
}
CombatStyles.HobbeLeader.CanBlock = true
CombatStyles.HobbeLeader.BlockData = {}
CombatStyles.HobbeLeader.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeLeader.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeLeader.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeLeader.BlockData.SecondsToBlockFor = 1
CombatStyles.HobbeLeader.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeLeader.DoRunIntoStrafe = true
CombatStyles.HobbeLeader.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeLeader.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Elite Leader --
CombatStyles.HobbeEliteLeader = {}
CombatStyles.HobbeEliteLeader.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeEliteLeader.CanStrafe = true
CombatStyles.HobbeEliteLeader.CanSheatheWeapon = true
CombatStyles.HobbeEliteLeader.PreferOuterRing = true
CombatStyles.HobbeEliteLeader.IsLeaderType = true
CombatStyles.HobbeEliteLeader.EnterStrafeDist = 7.5
CombatStyles.HobbeEliteLeader.DisableAimMode = true
CombatStyles.HobbeEliteLeader.ActionModifiers = {}
CombatStyles.HobbeEliteLeader.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeEliteLeader.Limits = {}
CombatStyles.HobbeEliteLeader.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeEliteLeader.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeEliteLeader.Limits[CombatZones.Far] = 4.5
CombatStyles.HobbeEliteLeader.Limits[CombatZones.Left] = 2
CombatStyles.HobbeEliteLeader.Limits[CombatZones.Right] = 2
CombatStyles.HobbeEliteLeader.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeEliteLeader.DoSpotTargetAnim = true
CombatStyles.HobbeEliteLeader.CanFlee = true
CombatStyles.HobbeEliteLeader.FleeAnim = "Flee"
CombatStyles.HobbeEliteLeader.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeEliteLeader.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeEliteLeader.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.HobbeEliteLeader.MinSecondsBetweenRangedAttacks = 3
CombatStyles.HobbeEliteLeader.LaughAtKnockdown = {}
CombatStyles.HobbeEliteLeader.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeEliteLeader.LaughAtKnockdown.MinSecondsBetween = 10
CombatStyles.HobbeEliteLeader.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeEliteLeader.Enrage = {}
CombatStyles.HobbeEliteLeader.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeEliteLeader.Enrage.DamageMultiplier = 1.2
CombatStyles.HobbeEliteLeader.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeEliteLeader.Enrage.Duration = 7
CombatStyles.HobbeEliteLeader.Sequences = {}
CombatStyles.HobbeEliteLeader.Sequences[CombatSituations.Melee] = {
	{"HobbeLeaderEliteFlourishLeft", 20},
	"HobbeLeaderEliteOrbSuckingResponse",
	"HobbeLeaderEliteCloseAttackCombo",
	"HobbeLeaderEliteFarAttackCombo",
	"HobbeLeaderEliteAttackCombo",
	"Idle",
	"IdleStrafe",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeEliteLeader.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeEliteLeader.Sequences[CombatSituations.Dodging] = {
	"HobbeLeaderEliteBerserk"
}
CombatStyles.HobbeEliteLeader.CanBlock = true
CombatStyles.HobbeEliteLeader.BlockData = {}
CombatStyles.HobbeEliteLeader.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeEliteLeader.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeEliteLeader.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeEliteLeader.BlockData.SecondsToBlockFor = 2
CombatStyles.HobbeEliteLeader.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeEliteLeader.DoRunIntoStrafe = true
CombatStyles.HobbeEliteLeader.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeEliteLeader.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Ambusher Leader --
CombatStyles.HobbeAmbusherLeader = {}
CombatStyles.HobbeAmbusherLeader.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeAmbusherLeader.CanStrafe = true
CombatStyles.HobbeAmbusherLeader.CanSheatheWeapon = true
CombatStyles.HobbeAmbusherLeader.PreferOuterRing = true
CombatStyles.HobbeAmbusherLeader.IsLeaderType = true
CombatStyles.HobbeAmbusherLeader.EnterStrafeDist = 7.5
CombatStyles.HobbeAmbusherLeader.DisableAimMode = true
CombatStyles.HobbeAmbusherLeader.ActionModifiers = {}
CombatStyles.HobbeAmbusherLeader.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeAmbusherLeader.Limits = {}
CombatStyles.HobbeAmbusherLeader.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeAmbusherLeader.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeAmbusherLeader.Limits[CombatZones.Far] = 4.5
CombatStyles.HobbeAmbusherLeader.Limits[CombatZones.Left] = 2
CombatStyles.HobbeAmbusherLeader.Limits[CombatZones.Right] = 2
CombatStyles.HobbeAmbusherLeader.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeAmbusherLeader.DoSpotTargetAnim = true
CombatStyles.HobbeAmbusherLeader.CanFlee = true
CombatStyles.HobbeAmbusherLeader.FleeAnim = "Flee"
CombatStyles.HobbeAmbusherLeader.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeAmbusherLeader.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeAmbusherLeader.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.HobbeAmbusherLeader.MinSecondsBetweenRangedAttacks = 3
CombatStyles.HobbeAmbusherLeader.LaughAtKnockdown = {}
CombatStyles.HobbeAmbusherLeader.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeAmbusherLeader.LaughAtKnockdown.MinSecondsBetween = 10
CombatStyles.HobbeAmbusherLeader.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeAmbusherLeader.Enrage = {}
CombatStyles.HobbeAmbusherLeader.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeAmbusherLeader.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeAmbusherLeader.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeAmbusherLeader.Enrage.Duration = 7
CombatStyles.HobbeAmbusherLeader.Sequences = {}
CombatStyles.HobbeAmbusherLeader.Sequences[CombatSituations.Melee] = {
	{"HobbeLeaderEliteFlourishLeft", 20},
	"HobbeLeaderEliteOrbSuckingResponse",
	"HobbeLeaderEliteCloseAttackCombo",
	"HobbeLeaderEliteFarAttackCombo",
	"HobbeLeaderEliteAttackCombo",
	"Idle",
	"IdleStrafe",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeAmbusherLeader.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeAmbusherLeader.Sequences[CombatSituations.Dodging] = {
	"HobbeLeaderEliteBerserk"
}
CombatStyles.HobbeAmbusherLeader.CanBlock = true
CombatStyles.HobbeAmbusherLeader.BlockData = {}
CombatStyles.HobbeAmbusherLeader.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeAmbusherLeader.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeAmbusherLeader.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeAmbusherLeader.BlockData.SecondsToBlockFor = 2
CombatStyles.HobbeAmbusherLeader.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeAmbusherLeader.DoRunIntoStrafe = true
CombatStyles.HobbeAmbusherLeader.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeAmbusherLeader.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe StiltWalker --
CombatStyles.HobbeStiltWalker = {}
CombatStyles.HobbeStiltWalker.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeStiltWalker.TurnToFaceTolerance = 80
CombatStyles.HobbeStiltWalker.MovementTolerance = 3
CombatStyles.HobbeStiltWalker.ProngTolerance = 80
CombatStyles.HobbeStiltWalker.CanSheatheWeapon = true
CombatStyles.HobbeStiltWalker.ForceOuterRing = true
CombatStyles.HobbeStiltWalker.PreferOuterRing = true
CombatStyles.HobbeStiltWalker.IsLeaderType = true
CombatStyles.HobbeStiltWalker.ActionModifiers = {}
CombatStyles.HobbeStiltWalker.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeStiltWalker.Limits = {}
CombatStyles.HobbeStiltWalker.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeStiltWalker.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeStiltWalker.Limits[CombatZones.Far] = 5
CombatStyles.HobbeStiltWalker.Limits[CombatZones.Left] = 2
CombatStyles.HobbeStiltWalker.Limits[CombatZones.Right] = 2
CombatStyles.HobbeStiltWalker.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeStiltWalker.DoSpotTargetAnim = true
CombatStyles.HobbeStiltWalker.MinSecondsBetweenMeleeAttacks = 5
CombatStyles.HobbeStiltWalker.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeStiltWalker.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.HobbeStiltWalker.ForceWeaponType = WeaponTypes.Ranged
CombatStyles.HobbeStiltWalker.AttachNonForcedWeaponType = true
CombatStyles.HobbeStiltWalker.StompTriggerDistance = 2
CombatStyles.HobbeStiltWalker.SecondsBetweenStomps = 10
CombatStyles.HobbeStiltWalker.StompExplosionType = "ExplosionHobbeStiltStomp"
CombatStyles.HobbeStiltWalker.StompSpeedMultiplier = 1.5
CombatStyles.HobbeStiltWalker.Sequences = {}
CombatStyles.HobbeStiltWalker.Sequences[CombatSituations.Ranged] = {
	"Idle",
	"Advance",
	"BackOff"
}
CombatStyles.HobbeStiltWalker.ValidStates = {}
CombatStyles.HobbeStiltWalker.ValidStates[CombatSituations.Melee] = {
	"StiltWalkerStop",
	"WaitForActionToFinish",
	"StiltWalkerUpdateWeapon",
	"StiltWalkerStomp",
	"StiltWalkerAim",
	"StiltWalkerShoot",
	"StiltWalkerReload",
	"CheckForBetterTarget",
	"StiltWalkerMove",
	"StiltWalkerFaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.HobbeStiltWalker.ValidStates[CombatSituations.Ranged] = {
	"StiltWalkerStop",
	"WaitForActionToFinish",
	"StiltWalkerUpdateWeapon",
	"StiltWalkerStomp",
	"StiltWalkerAim",
	"StiltWalkerShoot",
	"StiltWalkerReload",
	"CheckForBetterTarget",
	"StiltWalkerMove",
	"StiltWalkerFaceTarget",
	"IdleWithRangedWeapon"
}
CombatStyles.HobbeStiltWalker.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.HobbeStiltWalker.ShootingBalanceData = {}
CombatStyles.HobbeStiltWalker.ShootingBalanceData.StartingChanceToHitWithFirearm = 0
CombatStyles.HobbeStiltWalker.ShootingBalanceData.MaxChanceToHitWithFirearmCap = 0.3
CombatStyles.HobbeStiltWalker.ShootingBalanceData.ChanceToHitModBonusRangeDistance = 9
CombatStyles.HobbeStiltWalker.ShootingBalanceData.ChanceToHitModSegmentLength = 3
CombatStyles.HobbeStiltWalker.ShootingBalanceData.ChanceToHitModPercentageIncrease = 0.03
CombatStyles.HobbeStiltWalker.ShootingBalanceData.ChanceToHitModConsecutiveShotPercentageIncrease = 0.04
CombatStyles.HobbeStiltWalker.ShootingBalanceData.ChanceToHitModConsecutiveShotsTimeFrame = 25
CombatStyles.HobbeStiltWalker.ShootingBalanceData.ChanceToHitModPercentageDecreasePerOneSpeed = 0.9
CombatStyles.HobbeStiltWalker.ShootingBalanceData.ChanceToHitModTargetInCoverPercentageMultiplier = 0.9
CombatStyles.HobbeStiltWalker.ShootingBalanceData.ChanceToHitModOffScreenPercentageMultiplier = 0.05


-- Hobbe StiltWalker Elite --
CombatStyles.HobbeStiltWalkerElite = DeepCopyTable(CombatStyles.HobbeStiltWalker)


-- Hobbe Caster --
CombatStyles.HobbeCaster = {}
CombatStyles.HobbeCaster.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeCaster.CanStrafe = true
CombatStyles.HobbeCaster.TurnToFaceTolerance = 30
CombatStyles.HobbeCaster.MovementTolerance = 2
CombatStyles.HobbeCaster.ProngTolerance = 60
CombatStyles.HobbeCaster.DesiredRange = 7
CombatStyles.HobbeCaster.CanSheatheWeapon = false
CombatStyles.HobbeCaster.ForceOuterRing = true
CombatStyles.HobbeCaster.CanFlee = false
CombatStyles.HobbeCaster.EnterStrafeDist = 10
CombatStyles.HobbeCaster.ActionModifiers = {}
CombatStyles.HobbeCaster.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeCaster.Limits = {}
CombatStyles.HobbeCaster.Limits[CombatZones.Near] = 2
CombatStyles.HobbeCaster.Limits[CombatZones.Middle] = 5
CombatStyles.HobbeCaster.Limits[CombatZones.Far] = 20
CombatStyles.HobbeCaster.Limits[CombatZones.Left] = 2
CombatStyles.HobbeCaster.Limits[CombatZones.Right] = 2
CombatStyles.HobbeCaster.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeCaster.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.HobbeCaster.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeCaster.MinSecondsBetweenFireballs = 6
CombatStyles.HobbeCaster.FireballDamage = 10
CombatStyles.HobbeCaster.ImpactExplosionDamage = 5
CombatStyles.HobbeCaster.FireballDoesSmallImpact = true
CombatStyles.HobbeCaster.Sequences = {}
CombatStyles.HobbeCaster.Sequences[CombatSituations.Melee] = {
	 "HobbeCasterAntiSpamCounterAttackFar",
	 "HobbeCasterAntiSpamCounterAttackClose",
	 "HobbeCasterRearAttack",
	 "Idle",
	 "BackOff"
}
CombatStyles.HobbeCaster.SummonInfo = {}
CombatStyles.HobbeCaster.SummonInfo.CreatureType = "CreatureHobbeSkeleton"
CombatStyles.HobbeCaster.SummonInfo.NumberToSummon = 1
CombatStyles.HobbeCaster.SummonInfo.MaxTotalToSummon = 3
CombatStyles.HobbeCaster.SummonInfo.RiseAction = {}
CombatStyles.HobbeCaster.SummonInfo.RiseAction.Type = EScriptableAction.AMBUSH
CombatStyles.HobbeCaster.SummonInfo.RiseAction.Anim = "SkeletonRise"
CombatStyles.HobbeCaster.SummonInfo.SpawnRadius = 2
CombatStyles.HobbeCaster.SummonInfo.MinSecondsBetween = 10
CombatStyles.HobbeCaster.ValidStates = {}
CombatStyles.HobbeCaster.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"PlayCombatSequence",
	"SpellCasterSummon",
	"SpellCasterFireball",
	"SpellCasterPose",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.HobbeCaster.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCaster.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCaster.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCaster.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Hobbe Caster WithEliteHobbes --
CombatStyles.HobbeCasterWithEliteHobbes = {}
CombatStyles.HobbeCasterWithEliteHobbes.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeCasterWithEliteHobbes.CanStrafe = true
CombatStyles.HobbeCasterWithEliteHobbes.TurnToFaceTolerance = 30
CombatStyles.HobbeCasterWithEliteHobbes.MovementTolerance = 2
CombatStyles.HobbeCasterWithEliteHobbes.ProngTolerance = 60
CombatStyles.HobbeCasterWithEliteHobbes.DesiredRange = 7
CombatStyles.HobbeCasterWithEliteHobbes.CanSheatheWeapon = false
CombatStyles.HobbeCasterWithEliteHobbes.ForceOuterRing = true
CombatStyles.HobbeCasterWithEliteHobbes.CanFlee = false
CombatStyles.HobbeCasterWithEliteHobbes.EnterStrafeDist = 10
CombatStyles.HobbeCasterWithEliteHobbes.ActionModifiers = {}
CombatStyles.HobbeCasterWithEliteHobbes.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeCasterWithEliteHobbes.Limits = {}
CombatStyles.HobbeCasterWithEliteHobbes.Limits[CombatZones.Near] = 2
CombatStyles.HobbeCasterWithEliteHobbes.Limits[CombatZones.Middle] = 5
CombatStyles.HobbeCasterWithEliteHobbes.Limits[CombatZones.Far] = 20
CombatStyles.HobbeCasterWithEliteHobbes.Limits[CombatZones.Left] = 2
CombatStyles.HobbeCasterWithEliteHobbes.Limits[CombatZones.Right] = 2
CombatStyles.HobbeCasterWithEliteHobbes.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeCasterWithEliteHobbes.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.HobbeCasterWithEliteHobbes.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeCasterWithEliteHobbes.MinSecondsBetweenFireballs = 6
CombatStyles.HobbeCasterWithEliteHobbes.FireballDamage = 10
CombatStyles.HobbeCasterWithEliteHobbes.ImpactExplosionDamage = 5
CombatStyles.HobbeCasterWithEliteHobbes.FireballDoesSmallImpact = true
CombatStyles.HobbeCasterWithEliteHobbes.Sequences = {}
CombatStyles.HobbeCasterWithEliteHobbes.Sequences[CombatSituations.Melee] = {
	 "HobbeCasterAntiSpamCounterAttackFar",
	 "HobbeCasterAntiSpamCounterAttackClose",
	 "HobbeCasterRearAttack",
	 "Idle",
	 "BackOff"
}
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo = {}
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo.CreatureType = "CreatureHobbeEliteSkeletonHardBlock"
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo.NumberToSummon = 1
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo.MaxTotalToSummon = 2
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo.RiseAction = {}
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo.RiseAction.Type = EScriptableAction.AMBUSH
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo.RiseAction.Anim = "SkeletonRise"
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo.SpawnRadius = 2
CombatStyles.HobbeCasterWithEliteHobbes.SummonInfo.MinSecondsBetween = 10
CombatStyles.HobbeCasterWithEliteHobbes.ValidStates = {}
CombatStyles.HobbeCasterWithEliteHobbes.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"PlayCombatSequence",
	"SpellCasterSummon",
	"SpellCasterFireball",
	"SpellCasterPose",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.HobbeCasterWithEliteHobbes.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterWithEliteHobbes.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterWithEliteHobbes.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterWithEliteHobbes.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Hobbe Caster Healer --
CombatStyles.HobbeCasterHealer = {}
CombatStyles.HobbeCasterHealer.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeCasterHealer.CanStrafe = true
CombatStyles.HobbeCasterHealer.TurnToFaceTolerance = 30
CombatStyles.HobbeCasterHealer.MovementTolerance = 3
CombatStyles.HobbeCasterHealer.ProngTolerance = 60
CombatStyles.HobbeCasterHealer.CanSheatheWeapon = false
CombatStyles.HobbeCasterHealer.ForceOuterRing = true
CombatStyles.HobbeCasterHealer.IsLeaderType = true
CombatStyles.HobbeCasterHealer.ActionModifiers = {}
CombatStyles.HobbeCasterHealer.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeCasterHealer.Limits = {}
CombatStyles.HobbeCasterHealer.Limits[CombatZones.Near] = 1.75
CombatStyles.HobbeCasterHealer.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeCasterHealer.Limits[CombatZones.Far] = 5
CombatStyles.HobbeCasterHealer.Limits[CombatZones.Left] = 2
CombatStyles.HobbeCasterHealer.Limits[CombatZones.Right] = 2
CombatStyles.HobbeCasterHealer.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeCasterHealer.MinSecondsBetweenMeleeAttacks = 5
CombatStyles.HobbeCasterHealer.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeCasterHealer.MinSecondsBetweenFireballs = 9
CombatStyles.HobbeCasterHealer.MinSecondsBetweenHeal = 30
CombatStyles.HobbeCasterHealer.MinSecondsBetweenEnrage = 30
CombatStyles.HobbeCasterHealer.FireballDamage = 20
CombatStyles.HobbeCasterHealer.ImpactExplosionDamage = 5
CombatStyles.HobbeCasterHealer.FireballDoesSmallImpact = true
CombatStyles.HobbeCasterHealer.CanFlee = true
CombatStyles.HobbeCasterHealer.FleeAnim = "Flee"
CombatStyles.HobbeCasterHealer.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeCasterHealer.Sequences = {}
CombatStyles.HobbeCasterHealer.Sequences[CombatSituations.Melee] = {
	 "HobbeCasterEliteAntiSpamCounterAttackFar",
	 "HobbeCasterEliteAntiSpamCounterAttackClose",
	 "HobbeCasterEliteRearAttack"
}
CombatStyles.HobbeCasterHealer.SummonInfo = {}
CombatStyles.HobbeCasterHealer.SummonInfo.CreatureType = "CreatureHobbeSkeleton"
CombatStyles.HobbeCasterHealer.SummonInfo.NumberToSummon = 1
CombatStyles.HobbeCasterHealer.SummonInfo.MaxTotalToSummon = 3
CombatStyles.HobbeCasterHealer.SummonInfo.RiseAction = {}
CombatStyles.HobbeCasterHealer.SummonInfo.RiseAction.Type = EScriptableAction.AMBUSH
CombatStyles.HobbeCasterHealer.SummonInfo.RiseAction.Anim = "SkeletonRise"
CombatStyles.HobbeCasterHealer.SummonInfo.SpawnRadius = 2
CombatStyles.HobbeCasterHealer.SummonInfo.MinSecondsBetween = 20
CombatStyles.HobbeCasterHealer.ValidStates = {}
CombatStyles.HobbeCasterHealer.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"SpellCasterSummon",
	"SpellCasterHeal",
	"SpellCasterEnrage",
	"PlayCombatSequence",
	"SpellCasterPose",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.HobbeCasterHealer.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterHealer.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterHealer.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterHealer.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Hobbe Caster Elite --
CombatStyles.HobbeEliteCaster = {}
CombatStyles.HobbeEliteCaster.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeEliteCaster.CanStrafe = true
CombatStyles.HobbeEliteCaster.TurnToFaceTolerance = 30
CombatStyles.HobbeEliteCaster.MovementTolerance = 3
CombatStyles.HobbeEliteCaster.ProngTolerance = 60
CombatStyles.HobbeEliteCaster.CanSheatheWeapon = false
CombatStyles.HobbeEliteCaster.ForceOuterRing = true
CombatStyles.HobbeEliteCaster.IsLeaderType = true
CombatStyles.HobbeEliteCaster.CanFlee = true
CombatStyles.HobbeEliteCaster.FleeAnim = "Flee"
CombatStyles.HobbeEliteCaster.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeEliteCaster.EnterStrafeDist = 2
CombatStyles.HobbeEliteCaster.ActionModifiers = {}
CombatStyles.HobbeEliteCaster.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeEliteCaster.Limits = {}
CombatStyles.HobbeEliteCaster.Limits[CombatZones.Near] = 1.75
CombatStyles.HobbeEliteCaster.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeEliteCaster.Limits[CombatZones.Far] = 15
CombatStyles.HobbeEliteCaster.Limits[CombatZones.Left] = 2
CombatStyles.HobbeEliteCaster.Limits[CombatZones.Right] = 2
CombatStyles.HobbeEliteCaster.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeEliteCaster.MinSecondsBetweenMeleeAttacks = 5
CombatStyles.HobbeEliteCaster.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeEliteCaster.MinSecondsBetweenFireballs = 6
CombatStyles.HobbeEliteCaster.MinSecondsBetweenEnrage = 45
CombatStyles.HobbeEliteCaster.FireballDamage = 15
CombatStyles.HobbeEliteCaster.ImpactExplosionDamage = 10
CombatStyles.HobbeEliteCaster.FireballDoesSmallImpact = true
CombatStyles.HobbeEliteCaster.Sequences = {}
CombatStyles.HobbeEliteCaster.Sequences[CombatSituations.Melee] = {
	 "HobbeCasterEliteAntiSpamCounterAttackFar",
	 "HobbeCasterEliteAntiSpamCounterAttackClose",
	 "HobbeCasterEliteRearAttack",
	 "Idle"
}
CombatStyles.HobbeEliteCaster.SummonInfo = {}
CombatStyles.HobbeEliteCaster.SummonInfo.CreatureType = "CreatureHobbeEliteSkeleton"
CombatStyles.HobbeEliteCaster.SummonInfo.NumberToSummon = 1
CombatStyles.HobbeEliteCaster.SummonInfo.MaxTotalToSummon = 3
CombatStyles.HobbeEliteCaster.SummonInfo.RiseAction = {}
CombatStyles.HobbeEliteCaster.SummonInfo.RiseAction.Anim = "SkeletonRise"
CombatStyles.HobbeEliteCaster.SummonInfo.SpawnRadius = 2
CombatStyles.HobbeEliteCaster.SummonInfo.MinSecondsBetween = 10
CombatStyles.HobbeEliteCaster.ValidStates = {}
CombatStyles.HobbeEliteCaster.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"SpellCasterSummon",
	"SpellCasterFireball",
	"PlayCombatSequence",
	"SpellCasterPose",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.HobbeEliteCaster.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeEliteCaster.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeEliteCaster.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeEliteCaster.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Hobbe Skeleton --
CombatStyles.HobbeSkeleton = {}
CombatStyles.HobbeSkeleton.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeSkeleton.CanStrafe = true
CombatStyles.HobbeSkeleton.EnterStrafeDist = 2
CombatStyles.HobbeSkeleton.ActionModifiers = {}
CombatStyles.HobbeSkeleton.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeSkeleton.CanSheatheWeapon = true
CombatStyles.HobbeSkeleton.DisableAimMode = true
CombatStyles.HobbeSkeleton.Limits = {}
CombatStyles.HobbeSkeleton.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeSkeleton.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeSkeleton.Limits[CombatZones.Far] = 4.5
CombatStyles.HobbeSkeleton.Limits[CombatZones.Left] = 2
CombatStyles.HobbeSkeleton.Limits[CombatZones.Right] = 2
CombatStyles.HobbeSkeleton.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeSkeleton.DoSpotTargetAnim = true
CombatStyles.HobbeSkeleton.KillWhenDisarmed = true
CombatStyles.HobbeSkeleton.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeSkeleton.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.HobbeSkeleton.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.HobbeSkeleton.Enrage = {}
CombatStyles.HobbeSkeleton.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeSkeleton.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeSkeleton.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeSkeleton.Enrage.Duration = 5
CombatStyles.HobbeSkeleton.Sequences = {}
CombatStyles.HobbeSkeleton.Sequences[CombatSituations.Melee] = {
	"HobbeSkeletonOrbSuckingResponse",
	"HobbeAttackCombo",
	"HobbeCloseAttackCombo",
	"HobbeFarAttackCombo",
	"Idle",
	"IdleStrafe",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeSkeleton.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeSkeleton.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeSkeleton.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Skeleton Elite WithDodgeBlock--
CombatStyles.HobbeSkeletonElite = {}
CombatStyles.HobbeSkeletonElite.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeSkeletonElite.CanStrafe = true
CombatStyles.HobbeSkeletonElite.CanSheatheWeapon = true
CombatStyles.HobbeSkeletonElite.EnterStrafeDist = 3
CombatStyles.HobbeSkeletonElite.DisableAimMode = true
CombatStyles.HobbeSkeletonElite.ActionModifiers = {}
CombatStyles.HobbeSkeletonElite.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeSkeletonElite.Limits = {}
CombatStyles.HobbeSkeletonElite.Limits[CombatZones.Near] = 2
CombatStyles.HobbeSkeletonElite.Limits[CombatZones.Middle] = 3
CombatStyles.HobbeSkeletonElite.Limits[CombatZones.Far] = 5.5
CombatStyles.HobbeSkeletonElite.Limits[CombatZones.Left] = 2
CombatStyles.HobbeSkeletonElite.Limits[CombatZones.Right] = 2
CombatStyles.HobbeSkeletonElite.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeSkeletonElite.DoSpotTargetAnim = true
CombatStyles.HobbeSkeletonElite.KillWhenDisarmed = true
CombatStyles.HobbeSkeletonElite.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeSkeletonElite.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.HobbeSkeletonElite.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.HobbeSkeletonElite.LaughAtKnockdown = {}
CombatStyles.HobbeSkeletonElite.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeSkeletonElite.LaughAtKnockdown.MinSecondsBetween = 5
CombatStyles.HobbeSkeletonElite.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeSkeletonElite.Enrage = {}
CombatStyles.HobbeSkeletonElite.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeSkeletonElite.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeSkeletonElite.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeSkeletonElite.Enrage.Duration = 10
CombatStyles.HobbeSkeletonElite.Sequences = {}
CombatStyles.HobbeSkeletonElite.Sequences[CombatSituations.Melee] = {
	"HobbeSkeletonEliteOrbSuckingResponse",
	"HobbeEliteAttackCombo",
	"HobbeEliteCloseAttackCombo",
	"HobbeEliteFarAttackCombo",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeSkeletonElite.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeSkeletonElite.Sequences[CombatSituations.Dodging] = {
	"HobbeEliteBerserk"
}
CombatStyles.HobbeSkeletonElite.CanBlock = true
CombatStyles.HobbeSkeletonElite.BlockData = {}
CombatStyles.HobbeSkeletonElite.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeSkeletonElite.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeSkeletonElite.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeSkeletonElite.BlockData.MaxHitsToBlock = 1
CombatStyles.HobbeSkeletonElite.BlockData.SecondsToBlockFor = 2
CombatStyles.HobbeSkeletonElite.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeSkeletonElite.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeSkeletonElite.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Skeleton Elite WithHardBlock --
CombatStyles.HobbeSkeletonEliteHardBlock = {}
CombatStyles.HobbeSkeletonEliteHardBlock.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeSkeletonEliteHardBlock.CanStrafe = true
CombatStyles.HobbeSkeletonEliteHardBlock.CanSheatheWeapon = true
CombatStyles.HobbeSkeletonEliteHardBlock.EnterStrafeDist = 3
CombatStyles.HobbeSkeletonEliteHardBlock.DisableAimMode = true
CombatStyles.HobbeSkeletonEliteHardBlock.ActionModifiers = {}
CombatStyles.HobbeSkeletonEliteHardBlock.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeSkeletonEliteHardBlock.Limits = {}
CombatStyles.HobbeSkeletonEliteHardBlock.Limits[CombatZones.Near] = 2
CombatStyles.HobbeSkeletonEliteHardBlock.Limits[CombatZones.Middle] = 3
CombatStyles.HobbeSkeletonEliteHardBlock.Limits[CombatZones.Far] = 5.5
CombatStyles.HobbeSkeletonEliteHardBlock.Limits[CombatZones.Left] = 2
CombatStyles.HobbeSkeletonEliteHardBlock.Limits[CombatZones.Right] = 2
CombatStyles.HobbeSkeletonEliteHardBlock.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeSkeletonEliteHardBlock.DoSpotTargetAnim = true
CombatStyles.HobbeSkeletonEliteHardBlock.KillWhenDisarmed = true
CombatStyles.HobbeSkeletonEliteHardBlock.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeSkeletonEliteHardBlock.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.HobbeSkeletonEliteHardBlock.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.HobbeSkeletonEliteHardBlock.LaughAtKnockdown = {}
CombatStyles.HobbeSkeletonEliteHardBlock.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeSkeletonEliteHardBlock.LaughAtKnockdown.MinSecondsBetween = 5
CombatStyles.HobbeSkeletonEliteHardBlock.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeSkeletonEliteHardBlock.Enrage = {}
CombatStyles.HobbeSkeletonEliteHardBlock.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeSkeletonEliteHardBlock.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeSkeletonEliteHardBlock.Enrage.SpeedMultiplier = 1.2
CombatStyles.HobbeSkeletonEliteHardBlock.Enrage.Duration = 10
CombatStyles.HobbeSkeletonEliteHardBlock.Sequences = {}
CombatStyles.HobbeSkeletonEliteHardBlock.Sequences[CombatSituations.Melee] = {
	"HobbeSkeletonEliteOrbSuckingResponse",
	"HobbeEliteAttackCombo",
	"HobbeEliteCloseAttackCombo",
	"HobbeEliteFarAttackCombo",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeSkeletonEliteHardBlock.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeSkeletonEliteHardBlock.Sequences[CombatSituations.HardBlocking] = {
	"HobbeEliteBerserk"
}
CombatStyles.HobbeSkeletonEliteHardBlock.CanBlock = true
CombatStyles.HobbeSkeletonEliteHardBlock.BlockData = {}
CombatStyles.HobbeSkeletonEliteHardBlock.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.HobbeSkeletonEliteHardBlock.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 4
CombatStyles.HobbeSkeletonEliteHardBlock.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeSkeletonEliteHardBlock.BlockData.SecondsToBlockFor = 1.6
CombatStyles.HobbeSkeletonEliteHardBlock.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeSkeletonEliteHardBlock.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Skeleton Elite QO190 --
CombatStyles.HobbeSkeletonEliteQO190 = {}
CombatStyles.HobbeSkeletonEliteQO190.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeSkeletonEliteQO190.CanStrafe = true
CombatStyles.HobbeSkeletonEliteQO190.CanSheatheWeapon = true
CombatStyles.HobbeSkeletonEliteQO190.EnterStrafeDist = 3
CombatStyles.HobbeSkeletonEliteQO190.DisableAimMode = true
CombatStyles.HobbeSkeletonEliteQO190.ActionModifiers = {}
CombatStyles.HobbeSkeletonEliteQO190.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeSkeletonEliteQO190.Limits = {}
CombatStyles.HobbeSkeletonEliteQO190.Limits[CombatZones.Near] = 2
CombatStyles.HobbeSkeletonEliteQO190.Limits[CombatZones.Middle] = 4
CombatStyles.HobbeSkeletonEliteQO190.Limits[CombatZones.Far] = 5.5
CombatStyles.HobbeSkeletonEliteQO190.Limits[CombatZones.Left] = 2
CombatStyles.HobbeSkeletonEliteQO190.Limits[CombatZones.Right] = 2
CombatStyles.HobbeSkeletonEliteQO190.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeSkeletonEliteQO190.DoSpotTargetAnim = true
CombatStyles.HobbeSkeletonEliteQO190.KillWhenDisarmed = true
CombatStyles.HobbeSkeletonEliteQO190.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeSkeletonEliteQO190.MinSecondsBetweenMeleeAttacks = 3
CombatStyles.HobbeSkeletonEliteQO190.SecondsToWaitAfterTargetIsHit = 4
CombatStyles.HobbeSkeletonEliteQO190.LaughAtKnockdown = {}
CombatStyles.HobbeSkeletonEliteQO190.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeSkeletonEliteQO190.LaughAtKnockdown.MinSecondsBetween = 5
CombatStyles.HobbeSkeletonEliteQO190.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeSkeletonEliteQO190.Enrage = {}
CombatStyles.HobbeSkeletonEliteQO190.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeSkeletonEliteQO190.Enrage.DamageMultiplier = 1.35
CombatStyles.HobbeSkeletonEliteQO190.Enrage.SpeedMultiplier = 1.25
CombatStyles.HobbeSkeletonEliteQO190.Enrage.Duration = 10
CombatStyles.HobbeSkeletonEliteQO190.Sequences = {}
CombatStyles.HobbeSkeletonEliteQO190.Sequences[CombatSituations.Melee] = {
	"HobbeSkeletonEliteOrbSuckingResponse",
	"HobbeEliteAttackCombo",
	"HobbeEliteCloseAttackCombo",
	"HobbeEliteFarAttackCombo",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeSkeletonEliteQO190.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeSkeletonEliteQO190.Sequences[CombatSituations.Dodging] = {
	"HobbeEliteBerserk"
}
CombatStyles.HobbeSkeletonEliteQO190.CanBlock = true
CombatStyles.HobbeSkeletonEliteQO190.BlockData = {}
CombatStyles.HobbeSkeletonEliteQO190.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeSkeletonEliteQO190.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeSkeletonEliteQO190.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeSkeletonEliteQO190.BlockData.MaxHitsToBlock = 2
CombatStyles.HobbeSkeletonEliteQO190.BlockData.SecondsToBlockFor = 2
CombatStyles.HobbeSkeletonEliteQO190.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeSkeletonEliteQO190.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeSkeletonEliteQO190.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Caster Squatter QO190 --
CombatStyles.HobbeCasterSquatterQO190 = {}
CombatStyles.HobbeCasterSquatterQO190.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeCasterSquatterQO190.CanStrafe = true
CombatStyles.HobbeCasterSquatterQO190.TurnToFaceTolerance = 30
CombatStyles.HobbeCasterSquatterQO190.MovementTolerance = 3
CombatStyles.HobbeCasterSquatterQO190.ProngTolerance = 60
CombatStyles.HobbeCasterSquatterQO190.EnterStrafeDist = 7.5
CombatStyles.HobbeCasterSquatterQO190.ActionModifiers = {}
CombatStyles.HobbeCasterSquatterQO190.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeCasterSquatterQO190.CanSheatheWeapon = false
CombatStyles.HobbeCasterSquatterQO190.ForceOuterRing = true
CombatStyles.HobbeCasterSquatterQO190.IsLeaderType = true
CombatStyles.HobbeCasterSquatterQO190.Limits = {}
CombatStyles.HobbeCasterSquatterQO190.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeCasterSquatterQO190.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeCasterSquatterQO190.Limits[CombatZones.Far] = 6
CombatStyles.HobbeCasterSquatterQO190.Limits[CombatZones.Left] = 2
CombatStyles.HobbeCasterSquatterQO190.Limits[CombatZones.Right] = 2
CombatStyles.HobbeCasterSquatterQO190.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeCasterSquatterQO190.MinSecondsBetweenMeleeAttacks = 5
CombatStyles.HobbeCasterSquatterQO190.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeCasterSquatterQO190.MinSecondsBetweenFireballs = 3
CombatStyles.HobbeCasterSquatterQO190.MinSecondsBetweenEnrage = 20
CombatStyles.HobbeCasterSquatterQO190.Sequences = {}
CombatStyles.HobbeCasterSquatterQO190.Sequences[CombatSituations.Melee] = {
	 "HobbeCasterQO190InteruptSpell",
	 "HobbeCasterQO190GettingShotResponse",
	 "HobbeCasterQO190OrbSuckingResponse"
}
CombatStyles.HobbeCasterSquatterQO190.Sequences[CombatSituations.Dodging] = {
	 "HobbeCasterQO190BlockBreaker"
}
CombatStyles.HobbeCasterSquatterQO190.SummonInfo = {}
CombatStyles.HobbeCasterSquatterQO190.SummonInfo.CreatureType = "CreatureHobbeEliteSkeletonQO190"
CombatStyles.HobbeCasterSquatterQO190.SummonInfo.NumberToSummon = 3
CombatStyles.HobbeCasterSquatterQO190.SummonInfo.MaxTotalToSummon = 3
CombatStyles.HobbeCasterSquatterQO190.SummonInfo.RiseAction = {}
CombatStyles.HobbeCasterSquatterQO190.SummonInfo.RiseAction.Anim = "SkeletonRise"
CombatStyles.HobbeCasterSquatterQO190.SummonInfo.SpawnRadius = 2
CombatStyles.HobbeCasterSquatterQO190.SummonInfo.MinSecondsBetween = 25
CombatStyles.HobbeCasterSquatterQO190.CanBlock = true
CombatStyles.HobbeCasterSquatterQO190.BlockData = {}
CombatStyles.HobbeCasterSquatterQO190.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_DODGE_MELEE
CombatStyles.HobbeCasterSquatterQO190.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeCasterSquatterQO190.BlockData.NumberOfHitsToForcePrimaryBlock = 1
CombatStyles.HobbeCasterSquatterQO190.BlockData.SecondsToBlockFor = 2
CombatStyles.HobbeCasterSquatterQO190.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeCasterSquatterQO190.CanEvadeShots = true
CombatStyles.HobbeCasterSquatterQO190.EvadeShotsData = {}
CombatStyles.HobbeCasterSquatterQO190.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.HobbeCasterSquatterQO190.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.HobbeCasterSquatterQO190.EvadeShotsData.HitsToStartEvading = 2
CombatStyles.HobbeCasterSquatterQO190.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeCasterSquatterQO190.ValidStates = {}
CombatStyles.HobbeCasterSquatterQO190.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"SpellCasterSummon",
	"SpellCasterEnrage",
	"SpellCasterFireball",
	"SpellCasterHeal",
	"PlayCombatSequence",
	"SpellCasterPose",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"OuterRingKeepDistance",
	"OuterRingSpreadOut",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.HobbeCasterSquatterQO190.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterSquatterQO190.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterSquatterQO190.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterSquatterQO190.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Hobbe Leader QO270 --
CombatStyles.HobbeLeaderQO270 = {}
CombatStyles.HobbeLeaderQO270.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeLeaderQO270.CanStrafe = true
CombatStyles.HobbeLeaderQO270.CanSheatheWeapon = true
CombatStyles.HobbeLeaderQO270.PreferOuterRing = true
CombatStyles.HobbeLeaderQO270.IsLeaderType = true
CombatStyles.HobbeLeaderQO270.EnterStrafeDist = 7.5
CombatStyles.HobbeLeaderQO270.DisableAimMode = true
CombatStyles.HobbeLeaderQO270.ActionModifiers = {}
CombatStyles.HobbeLeaderQO270.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeLeaderQO270.Limits = {}
CombatStyles.HobbeLeaderQO270.Limits[CombatZones.Near] = 2
CombatStyles.HobbeLeaderQO270.Limits[CombatZones.Middle] = 4
CombatStyles.HobbeLeaderQO270.Limits[CombatZones.Far] = 5.5
CombatStyles.HobbeLeaderQO270.Limits[CombatZones.Left] = 2
CombatStyles.HobbeLeaderQO270.Limits[CombatZones.Right] = 2
CombatStyles.HobbeLeaderQO270.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeLeaderQO270.DoSpotTargetAnim = true
CombatStyles.HobbeLeaderQO270.MinSecondsBetweenMeleeAttacks = 2.5
CombatStyles.HobbeLeaderQO270.MinSecondsBetweenRangedAttacks = 4
CombatStyles.HobbeLeaderQO270.LaughAtKnockdown = {}
CombatStyles.HobbeLeaderQO270.LaughAtKnockdown.Anim = "CombatLaugh"
CombatStyles.HobbeLeaderQO270.LaughAtKnockdown.MinSecondsBetween = 10
CombatStyles.HobbeLeaderQO270.LaughAtKnockdown.OnlyIfIKnockedTargetDown = false
CombatStyles.HobbeLeaderQO270.Enrage = {}
CombatStyles.HobbeLeaderQO270.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeLeaderQO270.Enrage.DamageMultiplier = 1.2
CombatStyles.HobbeLeaderQO270.Enrage.SpeedMultiplier = 1.4
CombatStyles.HobbeLeaderQO270.Enrage.Duration = 7
CombatStyles.HobbeLeaderQO270.Sequences = {}
CombatStyles.HobbeLeaderQO270.Sequences[CombatSituations.Melee] = {
	"HobbeLeaderQO270OrbSuckingResponse",
	"HobbeLeaderQO270GettingMagicedTooMuch",
	"HobbeLeaderQO270GettingShotTooMuch",
	"HobbeLeaderQO270FlourishLeft",
	"HobbeLeaderQO270CloseAttackCombo",
	"HobbeLeaderQO270FarAttackCombo",
	"HobbeLeaderQO270AttackCombo",
	"Idle",
	"IdleStrafe",
	"EliteAdvance",
	"EliteBackOff",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack"
}
CombatStyles.HobbeLeaderQO270.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeLeaderQO270.Sequences[CombatSituations.HardBlocking] = {
	"HobbeLeaderQO270Berserk"
}
CombatStyles.HobbeLeaderQO270.CanBlock = true
CombatStyles.HobbeLeaderQO270.BlockData = {}
CombatStyles.HobbeLeaderQO270.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.HobbeLeaderQO270.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 4
CombatStyles.HobbeLeaderQO270.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeLeaderQO270.BlockData.SecondsToBlockFor = 2
CombatStyles.HobbeLeaderQO270.DodgeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeLeaderQO270.CanEvadeShots = true
CombatStyles.HobbeLeaderQO270.EvadeShotsData = {}
CombatStyles.HobbeLeaderQO270.EvadeShotsData.TimeToCheckFor = 7
CombatStyles.HobbeLeaderQO270.EvadeShotsData.TimeToEvadeFor = 3
CombatStyles.HobbeLeaderQO270.EvadeShotsData.HitsToStartEvading = 1
CombatStyles.HobbeLeaderQO270.EvadeAnimations = {
	"DodgeLeft",
	"DodgeRight"
}
CombatStyles.HobbeLeaderQO270.DoRunIntoStrafe = true
CombatStyles.HobbeLeaderQO270.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeLeaderQO270.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Sniper Turret --
CombatStyles.HobbeSniperTurret = {}
CombatStyles.HobbeSniperTurret.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeSniperTurret.ForceWeaponType = WeaponTypes.Ranged
CombatStyles.HobbeSniperTurret.NonFormation = true
CombatStyles.HobbeSniperTurret.CanStrafe = true
CombatStyles.HobbeSniperTurret.EnterStrafeDist = 2
CombatStyles.HobbeSniperTurret.ActionModifiers = {}
CombatStyles.HobbeSniperTurret.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeSniperTurret.CanSheatheWeapon = true
CombatStyles.HobbeSniperTurret.CanStandOffAndShoot = "Turret"
CombatStyles.HobbeSniperTurret.TurretBalanceData = {}
CombatStyles.HobbeSniperTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 1
CombatStyles.HobbeSniperTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.HobbeSniperTurret.TurretBalanceData.NonTurretCombatStyle = "HobbeSniper"
CombatStyles.HobbeSniperTurret.Limits = {}
CombatStyles.HobbeSniperTurret.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeSniperTurret.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeSniperTurret.Limits[CombatZones.Far] = 4.5
CombatStyles.HobbeSniperTurret.Limits[CombatZones.Left] = 2
CombatStyles.HobbeSniperTurret.Limits[CombatZones.Right] = 2
CombatStyles.HobbeSniperTurret.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeSniperTurret.DoSpotTargetAnim = true
CombatStyles.HobbeSniperTurret.CanFlee = false
CombatStyles.HobbeSniperTurret.FleeAnim = "Flee"
CombatStyles.HobbeSniperTurret.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeSniperTurret.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeSniperTurret.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.HobbeSniperTurret.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeSniperTurret.Enrage = {}
CombatStyles.HobbeSniperTurret.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeSniperTurret.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeSniperTurret.Enrage.SpeedMultiplier = 1.1
CombatStyles.HobbeSniperTurret.Enrage.Duration = 5
CombatStyles.HobbeSniperTurret.Sequences = {}
CombatStyles.HobbeSniperTurret.Sequences[CombatSituations.Melee] = {
	"Idle"
}
CombatStyles.HobbeSniperTurret.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeSniperTurret.ValidStates = {}
CombatStyles.HobbeSniperTurret.ValidStates[CombatSituations.Ranged] = {
	"PlayBanterCombatComment",
	"WaitForActionToFinish",
	"TurretUpdateWeapon",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"FireRangedWeapon",
	"PlayCombatSequence",
	"MoveToFormationPos",
	"FaceTarget"
}
CombatStyles.HobbeSniperTurret.ValidStates[CombatSituations.Melee] = CombatStyles.StandardMeleeCombatStates
CombatStyles.HobbeSniperTurret.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeSniperTurret.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeSniperTurret.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeSniperTurret.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates
CombatStyles.HobbeSniperTurret.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Caster Turret --
CombatStyles.HobbeCasterTurret = {}
CombatStyles.HobbeCasterTurret.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeCasterTurret.CanStrafe = true
CombatStyles.HobbeCasterTurret.TurnToFaceTolerance = 30
CombatStyles.HobbeCasterTurret.MovementTolerance = 3
CombatStyles.HobbeCasterTurret.ProngTolerance = 60
CombatStyles.HobbeCasterTurret.CanStandOffAndShoot = "Turret"
CombatStyles.HobbeCasterTurret.TurretBalanceData = {}
CombatStyles.HobbeCasterTurret.TurretBalanceData.DistanceToMoveBackToShootingPosition = 2
CombatStyles.HobbeCasterTurret.TurretBalanceData.DistanceOverWhichToFindNewShootingPosition = 5
CombatStyles.HobbeCasterTurret.TurretBalanceData.NonTurretCombatStyle = "HobbeCaster"
CombatStyles.HobbeCasterTurret.CanSheatheWeapon = false
CombatStyles.HobbeCasterTurret.ForceOuterRing = true
CombatStyles.HobbeCasterTurret.IsLeaderType = true
CombatStyles.HobbeCasterTurret.CanFlee = false
CombatStyles.HobbeCasterTurret.FleeAnim = "Flee"
CombatStyles.HobbeCasterTurret.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeCasterTurret.EnterStrafeDist = 3
CombatStyles.HobbeCasterTurret.NonFormation = true
CombatStyles.HobbeCasterTurret.ActionModifiers = {}
CombatStyles.HobbeCasterTurret.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeCasterTurret.Limits = {}
CombatStyles.HobbeCasterTurret.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeCasterTurret.Limits[CombatZones.Middle] = 3.5
CombatStyles.HobbeCasterTurret.Limits[CombatZones.Far] = 10
CombatStyles.HobbeCasterTurret.Limits[CombatZones.Left] = 2
CombatStyles.HobbeCasterTurret.Limits[CombatZones.Right] = 2
CombatStyles.HobbeCasterTurret.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeCasterTurret.MinSecondsBetweenMeleeAttacks = 2
CombatStyles.HobbeCasterTurret.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeCasterTurret.MinSecondsBetweenFireballs = 10
CombatStyles.HobbeCasterTurret.MinSecondsBetweenHeal = 30
CombatStyles.HobbeCasterTurret.FireballDamage = 10
CombatStyles.HobbeCasterTurret.ImpactExplosionDamage = 5
CombatStyles.HobbeCasterTurret.FireballDoesSmallImpact = true
CombatStyles.HobbeCasterTurret.Sequences = {}
CombatStyles.HobbeCasterTurret.Sequences[CombatSituations.Melee] = {
	"HobbeCasterAntiSpamCounterAttackFar",
	"HobbeCasterAntiSpamCounterAttackClose",
	"HobbeCasterRearAttack",
	"Idle"
}
CombatStyles.HobbeCasterTurret.SummonInfo = {}
CombatStyles.HobbeCasterTurret.SummonInfo.CreatureType = "CreatureHobbeSkeleton"
CombatStyles.HobbeCasterTurret.SummonInfo.NumberToSummon = 3
CombatStyles.HobbeCasterTurret.SummonInfo.MaxTotalToSummon = 3
CombatStyles.HobbeCasterTurret.SummonInfo.RiseAction = {}
CombatStyles.HobbeCasterTurret.SummonInfo.RiseAction.Type = EScriptableAction.AMBUSH
CombatStyles.HobbeCasterTurret.SummonInfo.RiseAction.Anim = "SkeletonRise"
CombatStyles.HobbeCasterTurret.SummonInfo.SpawnRadius = 2
CombatStyles.HobbeCasterTurret.SummonInfo.MinSecondsBetween = 20
CombatStyles.HobbeCasterTurret.ValidStates = {}
CombatStyles.HobbeCasterTurret.ValidStates[CombatSituations.Melee] = {
	"AntiSpamCheck",
	"WaitForActionToFinish",
	"SpellCasterSummon",
	"SpellCasterFireball",
	"PlayCombatSequence",
	"SpellCasterPose",
	"UpdateWeapon",
	"CheckForBetterTarget",
	"MoveToFiringPosition",
	"FaceTarget"
}
CombatStyles.HobbeCasterTurret.ValidStates[CombatSituations.SoftBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterTurret.ValidStates[CombatSituations.HardBlocking] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterTurret.ValidStates[CombatSituations.Dodging] = CombatStyles.StandardBlockingCombatStates
CombatStyles.HobbeCasterTurret.ValidStates[CombatSituations.GroupOrders] = CombatStyles.StandardGroupOrderStates


-- Hobbe Skeleton Boss --
CombatStyles.HobbeBossSkeleton = {}
CombatStyles.HobbeBossSkeleton.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeBossSkeleton.CanStrafe = true
CombatStyles.HobbeBossSkeleton.EnterStrafeDist = 3.5
CombatStyles.HobbeBossSkeleton.MaxNavSpeed = ENavigationSpeed.NAV_SPEED_WALK
CombatStyles.HobbeBossSkeleton.DisableAimMode = true
CombatStyles.HobbeBossSkeleton.ActionModifiers = {}
CombatStyles.HobbeBossSkeleton.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeBossSkeleton.CanSheatheWeapon = true
CombatStyles.HobbeBossSkeleton.Limits = {}
CombatStyles.HobbeBossSkeleton.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeBossSkeleton.Limits[CombatZones.Middle] = 5.5
CombatStyles.HobbeBossSkeleton.Limits[CombatZones.Far] = 8
CombatStyles.HobbeBossSkeleton.Limits[CombatZones.Left] = 2
CombatStyles.HobbeBossSkeleton.Limits[CombatZones.Right] = 2
CombatStyles.HobbeBossSkeleton.Limits[CombatZones.Rear] = 3
CombatStyles.HobbeBossSkeleton.DoSpotTargetAnim = true
CombatStyles.HobbeBossSkeleton.CanFlee = false
CombatStyles.HobbeBossSkeleton.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeBossSkeleton.MinSecondsBetweenMeleeAttacks = 0
CombatStyles.HobbeBossSkeleton.MinSecondsBetweenRangedAttacks = 5
CombatStyles.HobbeBossSkeleton.Sequences = {}
CombatStyles.HobbeBossSkeleton.Sequences[CombatSituations.Melee] = {
	"HobbeKingRangedCounter",
	"HobbeKingSpellCounter",
	"HobbeKingCloseDistanceAndStrike",
	"HobbeKingCloseDistanceAndStrikeAlternate",
	"HobbeKingAttackSpinCombo",
	"HobbeKingAttackComboWithoutRoar",
	"HobbeKingCloseAttackComboWithoutRoar",
	"HobbeKingLeftAttack",
	"HobbeKingRightAttack",
	"HobbeKingRearAttack",
	"HobbeKingRearAttackAlternate",
	"HobbeKingAttackCombo",
	"Idle",
	"Advance"
}
CombatStyles.HobbeBossSkeleton.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeBossSkeleton.Sequences[CombatSituations.HardBlocking] = {
	"HobbeKingBerserk"
}
CombatStyles.HobbeBossSkeleton.CanBlock = true
CombatStyles.HobbeBossSkeleton.BlockData = {}
CombatStyles.HobbeBossSkeleton.BlockData.PrimaryBlockType = EBlockType.BLOCK_TYPE_STATIC
CombatStyles.HobbeBossSkeleton.BlockData.SecondsForSuccessiveHitsToPrimaryBlock = 6
CombatStyles.HobbeBossSkeleton.BlockData.NumberOfHitsToForcePrimaryBlock = 2
CombatStyles.HobbeBossSkeleton.BlockData.SecondsToBlockFor = 1.2
CombatStyles.HobbeBossSkeleton.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- Hobbe Grunt CantFlee --
CombatStyles.HobbeGruntCantFlee = {}
CombatStyles.HobbeGruntCantFlee.CombatGroupType = CombatGroupTypes.HobbeLike
CombatStyles.HobbeGruntCantFlee.CanStrafe = true
CombatStyles.HobbeGruntCantFlee.EnterStrafeDist = 3
CombatStyles.HobbeGruntCantFlee.DisableAimMode = true
CombatStyles.HobbeGruntCantFlee.ActionModifiers = {}
CombatStyles.HobbeGruntCantFlee.ActionModifiers.MinDistToTarget = 0.75
CombatStyles.HobbeGruntCantFlee.CanSheatheWeapon = true
CombatStyles.HobbeGruntCantFlee.Limits = {}
CombatStyles.HobbeGruntCantFlee.Limits[CombatZones.Near] = 1.5
CombatStyles.HobbeGruntCantFlee.Limits[CombatZones.Middle] = 2.5
CombatStyles.HobbeGruntCantFlee.Limits[CombatZones.Far] = 4.5
CombatStyles.HobbeGruntCantFlee.Limits[CombatZones.Left] = 2
CombatStyles.HobbeGruntCantFlee.Limits[CombatZones.Right] = 2
CombatStyles.HobbeGruntCantFlee.Limits[CombatZones.Rear] = 2.5
CombatStyles.HobbeGruntCantFlee.DoSpotTargetAnim = true
CombatStyles.HobbeGruntCantFlee.CanFlee = false
CombatStyles.HobbeGruntCantFlee.FleeAnim = "Flee"
CombatStyles.HobbeGruntCantFlee.FleeIntoAnim = "FleeInto"
CombatStyles.HobbeGruntCantFlee.InstantFleeCreatureTypes = ECreatureType.CREATURE_TROLL
CombatStyles.HobbeGruntCantFlee.MinSecondsBetweenMeleeAttacks = 1
CombatStyles.HobbeGruntCantFlee.SecondsToWaitAfterTargetIsHit = 1.5
CombatStyles.HobbeGruntCantFlee.MinSecondsBetweenRangedAttacks = 4
CombatStyles.HobbeGruntCantFlee.Enrage = {}
CombatStyles.HobbeGruntCantFlee.Enrage.Anim = "CombatRoar"
CombatStyles.HobbeGruntCantFlee.Enrage.DamageMultiplier = 1.1
CombatStyles.HobbeGruntCantFlee.Enrage.SpeedMultiplier = 1.1
CombatStyles.HobbeGruntCantFlee.Enrage.Duration = 5
CombatStyles.HobbeGruntCantFlee.Sequences = {}
CombatStyles.HobbeGruntCantFlee.Sequences[CombatSituations.Melee] = {
	"HobbeHeroFlourishResponse",
	"HobbeLeftAttack",
	"HobbeRightAttack",
	"HobbeRearAttack",
	"HobbeAttackCombo",
	"HobbeCloseAttackCombo",
	"HobbeFarAttackCombo",
	"Idle",
	"IdleStrafe",
	"BackOff"
}
CombatStyles.HobbeGruntCantFlee.Sequences[CombatSituations.Ranged] = {
	"RangedIdle"
}
CombatStyles.HobbeGruntCantFlee.ValidStates = CombatStyles.StandardCombatStates
CombatStyles.HobbeGruntCantFlee.ShootingBalanceData = CombatStyles.ShootingBalanceDataDefault


-- uncomment for debug
-- GUI.DisplayMessageBox("hobbecombatstyles.lua successfully loaded!")
-- while (GUI.IsDisplayBoxActive()) do
	-- coroutine.yield()
-- end